/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview;

import java.util.Vector;

import org.apache.log4j.Logger;

import butterfly.xmlview.model.interfaces.IMultiNode;
import butterfly.xmlview.model.interfaces.INode;

public class ProjectFolder extends ProjectElement implements IProjectFolder,IMultiNode{
		private String name_;
		private IProjectFolder parent_;
		private Vector folders_;
		private Vector files_;
		private Logger logger_=Logger.getLogger(ProjectFolder.class);
		protected static final String foldersStartTag_ = "<"+SUB_FOLDERS_TAG+">";
		protected static final String foldersEndTag_ = "</"+SUB_FOLDERS_TAG+">";
		protected static final String filesStartTag_ = "<"+FILES_TAG+">";
		protected static final String filesEndTag_ = "</"+FILES_TAG+">";
	
		public ProjectFolder(IProjectFolder parent, String name){
			parent_ = parent;
			name_ = name;
			folders_ = new Vector(1);
			files_ = new Vector(1);
		}
/**
 * addChild method comment.
 */
public void addChild(int index, butterfly.xmlview.model.interfaces.INode element) {
	
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param element butterfly.xmlview.model.Element
 */
public void addChild(butterfly.xmlview.model.interfaces.INode element) {}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param com butterfly.xmlview.model.interfaces.IComment
 */
public void addComment(butterfly.xmlview.model.interfaces.IComment com) {}
		public void addFile(IProjectFile file){
			if(file.getParent() != null){
				file.getParentFolder().removeFile(file);
			}
			file.setParentFolder(this);
			file.setProject(getProject());
			files_.add(file);
			if(getProject() != null){getProject().setDirty(true);}
			if(getDocument() != null){getDocument().childAdded(this,file,files_.size()-1);}
		}
		public void addFolder(IProjectFolder f){
			if(f.getParent() != null){
				f.getParentFolder().removeFolder(f);
			}
			f.setParentFolder(this);
			f.setProject(getProject());
			folders_.add(f);
			if(getProject() != null){getProject().setDirty(true);}
			if(getDocument() != null){getDocument().childAdded(this,f,folders_.size()-1);}
		}
		public void addFolder(String path,IProjectFolder folder)throws Exception{
			boolean success = false;
			if(path == null){
				success = true;
				addFolder(folder);
				return;
			}
			if(path.equals("/")){
				success = true;
				addFolder(folder);
				return;
			}
			if(!path.endsWith("/")){
				path += "/";
			}
			int start = 0;
			int end = path.indexOf("/",1);
			String curr = path.substring(start+1,end);
			path = path.substring(end);

			//System.out.println("curr:"+curr);

			for(int i= 0; i < folders_.size(); i++){
				if(((ProjectFolder)folders_.elementAt(i)).getName().equals(curr)){
					((ProjectFolder)folders_.elementAt(i)).addFolder(path,folder);
					success = true;
				}
			}

			if(!success){
				throw new Exception("Invalid path for folder:"+path);
			}
		}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param element butterfly.xmlview.model.Node
 */
public butterfly.xmlview.model.interfaces.INode childAt(int index) {
	if(index < folders_.size()){
		return (INode)folders_.elementAt(index);
	}
	else{
		return (INode)files_.elementAt(index - folders_.size());
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param element butterfly.xmlview.model.Element
 */
public int childCount() {
	return folders_.size() + files_.size();
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param com butterfly.xmlview.model.interfaces.IComment
 */
public butterfly.xmlview.model.interfaces.IComment commentAt(int index) {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param com butterfly.xmlview.model.interfaces.IComment
 */
public int commentCount() {
	return 0;
}
		public IProjectFolder getFolder(String path){
			
			if(path.equals("/")){
				return this;
			}
			if(!path.endsWith("/")){
				path += "/";
			}
			int start = 0;
			int end = path.indexOf("/",1);
			String curr = path.substring(start+1,end);
			path = path.substring(end);

			for(int i= 0; i < folders_.size(); i++){
				if(((ProjectFolder)folders_.elementAt(i)).getName().equals(curr)){
					return ((ProjectFolder)folders_.elementAt(i)).getFolder(path);
					
				}
			}

			return null;
		}
		public String getName(){
			return name_;
		}
/**
 * getParent method comment.
 */
public butterfly.xmlview.model.interfaces.INode getParent() {
	return getParentFolder();
}
		public IProjectFolder getParentFolder(){
			return parent_;
		}
		public String getPath(){
			String parentpath = "";
			if(getParent() != null){
				parentpath = getParentFolder().getPath();
			}
			return parentpath + "/"+getName();
		}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param element butterfly.xmlview.model.Node
 */
public int indexOfChild(butterfly.xmlview.model.interfaces.INode child) {
	return 0;
}
		public IProjectFile[] listFiles(){
			return ((ProjectFile[])files_.toArray(new ProjectFile[0]));
		}
		public IProjectFolder[] listFolders(){
			return ((ProjectFolder[])folders_.toArray(new ProjectFolder[0]));
		}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param element butterfly.xmlview.model.Element
 */
public void removeChild(butterfly.xmlview.model.interfaces.INode attr) {
		
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param element butterfly.xmlview.model.Element
 */
public void removeChildAt(int index) {
	if(index < folders_.size()){
		folders_.removeElementAt(index);
	}
	else{
		files_.removeElementAt(index - folders_.size());
	}
	if(getProject() != null){getProject().setDirty(true);}
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:14:30 PM)
 * @param com butterfly.xmlview.model.interfaces.IComment
 */
public void removeComment(butterfly.xmlview.model.interfaces.IComment com) {}
		public void removeFile(IProjectFile file){
			if(files_.contains(file)){
				files_.remove(file);
			}
		}
		public void removeFile(String file){
			for(int i = 0; i < files_.size(); i++){
				if(((ProjectFile)files_.elementAt(i)).getName().equals(file)){
					removeFile(((ProjectFile)files_.elementAt(i)));
					if(getProject() != null){getProject().setDirty(true);}
				}
			}
			
		}
		public void removeFolder(IProjectFolder f){
			logger_.debug("removing "+f+" from "+getName());
			if(folders_.contains(f)){
				folders_.remove(f);
				if(getProject() != null){getProject().setDirty(true);}
			}
		}
		public void setName(String name){
			name_ = name;
		}
/**
 * setParent method comment.
 */
public void setParent(butterfly.xmlview.model.interfaces.INode newParent) {
	//setParent((IProjectFolder)newParent);	
}
		public void setParentFolder(IProjectFolder parent){
			parent_ = parent;
		}
		public String toString(){
			return getName();
		}
/**
 * Insert the method's description here.
 * Creation date: (11/9/2002 10:45:05 AM)
 * @return java.lang.String
 */
public String toXml() {
	StringBuffer buffer = new StringBuffer("<");
	buffer.append(PROJECT_FOLDER_TAG);
	buffer.append(" ");
	buffer.append(PROJECT_FOLDER_NAME_ATTRIBUTE);
	buffer.append("=\"");
	buffer.append(getName());
	buffer.append("\">\n");
	buffer.append(foldersStartTag_);
	buffer.append("\n");
	IProjectFolder[] folders = listFolders();
	for(int i = 0; i < folders.length; i++){
		buffer.append(folders[i].toXml());
		buffer.append("\n");
	}
	buffer.append(foldersEndTag_);
	buffer.append("\n");
	buffer.append(filesStartTag_);
	buffer.append("\n");
	IProjectFile[] files = listFiles();
	for(int i = 0;i < files.length; i++){
		buffer.append(files[i].toXml());
		buffer.append("\n");
	}
	buffer.append(filesEndTag_);
	buffer.append("</");
	buffer.append(PROJECT_FOLDER_TAG);
	buffer.append(">");
	return buffer.toString();
}
	/**
	 * @see butterfly.xmlview.model.Node#createNode()
	 */
	protected INode createNode() {
		return null;
	}

}
