/*
 * $Id: FOViewer.java,v 1.3 2004/06/06 22:34:59 juleswhite Exp $
 * ============================================================================
 *                    The Apache Software License, Version 1.1
 * ============================================================================
 *
 * Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modifica-
 * tion, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The end-user documentation included with the redistribution, if any, must
 *    include the following acknowledgment: "This product includes software
 *    developed by the Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself, if
 *    and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "FOP" and "Apache Software Foundation" must not be used to
 *    endorse or promote products derived from this software without prior
 *    written permission. For written permission, please contact
 *    apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache", nor may
 *    "Apache" appear in their name, without prior written permission of the
 *    Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * APACHE SOFTWARE FOUNDATION OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLU-
 * DING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ============================================================================
 *
 * This software consists of voluntary contributions made by many individuals
 * on behalf of the Apache Software Foundation and was originally created by
 * James Tauber <jtauber@jtauber.com>. For more information on the Apache
 * Software Foundation, please see <http://www.apache.org/>.
 */
package butterfly.xmlview.fop;

//Java
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;

//JAXP
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.Source;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.sax.SAXResult;

//Avalon
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.logger.ConsoleLogger;
//import org.apache.avalon.framework.logger.ConsoleLogger;

//FOP
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;

/**
 * This class demonstrates the use of the AWT Viewer.
 */
public class FOViewer {

	private Source xml_;
	private Source xsl_;
    public static final String TRANSLATION_PATH =
        "/org/apache/fop/viewer/resources/";
    private PreviewPane frame_;
    private AWTRenderer renderer_;
    private Driver driver_;
    private Translator translator_;
    
    protected PreviewPane createPreviewDialog(
                AWTRenderer renderer,
                Translator res) {
        PreviewPane frame = new PreviewPane(this,renderer, res);
        frame.validate();
//        frame.addWindowListener(new WindowAdapter() {
//                public void windowClosed(WindowEvent we) {
//                    System.exit(0);
//                }
//            });

        // center window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height)
            frameSize.height = screenSize.height;
        if (frameSize.width > screenSize.width)
            frameSize.width = screenSize.width;
        frame.setLocation((screenSize.width - frameSize.width) / 2,
                          (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        frame_=frame;
        return frame;
    }

    private SecureResourceBundle getResourceBundle(String path) throws IOException {
        URL url = getClass().getResource(path);
        if (url == null) {
            // if the given resource file not found, the english resource uses as default
            path = path.substring(0, path.lastIndexOf(".")) + ".en";
            url = getClass().getResource(path);
        }
        return new SecureResourceBundle(url.openStream());
    }

    public Component viewFOLater(Source xml, Source xsl)throws Exception{
    	if(frame_==null){
    		init();
    	}
    	xml_=xml;
    	xsl_=xsl;
    	Runnable r = new Runnable() {
			public void run() {
				// TODO Auto-generated method stub
				try{
					renderFO();
				}catch (Exception e) {
					// TODO: handle exception
					e.printStackTrace();
				}
			}
		};
    	Thread t = new Thread(r);
    	t.start();
    	return frame_;
    }
    
    public Translator getTranslator(){
    	String language = System.getProperty("user.language");
    	Translator translator=null;
    	try{
    	translator = getResourceBundle(
    			TRANSLATION_PATH + "resources." + language);
    	translator.setMissingEmphasized(false);

    	UserMessage.setTranslator(getResourceBundle(
    			TRANSLATION_PATH + "messages." + language));
    	}catch(Exception e){
    		e.printStackTrace();
    	}
    	return translator;
    }
    
    public void init()
                throws IOException, FOPException, TransformerException {
    	
       
    	translator_ = getTranslator();
        //Setup renderer
        AWTRenderer renderer = new AWTRenderer(translator_);
        renderer_=renderer;
        //Create preview dialog (target for the AWTRenderer)
        PreviewPane frame = createPreviewDialog(renderer, translator_);
        renderer.setProgressListener(frame);
        renderer.setComponent(frame);
     //   renderer.setComponent(parent_);
        //Setup Driver
        Driver driver = new Driver();
        driver_=driver;
        //driver.setLogger(new ConsoleLogger(ConsoleLogger.LEVEL_DEBUG));
        driver.setRenderer(renderer);     
 }
    public Component viewFO(Source xml, Source xsl)
    throws IOException, FOPException, TransformerException {
    	xml_=xml;
    	xsl_=xsl;
    	return renderFO();
    }

   public Component renderFO()
        throws IOException, FOPException, TransformerException {
   		if(frame_==null){
   			init();
   		}
       
        	//Setup l18n
//Make sure the XSL transformation's result is piped through to FOP
        Result res = new SAXResult(driver_.getContentHandler());

//Setup XML input
    
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer stransformer = null;
        if(xsl_!=null){
        	stransformer=transformerFactory.newTransformer(xsl_);
        }
        else{
        	stransformer=transformerFactory.newTransformer();
        }
        
//Start the transformation and rendering process
       
        frame_.progress("Rendering Document ...");
        stransformer.transform(xml_, res);

        try {
            // build FO tree: time
           

//            //Load XSL-FO file (you can also do an XSL transformation here)
//            TransformerFactory factory = TransformerFactory.newInstance();
//            Transformer transformer = factory.newTransformer();
//            Source src = new StreamSource(fo);
//            Result res = new SAXResult(driver.getContentHandler());
//            transformer.transform(src, res);

            //Show page
            frame_.progress(translator_.getString("Done"));
            frame_.showPage();
          
            return frame_;
        } catch (Exception e) {
         //   frame.reportException(e);
            if (e instanceof FOPException) {
                throw (FOPException)e;
            }
            throw new FOPException(e);
        }
        
    }
    
    public void reload()
    throws IOException, FOPException, TransformerException {
    	
    	//Setup l18n
//    	String language = System.getProperty("user.language");
//    	Translator translator = getResourceBundle(
//    			TRANSLATION_PATH + "resources." + language);
//    	translator.setMissingEmphasized(false);
//
//    	UserMessage.setTranslator(getResourceBundle(
//    			TRANSLATION_PATH + "messages." + language));
//
//    	//Setup renderer
//    	AWTRenderer renderer = new AWTRenderer(translator);

    	//Create preview dialog (target for the AWTRenderer)
    	//PreviewPane frame =frame_;
    	//frame.setRenderer(renderer_);
    	//renderer.setProgressListener(frame);
    	//renderer.setComponent(frame);
    	//   renderer.setComponent(parent_);
    	//Setup Driver
    	//Driver driver = new Driver();
    	
    	//driver.setLogger(new ConsoleLogger(ConsoleLogger.LEVEL_DEBUG));
    	//driver.setRenderer(renderer_);     



//Make sure the XSL transformation's result is piped through to FOP
    	Result res = new SAXResult(driver_.getContentHandler());

//Setup XML input
    	
    	TransformerFactory transformerFactory = TransformerFactory.newInstance();
    	Transformer stransformer = null;
    	if(xsl_!=null){
    		stransformer=transformerFactory.newTransformer(xsl_);
    	}
    	else{
    		stransformer=transformerFactory.newTransformer();
    	}

//Start the transformation and rendering process
    	
    	frame_.progress(("Build FO tree") + " ...");
    	stransformer.transform(xml_, res);

    	try {
    		// build FO tree: time
    		

//            //Load XSL-FO file (you can also do an XSL transformation here)
//            TransformerFactory factory = TransformerFactory.newInstance();
//            Transformer transformer = factory.newTransformer();
//            Source src = new StreamSource(fo);
//            Result res = new SAXResult(driver.getContentHandler());
//            transformer.transform(src, res);

    		//Show page
    		frame_.progress(("Show"));
    		frame_.showPage();
    		//return frame;
    	} catch (Exception e) {
    		//   frame.reportException(e);
    		if (e instanceof FOPException) {
    			throw (FOPException)e;
    		}
    		throw new FOPException(e);
    	}
    	
    }
}
