/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.util.Hashtable;

import butterfly.xmlview.ButterflyProject;
import butterfly.xmlview.IProjectElement;
import butterfly.xmlview.IProjectFolder;
import butterfly.xmlview.ProjectFile;
import butterfly.xmlview.gui.tree.DocumentTree;
import butterfly.xmlview.gui.tree.DocumentTreeModel;
import butterfly.xmlview.gui.tree.ProjectTreeEditor;
import butterfly.xmlview.gui.tree.ProjectXmlTreeEditor;
import butterfly.xmlview.gui.tree.TreeEditorLookup;
import butterfly.xmlview.model.AbstractDocument;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.interfaces.IComment;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IValueNode;
/**
 * Insert the type's description here.
 * Creation date: (11/25/2002 2:04:09 PM)
 * @author: 
 */
public class AdvancedProjectBrowser extends DocumentTree implements  butterfly.xmlview.gui.interfaces.IProjectBrowser {
	protected class ProjectBrowserDocument extends AbstractDocument{
		private DocumentRoot root_;
		
		/**
		 * Constructor for ProjectBrowserDocument.
		 * @param contenttype
		 */
		public ProjectBrowserDocument() {
			super("text/project-xml");
		}

		/**
		 * @see butterfly.xmlview.model.interfaces.IDocument#getRoot()
		 */
		public INode getRoot() {
			if(root_ == null){
				root_ = new DocumentRoot();
				root_.setDocument(this);
				//ProjectFolder openfiles = new ProjectFolder(null,"Open Files");
				//openfiles.setDocument(this);
				//root_.addChild(openfiles);
				
				//openFiles_ =openfiles;
			}
			return root_;
		}

	}
	
	private Hashtable openProjects_ = new Hashtable();
	private IDocument project_;
	private IProjectFolder openFiles_;
	
/**
 * AdvancedProjectBrowser constructor comment.
 * @param t javax.swing.tree.DefaultTreeModel
 */
public AdvancedProjectBrowser() {
	super(new DocumentTreeModel(new javax.swing.tree.DefaultMutableTreeNode("Project Files")));
	
	((DocumentTreeModel)getTreeModel()).setTree(this);
	//setRootVisible(false);
	TreeEditorLookup lookup = new TreeEditorLookup();
	lookup.registerTreeEditor(IProjectElement.class,new ProjectTreeEditor(this));

	ProjectXmlTreeEditor ed = new ProjectXmlTreeEditor();
	//lookup.registerTreeEditor(String.class,new BasicTreeEditor());
	lookup.registerTreeEditor(IElement.class, ed);
	lookup.registerTreeEditor(IValueNode.class,ed );
	lookup.registerTreeEditor(IDocumentDeclaration.class, ed);
	lookup.registerTreeEditor(IComment.class, ed);
	lookup.registerTreeEditor(IDTDNode.class, ed);
	lookup.registerTreeEditor(butterfly.xmlview.model.interfaces.IProcessingInstruction.class,ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
	setTreeEditorLookup(lookup);
	//setEditable(true);
	//getViewport().setView(dtree_);
	loadDefaultDocument();
	
}
/**
 * AdvancedProjectBrowser constructor comment.
 * @param t javax.swing.tree.DefaultTreeModel
 */
public AdvancedProjectBrowser(javax.swing.tree.DefaultTreeModel t) {
    super(t);
    //setRootVisible(false);
	//dtree_ = new DocumentTree(t);
   	TreeEditorLookup lookup = new TreeEditorLookup();
	lookup.registerTreeEditor(IProjectElement.class,new ProjectTreeEditor(this));

	ProjectXmlTreeEditor ed = new ProjectXmlTreeEditor();
	lookup.registerTreeEditor(IElement.class, ed);
	lookup.registerTreeEditor(IValueNode.class,ed );
	lookup.registerTreeEditor(IDocumentDeclaration.class, ed);
	lookup.registerTreeEditor(IComment.class, ed);
	lookup.registerTreeEditor(IDTDNode.class, ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
	setTreeEditorLookup(lookup);
	//getViewport().setView(dtree_);
	loadDefaultDocument();

}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:05:11 PM)
 * @return butterfly.xmlview.IProject
 */
public butterfly.xmlview.IProject getProject() {
	return null;// project_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/2002 2:04:09 PM)
 * @param p butterfly.xmlview.IProject
 */
public void loadProject(butterfly.xmlview.IProject p) {
	if(openProjects_.get(p) != null){return;}
	openProjects_.put(p,Boolean.TRUE);
	//project_ = p;
	//loadDocument(p);
	//project_.addChild(project_.getRoot(),new DocumentNode(p),project_.getRoot().childCount());
	String name = (p.getProperty(ButterflyProject.PROJECT_NAME_KEY));
//	ProjectFolder pname = new ProjectFolder(null,name);
//	
////	pname.setDocument(p);
//	System.out.println("project:"+pname);
	addNode(getTreeNode(project_.getRoot()),p.getRoot());
	//addNode(getTreeNode(pname),p.getRoot());
	//Object node = getTreeNode(p.getRoot());
	//System.out.println("tree node:"+node);
	ensureVisible(p.getRoot());
	//expandAll(this,true);
//	DefaultMutableTreeNode root = (DefaultMutableTreeNode)getModel().getRoot();
//	TreePath path = new TreePath(root.getPath());
//	expandPath(path);
//	Enumeration children = root.children();
//	while(children.hasMoreElements()){
//		DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
//		expandPath(new TreePath(child.getPath()));	
//	}
	expandColumn(2);
}



protected void loadDefaultDocument(){
	project_ = new ProjectBrowserDocument();
	loadDocument(project_,false);
	
}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IProjectBrowser#addOpenDocument(IDocument)
	 */
public void addOpenDocument(IDocument doc) {
		if( doc != null){
		ProjectFile file = new ProjectFile(doc.getSourceFileName());
		
		System.out.println("adding doc "+doc.getSourceFileName());
		//project_.addChild(project_.getRoot().childAt(0),file,0);
		openFiles_.addFile(file);
		}
		//loadDocument(project_);
		//getTreeEditor(file);
}

}
