/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.interfaces.IValidatedDocument;
/**
 * Insert the type's description here.
 * Creation date: (12/4/2002 9:46:52 AM)
 * @author: 
 */
public class AttributesEditor extends javax.swing.JPanel implements TableModelListener , ListSelectionListener{

	private static Icon close_ = UIManager.getIcon("InternalFrame.closeIcon");
	private static final Icon trash_ = new ImageIcon("icons/stock_delete-16.png");

	private JScrollPane scrollPane_;
	private JTable table_;
	private IElement element_;
	private int attributeCount_ = 1;
	private DefaultTableModel tableModel_;
/**
 * AttributesEditor constructor comment.
 */
public AttributesEditor() {
	super();
	
	setLayout(new GridBagLayout());

	GridBagConstraints lcons = new GridBagConstraints();
	lcons.fill = GridBagConstraints.HORIZONTAL;
	lcons.weightx = 1;
	lcons.weighty =0;
	lcons.gridx = 0;
	lcons.gridy = 0;

	//JLabel label = new JLabel("Attributes:");
	//add(label,lcons);

	
	GridBagConstraints cons = new GridBagConstraints();
	cons.fill = GridBagConstraints.BOTH;
	cons.weightx = 1;
	cons.weighty = 1;
	cons.gridx = 0;
	cons.gridy = 1;
	cons.gridwidth = 2;
	cons.insets=new Insets(0,0,0,0);

	Object[] cols = {"Name","Value",""};
	tableModel_ = new DefaultTableModel(cols,0){
		public boolean isCellEditable(int row, int column){
			if(row+column==0){
				return false;	
			}	
			return true;
		}	
		public Class getColumnClass(int c){
			if(c==2){
				return Icon.class;	
			}	
			else{
				return String.class;	
			}
		}
		public String getColumnName(int col){
			switch (col) {
				case 0 :
					return "Attribute";
					//break;

				case 1 :
					//break;
					return "Value";
				case 2 : 
					return "";
			}	
			return "";
		}
	};
	DefaultTableColumnModel tm = new DefaultTableColumnModel();
	tm.addColumn(new TableColumn(0));
	tm.addColumn(new TableColumn(1));
	tm.addColumn(new TableColumn(2,16));
	tm.getColumn(2).setMaxWidth(16);
	tm.getColumn(2).setPreferredWidth(16);
	tm.getColumn(2).setWidth(16);
	tm.getColumn(2).setHeaderRenderer(
		new DefaultTableCellRenderer(){
			public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column){
				Component comp=super.getTableCellRendererComponent(table,value,isSelected,hasFocus,row,column);
				((JLabel)comp).setIcon(close_);
				return comp;
			}	
		}
	);
	table_ = new JTable(tableModel_,tm);
	table_.getSelectionModel().addListSelectionListener(this);
	//table_.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	//table_.getColumn("").setWidth(16);
	table_.getColumnModel().getColumn(2).setPreferredWidth(16);
	table_.setUI(new TableUI());
	//table_.getColumn("").setCellRenderer(new DefaultCellEditor();
	tableModel_.addTableModelListener(this);
	table_.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
	//scrollPane_ = new JScrollPane(table_);
	//add(scrollPane_,cons);
	cons.fill=GridBagConstraints.HORIZONTAL;
	table_.setAutoCreateColumnsFromModel(true);
	table_.getTableHeader().setBorder(new EmptyBorder(0,0,0,0));
	//table_.getTableHeader().set
	add(table_.getTableHeader(),cons);
	cons.gridy++;
	cons.fill=GridBagConstraints.BOTH;
	
	add(table_,cons);
	//table_.setc
	
//	GridBagConstraints acons = new GridBagConstraints();
//	acons.fill = acons.HORIZONTAL;
//	acons.weightx = 1;
//	acons.weighty =0;
//	acons.gridx = 0;
//	acons.gridy = 2;
//	acons.anchor = acons.CENTER;

//	JButton add = new JButton("Add");
//	add.setSize(add.getWidth(),30);
//	add.addActionListener(
//		new ActionListener(){	
//			public void actionPerformed(java.awt.event.ActionEvent a){
//				add();
//			}
//		}
//	);
//	add(add,acons);
//
//	GridBagConstraints bcons = new GridBagConstraints();
//	bcons.fill = acons.HORIZONTAL;
//	bcons.weightx = 1;
//	bcons.weighty =0;
//	bcons.gridx = 1;
//	bcons.gridy = 2;
//	bcons.anchor = bcons.CENTER;
//
//	JButton remove = new JButton("Remove");
//	remove.setSize(remove.getWidth(),20);
//	remove.addActionListener(
//		new ActionListener(){	
//			public void actionPerformed(java.awt.event.ActionEvent a){
//				remove();
//			}
//		}
//	);
//	add(remove,bcons);
	Element el = new Element("Attributes Editor");
	el.addAttribute(new Attribute("description","You can edit an element's attributes here."));
	edit(el);
}
/**
 * Insert the method's description here.
 * Creation date: (12/4/2002 10:02:35 AM)
 */
public void add() {
	String[] row = {"NewAttribute"+attributeCount_,""};
	attributeCount_++;
	tableModel_.addRow(row);
}


/**
 * Insert the method's description here.
 * Creation date: (12/4/2002 11:13:06 AM)
 * @param el butterfly.xmlview.model.interfaces.IElement
 */
public void edit(IElement el) {
	IDocument doc = el.getDocument();
	String[] attrs = null;
	while(tableModel_.getRowCount()>0){
		tableModel_.removeRow(0);	
	}
	if(doc != null && doc instanceof IValidatedDocument){
		IElementStructure str = (IElementStructure)((IValidatedDocument)doc).getValidationDocument().getNodeStructure(el);
		if(str != null){
		attrs = new String[str.attributeCount()];
		for(int i = 0; i < attrs.length; i++){
			attrs[i] = str.attributeAt(i);	
		}
		JComboBox dfa = new JComboBox(attrs);
		dfa.setEditable(true);
		table_.getColumn("Attribute").setCellEditor(new DefaultCellEditor(dfa));
		}
	}
	
	
	attributeCount_ = 0;
	tableModel_.removeTableModelListener(this);
	element_ =el;
	//for(int i = 0; i < tableModel_.getRowCount(); i++){
	while(tableModel_.getRowCount()>0){
		tableModel_.removeRow(0);
	}
	tableModel_.addRow(new Object[]{"Element Name",el.getName(),null});
	//table_.setc
	IAttribute attr = null;
	for(int i = 0; i < el.attributeCount(); i++){
		attr = el.attributeAt(i);
		JButton close = new JButton(close_);
//		close.addActionListener(
//			new ActionListener(){
//				public void actionPerformed(ActionEvent ae){
//					setVisible(false);	
//				}	
//			}
//		);
		close.setBorder(new EmptyBorder(0,0,0,0));
		close.setSize(close_.getIconWidth(),close_.getIconHeight());
		Object[] data = {attr.getName(),attr.getData(),close_};
		tableModel_.addRow(data);		
	}
	String[] blankdata = {"",""};
	for(int i = 0; i < 10; i++){
		tableModel_.addRow(blankdata);
	}
	tableModel_.addTableModelListener(this);
	
	table_.getColumnModel().getColumn(2).setPreferredWidth(18);
	table_.getColumnModel().getColumn(2).setMaxWidth(18);
	table_.getColumnModel().getColumn(2).setHeaderRenderer(
		new DefaultTableCellRenderer(){
			public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column){
				Component comp=super.getTableCellRendererComponent(table,value,isSelected,hasFocus,row,column);
				((JLabel)comp).setIcon(trash_);
				((JLabel)comp).setOpaque(false);
				return comp;
			}	
		}
	);
}
/**
 * Insert the method's description here.
 * Creation date: (12/4/2002 9:54:14 AM)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	JFrame f = new JFrame();
	AttributesEditor e = new AttributesEditor();
	f.setContentPane(e);
	f.setSize(300,300);
	f.show();

	Element el = new Element("something");
	Attribute a1 = new Attribute(el,"role");
	a1.setData("butterfly.xmlview.model.IAttribute");
	Attribute a2 = new Attribute(el,"id");
	a2.setData("Element");
	el.addAttribute(a1);
	el.addAttribute(a2);
	e.edit(el);
}
/**
 * Insert the method's description here.
 * Creation date: (12/4/2002 10:02:35 AM)
 */
public void remove() {

	int toremove = table_.getSelectionModel().getMinSelectionIndex();
	if(toremove > -1){
		tableModel_.removeRow(toremove);
	}
}
	/**
	 * This fine grain notification tells listeners the exact range
	 * of cells, rows, or columns that changed.
	 */
public void tableChanged(TableModelEvent e) {
	element_.clearAttributes();
	
	if(e.getFirstRow()==0 && tableModel_.getRowCount()>0){
		element_.setName((String)tableModel_.getValueAt(0,1));	
	}
	
	for(int i = 1; i < tableModel_.getRowCount(); i++){
	  
      String column = tableModel_.getColumnName(0);
      String vcolumn = tableModel_.getColumnName(1);
      String name = (String)tableModel_.getValueAt(i, 0);
      String value = (String)tableModel_.getValueAt(i,1);
      if(name.trim().length() > 0){
		Attribute attr = new Attribute(element_,name);
		value = value.replaceAll("[\\<]","&lt;");
		value = value.replaceAll("[\\>]","&gt;");
		value = value.replaceAll("[\\\"]","&quot;");
		value = value.replaceAll("[\\\']","&apos;");
		attr.setData(value);
		element_.addAttribute(attr);
      }
	}
	if(element_.getDocument() != null){
		element_.getDocument().updateNode(element_,true);
			
	}
	//System.out.println("element:"+element_.toString());
}
	/**
	 * @see javax.swing.event.ListSelectionListener#valueChanged(ListSelectionEvent)
	 */
	public void valueChanged(ListSelectionEvent e) {
		if (e.getSource() == table_.getSelectionModel()
                  && table_.getRowSelectionAllowed()) {
                // Column selection changed
                int last = e.getFirstIndex();
                
                if(table_.getSelectedColumn()==2){
                	if(table_.getSelectedRow()>0){
                		tableModel_.removeRow(table_.getSelectedRow());
                	}
                }
                //int last = e.getLastIndex();
            } 
	}

}
