/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.xmlview.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;

import butterfly.xmlview.gui.interfaces.IBrowserManager;
import butterfly.xmlview.io.XmlViewFileSystem;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class BrowserManager implements IBrowserManager,Configurable{
	
	
	private Hashtable browsers_ = new Hashtable(1);
	private String browserListLocation_=null;
	/**
	 * 
	 */
	public BrowserManager() {
		super();
		// TODO Auto-generated constructor stub
	}
	

	public void configure(Configuration arg1){
		try{
			
		browserListLocation_ = arg1.getAttribute(BROWSER_FILE_ATTRIBUTE,"none");
		DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
		Configuration conf = builder.buildFromFile(new File(browserListLocation_));
		
			
		
		Configuration[] children = conf.getChildren();
		String name = null;
		String cmd = null;
		for(int i = 0; i < children.length; i++){
			name = children[i].getAttribute(BROWSER_NAME_ATTRIBUTE,"Unknown Browser");
			cmd = children[i].getAttribute(BROWSER_COMMAND_ATTRIBUTE,"");
			addBrowser(name,cmd);
		}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public void addBrowser(String name, String launchcommand) {
		Browser b = new Browser(name,launchcommand);
		addBrowser(b);
	}
	
	public void addBrowser(Browser b){
		browsers_.put(b.name,b);
		try{
			saveBrowserList();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	
	
	public void saveBrowserList() throws Exception{
		String xml = toXml();
		XmlViewFileSystem.saveFileS(browserListLocation_,xml);
	}
	
	public String toXml(){
		String xml ="<browsers>\n";
		Enumeration keys = browsers_.keys();
		while(keys.hasMoreElements()){
			Browser b = (Browser)browsers_.get(keys.nextElement());
			xml += "<browser name=\""+b.name+"\" command=\""+b.command+"\"/>\n";
		}
		xml += "</browsers>";
		return xml;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IBrowserManager#getBrowser(java.lang.String)
	 */
	public Browser getBrowser(String name) {
		// TODO Auto-generated method stub
		return (Browser)browsers_.get(name);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IBrowserManager#getBrowserNames()
	 */
	public String[] getBrowserNames() {
		// TODO Auto-generated method stub
		return (String[])browsers_.keySet().toArray(new String[0]);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IBrowserManager#removeBrowser(java.lang.String)
	 */
	public void removeBrowser(String name) {
		browsers_.remove(name);
		try{
			saveBrowserList();
		}catch(Exception e){}
	}

}
