/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.xmlview.gui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.interfaces.IBrowserManager;
import butterfly.xmlview.gui.interfaces.IComponent;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class BrowserManagerGui extends JFrame implements IComponent,IComponentRequester{
	private IComponentLookup lookup_;
	private JList browserList_;
	private JButton addButton_;
	private JButton removeButton_;
	private JDialog addDialog_;
	private JTextField browserName_;
	private JTextField browserCmd_;
	private JFileChooser browserCommandChooser_;
	
	/**
	 * 
	 */
	public BrowserManagerGui() {
		super();
		init();
	}



	public void init(){
		
		setSize(300,300);
		
		addWindowListener(
			new WindowAdapter(){
				public void windowOpened(WindowEvent we){
					refreshBrowserList();
				}
			}
		);
		
		Container content = getContentPane();
		content.setLayout(new GridBagLayout());
		
		GridBagConstraints cons = new GridBagConstraints(0,0,1,1,0,0,GridBagConstraints.NORTHWEST,GridBagConstraints.NONE,new Insets(0,0,0,0),0,0);
		cons.fill = GridBagConstraints.BOTH;
		cons.weightx=1;
		cons.weighty=1;
		cons.gridwidth=2;
		cons.gridheight=4;
		
		browserList_ = new JList();
		content.add(new JScrollPane(browserList_),cons);
		
		cons.gridwidth=1;
		cons.gridy = 4;
		cons.fill=GridBagConstraints.HORIZONTAL;
		cons.weighty=0;
		
		addButton_ = new JButton("Add");
		addButton_.addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						add();
					}
				}
		);
		content.add(addButton_,cons);
		
		cons.gridx=1;
		removeButton_ = new JButton("Remove");
		removeButton_.addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						remove();
					}
				}
		);
		content.add(removeButton_,cons);
		
		
		
		addDialog_ = new JDialog(this,true);
		addDialog_.setResizable(false);
		addDialog_.setSize(300,150);
		Container addcontent = addDialog_.getContentPane();
		addcontent.setLayout(new GridBagLayout());
		cons.gridx=0;
		cons.gridy=0;
		cons.gridheight=1;
		cons.weightx=0;
		addcontent.add(new JLabel("Browser Name:"),cons);
		cons.gridx++;
		cons.weightx=1;
		cons.fill=GridBagConstraints.HORIZONTAL;
		browserName_=new JTextField();
		browserName_.setSize(browserName_.getHeight(),200);
		addcontent.add(browserName_,cons);
		cons.gridx=0;
		cons.gridy++;
		cons.weightx=0;
		cons.fill=GridBagConstraints.NONE;
		addcontent.add(new JLabel("Browser Location:"),cons);
		browserCmd_=new JTextField();
		cons.gridx++;
		cons.weightx=1;
		cons.fill=GridBagConstraints.HORIZONTAL;
		browserCmd_.setSize(browserCmd_.getHeight(),200);
		addcontent.add(browserCmd_,cons);
		JButton find = new JButton("...");
		find.addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						findBrowserCommand();
					}
				}
		);
		cons.gridx++;
		cons.weightx=0;
		cons.fill=GridBagConstraints.NONE;
		addcontent.add(find,cons);
		cons.gridy++;
		cons.anchor=GridBagConstraints.SOUTHEAST;
		JButton ok = new JButton("Ok");
		ok.addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						addDialog_.setVisible(false);
						addBrowser(browserName_.getText().trim(),browserCmd_.getText().trim());
					}
				}
		);
		addcontent.add(ok,cons);
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						addDialog_.setVisible(false);
					}
				}
		);
		cons.gridx++;
		addcontent.add(cancel,cons);
		cons.fill=GridBagConstraints.BOTH;
		cons.weighty=1;
		addcontent.add(new JPanel(),cons);
		browserCommandChooser_ = new JFileChooser();
	}
	
	public static void main(String[] args){
		BrowserManagerGui gui = new BrowserManagerGui();
		gui.show();
	}
	
	public void add(){
		addDialog_.show();
	}
	
	public void findBrowserCommand(){
		int success = browserCommandChooser_.showDialog(this,"Ok");
		if(success == JFileChooser.APPROVE_OPTION){
			browserCmd_.setText(browserCommandChooser_.getSelectedFile().getPath());
		}
	}
	
	protected void refreshBrowserList(){
		String[] names = getBrowserManager().getBrowserNames();
		browserList_.setListData(names);
	}
	
	public void remove(){
		int index = browserList_.getSelectedIndex();
		if(index > -1){
			String name = browserList_.getModel().getElementAt(index).toString();
			getBrowserManager().removeBrowser(name);
			refreshBrowserList();
		}
	}
	
	public void addBrowser(String name, String command){
		Browser b = new Browser(name,command);
		getBrowserManager().addBrowser(b);
		refreshBrowserList();
	}
	
	public IBrowserManager getBrowserManager(){
		return (IBrowserManager)lookup_.getComponent(IBrowserManager.ROLE);
	}
	/* (non-Javadoc)
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
	public void requestComponents() {}

	/* (non-Javadoc)
	 * @see butterfly.components.interfaces.IComponentRequester#setComponentLookup(butterfly.components.interfaces.IComponentLookup)
	 */
	public void setComponentLookup(IComponentLookup lookup) {
		lookup_=lookup;
	}

}
