/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.actions.ButterflyAction;
import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IButterflyAction;
import butterfly.actions.interfaces.IFileCloseAction;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.editors.interfaces.IEditor;
import butterfly.xmlview.gui.editors.interfaces.IEditorSite;
import butterfly.xmlview.gui.editors.interfaces.IEditorSiteManager;
import butterfly.xmlview.gui.editors.interfaces.IMenu;
import butterfly.xmlview.gui.editors.interfaces.IMenuBar;
import butterfly.xmlview.gui.editors.interfaces.IToolBar;
import butterfly.xmlview.gui.editors.interfaces.IToolGroup;
import butterfly.xmlview.gui.interfaces.IButterflyDesktop;
import butterfly.xmlview.gui.interfaces.ILayoutHandler;
/**
 * Insert the type's description here.
 * Creation date: (8/17/2002 12:14:30 AM)
 * @author: 
 */
public class ButterflyDesktop extends JDesktopPane implements IButterflyDesktop, Composable, Configurable, IComponent, IComponentLookup,IComponentRequester,IActionRequester{
	class EMenu implements IMenu{
		private JMenu menu_;
		private Vector items_=new Vector(1);
		public EMenu(JMenu menu){
			menu_=menu;
		}
		
		public String getName(){
			return menu_.getName();
		}
		
		public JMenu getJMenu(){
			return menu_;
		}
		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IMenu#addItem(butterfly.actions.interfaces.IButterflyAction, int)
		 */
		public void addItem(IButterflyAction action, int where) {
			// TODO Auto-generated method stub
			items_.add(action);
			menu_.add((AbstractAction)action);
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IMenu#getItems()
		 */
		public IButterflyAction[] getItems() {
			// TODO Auto-generated method stub
			return (IButterflyAction[])items_.toArray(new IButterflyAction[0]);
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IMenu#removeItem(butterfly.actions.interfaces.IButterflyAction)
		 */
		public void removeItem(IButterflyAction action) {
			// TODO Auto-generated method stub
			int where = items_.indexOf(action);
			items_.remove(where);
			menu_.remove(where);
		}

	}
	
	
	
	class EMenuBar implements IMenuBar{
		private Hashtable menus_=new Hashtable(7);
			/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IMenuBar#createMenu(java.lang.String)
		 */
		public IMenu createMenu(String id) {
			JMenu menu = new JMenu(id);
			//menuBar_.add(menu);
			//menuBar_.revalidate();
			// TODO Auto-generated method stub
			EMenu emen= new EMenu(menu);
			menus_.put(id,emen);
			return emen;
		}
		
		public void hide(){
			Iterator vals = menus_.values().iterator();
			while(vals.hasNext()){
				menuBar_.remove(((EMenu)vals.next()).getJMenu());
			}
			menuBar_.invalidate();
			menuBar_.repaint();
		}
		public void show(){
			Iterator vals = menus_.values().iterator();
			while(vals.hasNext()){
				menuBar_.add(((EMenu)vals.next()).getJMenu());
			}
			menuBar_.revalidate();
			menuBar_.repaint();
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IMenuBar#getMenu(java.lang.String)
		 */
		public IMenu getMenu(String id) {
			// TODO Auto-generated method stub
			
			return (EMenu)menus_.get(id);
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IMenuBar#removeMenu(butterfly.xmlview.gui.editors.interfaces.IMenu)
		 */
		public void removeMenu(IMenu menu) {
			// TODO Auto-generated method stub
			EMenu emen = (EMenu)menu;
			menuBar_.remove(emen.getJMenu());
			menus_.remove(emen.getName());
		}

}
	
	class EToolGroup implements IToolGroup{
		
			/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IToolGroup#addItem(butterfly.actions.interfaces.IButterflyAction)
		 */
		public void addItem(IButterflyAction action) {
			// TODO Auto-generated method stub

		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IToolGroup#removeItem(butterfly.actions.interfaces.IButterflyAction)
		 */
		public void removeItem(IButterflyAction action) {
			// TODO Auto-generated method stub

		}

}
	
	
	class EToolBar implements IToolBar{
		
		

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IToolBar#createGroup(java.lang.String)
		 */
		public IToolGroup createGroup(String name) {
			// TODO Auto-generated method stub
			return null;
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IToolBar#getGroup(java.lang.String)
		 */
		public IToolGroup getGroup(String name) {
			// TODO Auto-generated method stub
			return null;
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IToolBar#removeGroup(butterfly.xmlview.gui.editors.interfaces.IToolGroup)
		 */
		public void removeGroup(IToolGroup group) {
			// TODO Auto-generated method stub

		}

}
	class EditorSite implements IEditorSite,IEditorSiteManager{
		private EMenuBar menuBar_;
		public Component canvas_;
		public Component container_;
			/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IEditorSite#getMenuBar()
		 */
		public IMenuBar getMenuBar() {
			if(menuBar_==null){
				menuBar_=new EMenuBar();
			}
			return menuBar_;
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IEditorSite#getToolBar()
		 */
		public IToolBar getToolBar() {
			// TODO Auto-generated method stub
		
			return null;
		}

	

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IEditorSite#hide()
		 */
		public void hide() {
			// TODO Auto-generated method stub
			if(menuBar_!=null){
				menuBar_.hide();
			}
			if(canvas_!=null){
				canvas_.setVisible(false);
			}
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IEditorSite#show()
		 */
		public void show() {
			// TODO Auto-generated method stub
			if(menuBar_!=null){
				menuBar_.show();
			}
			if(canvas_!=null){
				canvas_.setVisible(true);
			}
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.editors.interfaces.IEditorSiteManager#getEditorSite(butterfly.xmlview.gui.editors.interfaces.IEditor)
		 */
		public IEditorSite getEditorSite(IEditor editor) {
			// TODO Auto-generated method stub
			return this;
		}

}
	
	private static Logger logger_ = Logger.getLogger(ButterflyDesktop.class);
 
	private ComponentManager componentManager_;
	private IComponentLookup componentLookup_;
	private IActionLookup actionLookup_;
	private Configuration configuration_;
	private ILayoutHandler layoutHandler_;
	private JMenuBar menuBar_;
	private JToolBar toolBar_;
	private EditorSite editorSite_=new EditorSite();

	public static final String ICON = "icon";
	public static final String TOOL_NAME_KEY = "name";
	public static final String TOOL_ACTION_ROLE = "role";
	public static final String TOOLBAR_KEY = "toolbar";
	public static final String LAYOUT_MANAGER = "layout-manager";
	public static final String DESKTOP_NAME = "Desktop";
	public static final String DESKTOP_ELEMENTS_KEY = "desktop-elements";
	public static final String DESKTOP_COMPONENTS = "desktop-components";
	public static final String DESKTOP_MENUS_KEY = "desktop-menus";
	public static final String WIDTH_KEY = "width";
	public static final String HEIGHT_KEY = "height";
	public static final String TITLE_KEY = "title";
	public static final String ROLE_KEY = "role";
	public static final String XPOS_KEY = "xpos";
	public static final String YPOS_KEY = "ypos";
	public static final String MENU_ITEM_ACTION_KEY = "action-role";
	public static final String MENU_ITEM_NAME_KEY = "name";
	public static final String MENU_NAME_KEY = "name";
	public static final String COMPONENT_NAME = "name";
	public static final String COMPONENT_ROLE = "role";
	
	private Hashtable components_ = new Hashtable(3);
	private Hashtable actions_ = new Hashtable(17);

	private JFrame frame_;
/**
 * configure method comment.
 */

/**
 * ButterflyDesktop constructor comment.
 */
public ButterflyDesktop() {
	super();
	components_.put(DESKTOP_NAME,this);
}
/**
 * Insert the method's description here.
 * Creation date: (9/3/2002 10:07:47 AM)
 * @param name java.lang.String
 * @param action butterfly.actions.interfaces.IButterflyAction
 */
public void addAction(String name, IButterflyAction action) {
	//action.setLookup(this);
	//action.setActionLookup(this);
	actions_.put(name,action);	
}
/**
 * addComponent method comment.
 */
public void addComponent(IComponent component,String name) {
	//if(component instanceof Component){
		//addComponent((Component)component);
	//}
	if(component instanceof IButterflyAction){
		addAction(name,(IButterflyAction)component);
		return;
	}
	logger_.debug("Registering Key:"+name+" with Component:"+component);
	components_.put(name,component);
	
}
/**
 * addComponent method comment.
 */
public void addComponent(Component component) {
	addComponent(component,component.getName(),component.getName(),-1,-1,-1,-1);
	
}
/**
 * addComponent method comment.
 */
public void addComponent(Component component,String role, String title, int x, int y, int width, int height) {
	/*
	JInternalFrame frame = new JInternalFrame(title);
	logger_.debug("DesktopHeight="+getHeight());
	double xpos = ((double)x) * (((double)getWidth()/100.0));
	double ypos = ((double)y) * (((double)getHeight())/100.0);
	double awidth = ((double)width) * (((double)getWidth())/100.0);
	double aheight = ((double)height) * (((double)getHeight()/100.0));

	logger_.debug("Desktop component for role:"+role+" added at xpos:"+xpos+" ypos:"+ypos+" width:"+awidth+" height:"+aheight);
	
	if(component instanceof Container){
		
		frame.setContentPane((Container)component);
	}
	else{
		frame.getContentPane().setLayout(new GridBagLayout());

		GridBagConstraints constr = new GridBagConstraints();
		constr.gridx = 0;
		constr.gridy = 0;
		constr.weightx = 1.0;
		constr.weighty = 1.0;
		constr.fill = constr.BOTH;
		constr.anchor = GridBagConstraints.NORTH;

		frame.getContentPane().add(component,constr);
	}
	if(awidth > 0 && aheight > 0){
		frame.setSize(new Dimension((int)awidth,(int)aheight));
		frame.setPreferredSize(new Dimension((int)awidth,(int)aheight));
	}
	else{
		logger_.debug("Preferred Size not specified in .conf");
		frame.setSize(component.getPreferredSize());
	}
	if(x > -1 && y > -1){
		frame.setLocation((int)xpos,(int)ypos);
	}

	
	
	
	add(frame);
	frame.setVisible(true);
	frame.setResizable(true);
	component.setVisible(true);
	
	int iwidth = (int)awidth;
	int iheight = (int)aheight;
	//frame.setSize(iwidth,iheight);
	//component.setSize(iwidth,iheight);
	//component.setBackground(java.awt.Color.blue);
	//frame.pack();
	logger_.debug("ComponentSize: "+component.getSize());
	*/
//	layoutHandler_.addComponent()
	components_.put(role,component);
	components_.put(title,component);
	//logger_.debug("Added component "+component+" title:"+title+" xpos:"+x+" ypos:"+y+" width:"+iwidth+" height:"+iheight);
}

public JToolBar buildToolBar(Configuration conf){
	//frame_.gett
	

	JToolBar toolbar = new JToolBar("Butterfly");
	Configuration[] tools = conf.getChildren();
	String name = null;
	String role = null;
	String icon = null;
	JButton button = null;
	for(int i = 0; i < tools.length; i++){
		try{
			role = tools[i].getAttribute(TOOL_ACTION_ROLE);
			name = tools[i].getAttribute(TOOL_NAME_KEY);
			icon = tools[i].getAttribute(ICON,"none");
			logger_.debug("adding name:"+name+" action:"+role+" to the toolbar");
			ButterflyAction action = (ButterflyAction)actionLookup_.getAction(role);
			if(!icon.equals("none")){
				button = new JButton(action);
				button.setToolTipText(name);
				button.setIcon(new ImageIcon(icon));
				toolbar.add(button);
			}
			else{
				button = new JButton(action);
				//button.setAction(action);
				button.setText(null);
				button.setToolTipText(name);
				toolbar.add(button);		
			}
			
		}catch(Exception e){
			logger_.warn("Unable to load action for role:"+role+" name:"+name+" icon:"+icon+" into the toolbar.",e);
			e.printStackTrace();
		}	
	}
	return toolbar;
}

/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 6:49:31 PM)
 * @param conf org.apache.avalon.framework.configuration.Configuration[]
 */
public void buildComponents(Configuration conf) {
	if(conf != null){
		Configuration[] comps = null;
		try{
		comps= conf.getChildren();
		}catch(Exception e){
			logger_.warn("Error getting component list.",e);
		}
		if(comps != null){
			for(int i = 0; i < comps.length; i++){
				try{
				String role = comps[i].getAttribute(COMPONENT_ROLE);
				String name = comps[i].getAttribute(COMPONENT_NAME);
				
				IComponent comp = componentLookup_.getComponent(role);//(IComponent)componentManager_.lookup(role);
				
				if(comp instanceof JInternalFrame){
					
					add(((JInternalFrame)comp));	
				}
				addComponent(comp,name);
				addComponent(comp,role);
				}catch(Exception e){
					logger_.warn("Could not load component into desktop.",e);
				}
			}
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 4:57:30 PM)
 */
public void buildMenus(Configuration[] conf) {
	frame_.setJMenuBar(new JMenuBar());
	menuBar_=frame_.getJMenuBar();
	
    if (conf != null) {
        for (int i = 0; i < conf.length; i++) {
            Configuration[] items = null;
            JMenu menu = null;
            try {
                menu = new JMenu(conf[i].getAttribute(MENU_NAME_KEY));
				//menu.setUI(new MenuUI());
                items = conf[i].getChildren();
            } catch (Exception e) {
                logger_.warn("Unable to build a menu");
            }
            if (items != null) {
                for (int j = 0; j < items.length; j++) {
                    try {
                        String role = items[j].getAttribute(MENU_ITEM_ACTION_KEY);
                        String name = items[j].getAttribute(MENU_ITEM_NAME_KEY);
                        ButterflyAction action = (ButterflyAction)actionLookup_.getAction(role);//(ButterflyAction) componentManager_.lookup(role);
                        logger_.debug("registering action named "+name+" for role "+role);
                        addAction(role,action);
                        //action.setLookup(this);
                      //  action.setActionLookup(this);
                        JMenuItem mi =menu.add(action);
                       // mi.setOpaque(false);
                        mi.setText(name);
                    } catch (Exception e) {
                        logger_.warn("Unable to create menu item on menu " + menu.getText());
                    }
                }
            }
            frame_.getJMenuBar().add(menu);
        }
    }
}
/**
 * compose method comment.
 */
public void compose(ComponentManager arg1) throws ComponentException {
	componentManager_ = arg1;	
}
/**
 * configure method comment.
 */
public void configure(Configuration arg1) throws ConfigurationException {
    logger_.debug(">>configure...");
    if (configuration_ == null) {
        configuration_ = arg1;
        return;
    }
    
    
    //	setLayout(new GridBagLayout());
    Configuration tbarconf = arg1.getChild(TOOLBAR_KEY);
    Configuration layoutconf = arg1.getChild(LAYOUT_MANAGER);
    String lrole = layoutconf.getAttribute(COMPONENT_ROLE);
    layoutHandler_ = (ILayoutHandler) componentLookup_.getComponent(lrole);
    layoutHandler_.configureLayout(layoutconf.getChildren());
    
    frame_ = new JFrame("Butterfly XML Editor");
    frame_.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    
    frame_.setIconImage((new ImageIcon("icons/butterfly_frame.png")).getImage());
    
    //componentManager_.

    Dimension ssize = getToolkit().getScreenSize();

    frame_.setSize(ssize);
    frame_.setContentPane(this);
    
    JPanel contentPane = new JPanel();
    contentPane.setLayout(new BorderLayout());
    JToolBar toolbar =buildToolBar(tbarconf);
    toolBar_=toolbar;
    
    Configuration[] menus = arg1.getChild(DESKTOP_MENUS_KEY).getChildren();
    buildMenus(menus);
    //toolbar.add(new JLabel("SomeTool"));
    
    //GridBagConstraints cons1 = new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0);
    contentPane.add(toolbar, BorderLayout.NORTH);

    Configuration[] children = arg1.getChild(DESKTOP_ELEMENTS_KEY).getChildren();
   
    setBorder(new EmptyBorder(0,2,2,2));
    setSize(ssize);

    Component[] desktopels = new Component[children.length];
    Configuration[] desktopconfs = new Configuration[children.length];
  
    for (int i = 0; i < children.length; i++) {

        String role = children[i].getAttribute(ROLE_KEY);
        Configuration constraintsconf = children[i].getChildren()[0];
        //String title = children[i].getAttribute(TITLE_KEY);
        //String xpos = children[i].getAttribute(XPOS_KEY);
        //String ypos = children[i].getAttribute(YPOS_KEY);
        //String width = children[i].getAttribute(WIDTH_KEY);
        //String height = children[i].getAttribute(HEIGHT_KEY);

        //int iwidth = -1;
        //int iheight = -1;
        //int ixpos = -1;
        //int iypos = -1;

        //try{
        //if(xpos != null && ypos != null){
        //ixpos = Integer.parseInt(xpos);
        //iypos = Integer.parseInt(ypos);
        //}
        //if(width != null && height != null){
        //iwidth = Integer.parseInt(width);
        //iheight = Integer.parseInt(height);
        //}
        //} catch (Exception e) {
        //logger_.warn(
        //"Invalid bounding information for component role:"
        //+ role
        //+ " title:"
        //+ title
        //+ " xpos:"
        //+ xpos
        //+ " ypos:"
        //+ ypos
        //+ " width:"
        //+ width
        //+ " height:"
        //+ height);
        //}

        try {
            Component component = (Component) componentLookup_.getComponent(role);
            //addComponent(component,role,title,ixpos,iypos,iwidth,iheight);
            if(component instanceof JInternalFrame){
				add((JInternalFrame)component);
				component.setVisible(false);
            }
            //layoutHandler_.addComponent(this,component,constraintsconf);
            logger_.debug("constraints found = "+(constraintsconf != null));
            desktopels[i] = component;
            desktopconfs[i] =constraintsconf;

            components_.put(role, component);
            // components_.put(title, component);
        } catch (Exception e) {
            logger_.warn(
            "Unable to load desktop component for role: " + role,
            e);
        }
      

    }
    
   
  
    //GridBagConstraints cons2 = new GridBagConstraints(0,1,20,20,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0);
    JPanel content = new JPanel();
    contentPane.add(content,BorderLayout.CENTER);
    setLayout(new GridBagLayout());
    GridBagConstraints cons = new GridBagConstraints(0,0,1,1,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0);
    add(contentPane,cons);
    
  layoutHandler_.buildLayout(
            content,//this,
            desktopels,
            desktopconfs,
			editorSite_);
    Configuration components = arg1.getChild(DESKTOP_COMPONENTS);
    buildComponents(components);

   
    
    //buildMenus();
    frame_.setDefaultCloseOperation(frame_.DO_NOTHING_ON_CLOSE);
    frame_.addWindowListener(
    	new WindowAdapter(){
    		public void windowClosing(WindowEvent e){
    			System.out.println("end...");
    			
    			IFileCloseAction act = (IFileCloseAction)getAction(IFileCloseAction.ROLE);
    			act.setCloseAll(true);
    			act.setExitOnClose(true);
    			act.actionPerformed(null);
    			frame_.show();
    		}
    	}    	
    );
//    frame_.addWindowListener(new WindowAdapter() {
//        public void windowClosing(java.awt.event.WindowEvent e) {
//            System.exit(0);
//        }
//    });
    
    frame_.show();
	SplashScreen.ensureVisible();
    frame_.setExtendedState(frame_.MAXIMIZED_BOTH);
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/31/2002 2:32:44 AM)
 * @return butterfly.actions.interfaces.IButterflyAction
 * @param role java.lang.String
 */
public butterfly.actions.interfaces.IButterflyAction getAction(String role) {
	return (butterfly.actions.interfaces.IButterflyAction)actions_.get(role);
}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 5:04:19 PM)
 * @return java.awt.Component
 * @param name java.lang.String
 */
public IComponent getComponent(String name) {
	return (IComponent)components_.get(name);
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 6:38:14 PM)
 */
public void requestActions() {}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 6:38:14 PM)
 */
public void requestComponents() {
	try{
		configure(configuration_);
	}catch(Exception e){
		logger_.debug("Unable to configure desktop",e);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 4:10:36 PM)
 * @param lookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup lookup) {
	actionLookup_ = lookup;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 12:07:51 PM)
 * @param lookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(butterfly.components.interfaces.IComponentLookup lookup) {
	componentLookup_ = lookup;	
}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IButterflyDesktop#bindKeystroke(KeyStroke, IButterflyAction)
	 */
	public void bindKeystroke(KeyStroke k, IButterflyAction action) {
		if(action instanceof AbstractAction){
			logger_.debug("added shortcut for:"+k);
			registerKeyboardAction((AbstractAction)action,k,WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		}
		
	}

public JFrame getApplicationFrame(){
	return frame_;	
}

}
