/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.interfaces.IFileDialog;
/**
 * Insert the type's description here.
 * Creation date: (8/17/2002 6:17:05 PM)
 * @author: 
 */
public class ButterflyFileChooser extends JFileChooser implements butterfly.components.interfaces.IComponent,IFileDialog,IComponentRequester{

class SimpleFilter extends FileFilter{
	private String ext_;
	private String desc_;
	public SimpleFilter(String ext,String desc){
		ext_ = ext;
		desc_=desc;
		if(!ext_.startsWith(".")){
			ext_="."+ext_;	
		}
	}
	/**
	 * @see javax.swing.filechooser.FileFilter#accept(File)
	 */
	public boolean accept(File f) {
		return f.getName().endsWith(ext_);
	}

	/**
	 * @see javax.swing.filechooser.FileFilter#getDescription()
	 */
	public String getDescription() {
		return desc_;
	}

}

private IComponentLookup componentLookup_;
private String lastLocation_;
/**
 * ButterflyFileChooser constructor comment.
 */
public ButterflyFileChooser() {
	super();
}
/**
 * ButterflyFileChooser constructor comment.
 * @param currentDirectory java.io.File
 */
public ButterflyFileChooser(java.io.File currentDirectory) {
	super(currentDirectory);
}
/**
 * ButterflyFileChooser constructor comment.
 * @param currentDirectory java.io.File
 * @param fsv javax.swing.filechooser.FileSystemView
 */
public ButterflyFileChooser(java.io.File currentDirectory, javax.swing.filechooser.FileSystemView fsv) {
	super(currentDirectory, fsv);
}
/**
 * ButterflyFileChooser constructor comment.
 * @param currentDirectoryPath java.lang.String
 */
public ButterflyFileChooser(String currentDirectoryPath) {
	super(currentDirectoryPath);
}
/**
 * ButterflyFileChooser constructor comment.
 * @param currentDirectoryPath java.lang.String
 * @param fsv javax.swing.filechooser.FileSystemView
 */
public ButterflyFileChooser(String currentDirectoryPath, javax.swing.filechooser.FileSystemView fsv) {
	super(currentDirectoryPath, fsv);
}
/**
 * ButterflyFileChooser constructor comment.
 * @param fsv javax.swing.filechooser.FileSystemView
 */
public ButterflyFileChooser(javax.swing.filechooser.FileSystemView fsv) {
	super(fsv);
}

/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 5:53:29 PM)
 * @param msg java.lang.String
 */
public void setApproveText(String msg) {
	setApproveButtonText(msg);	
}

/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 5:53:29 PM)
 * @param msg java.lang.String
 */
public void setMessage(String msg) {}

public void setFileFilters(String[] exts,String[] desc){
	//FileFilter[] filters = new FileFilter[exts.length];
	
	for(int i = 0; i < exts.length; i++){
		addChoosableFileFilter(new SimpleFilter(exts[i],desc[i]));
	}
	setFileFilter(getChoosableFileFilters()[0]);
	//this.addChoosableFileFilter()
}
	/**
	 * @see javax.swing.JFileChooser#showOpenDialog(Component)
	 */
	public int showOpenDialog(Component parent) throws HeadlessException {
		//get
		int result = super.showOpenDialog(parent);
		FileFilter[] filters = getChoosableFileFilters();
		for(int i = 0; i < filters.length; i++){
			removeChoosableFileFilter(filters[i]);	
		}
		setAcceptAllFileFilterUsed(true);
		return result;
	}

	/**
	 * @see javax.swing.JFileChooser#showSaveDialog(Component)
	 */
	public int showSaveDialog(Component parent) throws HeadlessException {
		int result = super.showSaveDialog(parent);
		FileFilter[] filters = getChoosableFileFilters();
		for(int i = 0; i < filters.length; i++){
			removeChoosableFileFilter(filters[i]);	
		}
		setAcceptAllFileFilterUsed(true);
		return result;
	}

/**
 * Returns the componentLookup.
 * @return IComponentLookup
 */
public IComponentLookup getComponentLookup() {
	return componentLookup_;
}

/**
 * Sets the componentLookup.
 * @param componentLookup The componentLookup to set
 */
public void setComponentLookup(IComponentLookup componentLookup) {
	componentLookup_ = componentLookup;
}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
public void requestComponents() {
	HistoryViewer hv = (HistoryViewer)getComponentLookup().getComponent("butterfly.xmlview.gui.HistoryViewer");
	if(hv != null){
		hv.setSelectionListener(
			new ListSelectionListener() {
				/**
				 * @see javax.swing.event.ListSelectionListener#valueChanged(ListSelectionEvent)
				 */
				public void valueChanged(ListSelectionEvent e) {
					String filestr = (String)((JList)e.getSource()).getModel().getElementAt(((JList)e.getSource()).getSelectedIndex());
					File file = new File(filestr);
					if(file.isFile()){
						setSelectedFile(file);	
					}
					else{
						setCurrentDirectory(file);
						setSelectedFile(null);	
					}
				}
			}
		);
		setAccessory(hv);	
	}
}

}
