/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.JLayeredPane;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ButterflyLayeredPane extends JLayeredPane {
	public static final Integer INFO_LAYER = JLayeredPane.MODAL_LAYER;
	
	private Integer layer_ = null;
	private Hashtable layoutManagers_ = new Hashtable(3);
	//ImageIcon close_ = new ImageIcon("graphics/tab_close.gif");

	public ButterflyLayeredPane(){
	
	}
	
	
	
	public void setBounds(int x, int y,int width, int height){
		super.setBounds(x,y,width,height);
		layoutLayers();	
	}
	
	public Component[] getComponents(){
		if(layer_ != null){
			return getComponentsInLayer(layer_.intValue());
		}
		else{
			return super.getComponents();	
		}
	}
	

	public void add(Component c, Object constraints, Integer layer){
		super.add(c,layer);
		LayoutManager m = getLayoutManagerForLayer(layer);
		if(m != null){
			if(m instanceof LayoutManager2){
				LayoutManager2 m2 = (LayoutManager2)m;
				m2.addLayoutComponent(c,constraints);
			}
		}	
	}
	

	
	protected void layoutLayer(Integer layer){
		LayoutManager m = getLayoutManagerForLayer(layer);
		if(m != null){
			layer_ = layer;	
			m.layoutContainer(this);
			layer_ = null;
		}
	}
	
	protected void layoutLayers(){
		Enumeration layers = layoutManagers_.keys();
		while(layers.hasMoreElements()){
			layoutLayer((Integer)layers.nextElement());	
		}
	}
	
	public LayoutManager getLayoutManagerForLayer(Integer layer){
		return (LayoutManager)layoutManagers_.get(layer);
	}
	public void setLayoutManagerForLayer(Integer layer, LayoutManager m){
		layoutManagers_.put(layer,m);	
	}
}
