/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ClosablePanel extends JPanel {
	private static Icon close_ = UIManager.getIcon("InternalFrame.closeIcon");
	private Container content_ = new JPanel();

	/**
	 * Constructor for ClosablePanel.
	 */
	public ClosablePanel() {
		super();
		GridBagConstraints cons = new GridBagConstraints(100,0,1,1,0,0,GridBagConstraints.NORTHEAST,GridBagConstraints.NONE,new Insets(0,0,0,0),0,0);
		setLayout(new GridBagLayout());
		JButton close = new JButton(close_);
		close.addActionListener(
			new ActionListener(){
				public void actionPerformed(ActionEvent ae){
					setVisible(false);	
				}	
			}
		);
		close.setBorder(new EmptyBorder(0,0,0,0));
		close.setSize(close_.getIconWidth(),close_.getIconHeight());
		add(close,cons);
		cons.gridy=1;
		cons.weightx=1;
		cons.weighty=1;
		cons.fill = cons.BOTH;
		add(content_,cons);
		//setDoubleBuffered(true);
	}
	
	

	public Container getContentPane(){
		return content_;
	}
	
	public void setContentPane(Container c){
		content_ =c;	
	}
	
	

}
