/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.xmlview.gui;

import java.awt.Rectangle;
import java.util.Vector;

import javax.swing.JTabbedPane;

import butterfly.xmlview.gui.interfaces.ITabCloseRequestListener;



/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ClosableTabbedPane extends JTabbedPane {
	
	private Vector tabCloseListeners_ = new Vector(1);
	protected Rectangle closeButtonBounds_ = new Rectangle(0,0,20,20);
	/**
	 * 
	 */

	
	
	
	public void sendCloseRequestEvent(int index){
		
		TabCloseRequestEvent tcre = new TabCloseRequestEvent();
		tcre.index=index;
		tcre.tabbedPane=this;
		for(int i = 0; i < tabCloseListeners_.size(); i++){
			((ITabCloseRequestListener)tabCloseListeners_.elementAt(i)).handleTabCloseRequest(tcre);
		}
	}
	public void addTabCloseRequestListener(ITabCloseRequestListener t){
		tabCloseListeners_.add(t);
	}
	public void removeTabCloseRequestListener(ITabCloseRequestListener t){
		tabCloseListeners_.remove(t);
	}

}
