/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Hashtable;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import butterfly.components.interfaces.IComponent;
import butterfly.statemachine.StateEvent;
import butterfly.statemachine.StateListenerManager;
import butterfly.statemachine.interfaces.IStateEventListener;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.gui.editors.*;
import butterfly.xmlview.gui.editors.interfaces.IEditor;
import butterfly.xmlview.gui.editors.interfaces.IEditorManager;
import butterfly.xmlview.gui.editors.interfaces.IEditorSite;
import butterfly.xmlview.gui.editors.interfaces.IEditorSiteManager;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.ITabCloseRequestListener;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/29/2002 4:16:55 PM)
 * @author: 
 */
public class DocumentEditorOrganizer extends JPanel implements IDocumentEditorOrganizer,IComponent,IStateEventSource,IStateEventListener,ChangeListener,ITabCloseRequestListener,IEditorManager{
	private Hashtable editorLookup_ = new Hashtable();
	private ClosableTabbedPane tabbedPane_;
	private Hashtable componentLookup_ = new Hashtable(7);
	private Hashtable keyLookup_ = new Hashtable(7);
	private StateListenerManager listenerManager_ = new StateListenerManager();
	private EditorManager editorManager_=new EditorManager();
	private IEditor currentEditor_;
	//private static Logger //logger_ = Logger.getLogger(DocumentEditorOrganizer.class);
	
/**
 * DocumentFrame constructor comment.
 */
public DocumentEditorOrganizer() {
	super();
	//setBorder(javax.swing.BorderFactory.createEmptyBorder(3,3,3,3));
	setBorder(ShadowBorder.getInstance());
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:17:45 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
private static ImageIcon defaultIcon_=new ImageIcon("icons/stock_new-xml-16.png");

public void addDocumentEditor(IDocument doc, IDocumentEditor docview) {
	addDocumentEditor(null,doc,docview);
}
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:17:45 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void addDocumentEditor(Icon icon,IDocument doc, IDocumentEditor docview) {
	if(!(docview instanceof JComponent)){
		//logger_.warn("DocumentEditor's must inherit from JComponent, the class "+docview.getClass()+" does not.");
		return;
	}
	if(docview instanceof IStateEventSource){
		((IStateEventSource)docview).addStateEventListener(this);
	}
	//setSize(900,1000);
	//logger_.debug("current size: "+getWidth()+"X"+getHeight());
	//setBackground(java.awt.Color.blue);
	JComponent comp = (JComponent)docview;
	comp.setBorder(javax.swing.BorderFactory.createEmptyBorder());
	//JFrame frame = new JFrame();
	if(tabbedPane_ == null){
		setLayout(new GridBagLayout());

		GridBagConstraints constr = new GridBagConstraints();
		constr.gridx = 0;
		constr.gridy = 0;
		constr.gridwidth = 10;
		constr.gridheight = 10;
		constr.weightx = 1.0;
		constr.weighty = 1.0;
		constr.fill = constr.BOTH;
		constr.anchor = GridBagConstraints.NORTH;

		
		tabbedPane_ = new ClosableTabbedPane();
		tabbedPane_.addTabCloseRequestListener(this);
		tabbedPane_.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		tabbedPane_.setPreferredSize(new Dimension(getWidth(),getHeight()));
		tabbedPane_.setMinimumSize(getSize());
		tabbedPane_.setSize(getSize());
		tabbedPane_.setBorder(javax.swing.BorderFactory.createEmptyBorder());
		tabbedPane_.addChangeListener(this);
		add(tabbedPane_,constr);
		
		//tabbedPane_.setBackground(java.awt.Color.green);
		tabbedPane_.setVisible(true);
		
		//tabbedPane_.setForeground(java.awt.Color.red);
		//tabbedPane_.addTab("test",new JLabel("aaaaaaaaaaaaasdfffffffffffffffffffff"));
		//logger_.debug("TabbedPane created..width:"+tabbedPane_.getWidth()+" height:"+tabbedPane_.getHeight());
	}
	//frame.setContentPane(tabbedPane_);
	//frame.setSize(tabbedPane_.getSize());
	//frame.show();
	
	//comp.setBackground(java.awt.Color.blue);
	String key = getLabel(doc.getName());
	editorLookup_.put(doc,key);
	editorLookup_.put(key,doc);
	componentLookup_.put(key,comp);
	keyLookup_.put(comp,key);
	//comp.setMinimumSize(getSize());
	//comp.setPreferredSize(getSize());

	tabbedPane_.insertTab(key,icon,comp,key,tabbedPane_.getTabCount());
	//comp.setSize(getSize());
	revalidate();
	//logger_.debug("Component size- width:"+comp.getWidth()+" height:"+getHeight());
	//logger_.debug("insert used instead of add");
	//tabbedPane_.setSelectedComponent(comp);
	//tabbedPane_.setBackgroundAt(0,java.awt.Color.green);
	StateEvent event = new StateEvent(DOCUMENT_EDITOR_ADDED_EVENT,this);
	event.addEventData(DOCUMENT_EDITOR_KEY,docview);
	listenerManager_.fireEvent(event);
}


private String getLabel(String key){
	if(editorLookup_.get(key)==null){
		return key;	
	}
	int count = 2;
	while(editorLookup_.get(key+"("+count+")")!=null){
		count++;	
	}
	return key+"("+count+")";
}

/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 11:43:39 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void addStateEventListener(butterfly.statemachine.interfaces.IStateEventListener l) {
	listenerManager_.addListener(l);
}
/**
 * Insert the method's description here.
 * Creation date: (8/30/2002 2:02:07 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void changeDocumentEditorName(IDocument doc, String newkey) {
	String key = (String)editorLookup_.get(doc);
	JComponent comp = (JComponent)componentLookup_.get(key);
	//logger_.debug("Changing documentview with key "+key+ " to new key: "+newkey);
	int index = tabbedPane_.indexOfComponent(comp);
	newkey = getLabel(newkey);
	tabbedPane_.setTitleAt(index,newkey);
	componentLookup_.remove(key);
	editorLookup_.remove(key);
	
	keyLookup_.put(comp,newkey);
	componentLookup_.put(newkey,comp);
	editorLookup_.put(doc,newkey);
	editorLookup_.put(newkey,doc);
}
/**
 * Insert the method's description here.
 * Creation date: (9/20/2002 3:31:18 PM)
 * @return boolean
 * @param key java.lang.String
 */
public boolean containsDocumentEditor(IDocument d) {
	if(d==null){return false;}
	String key = (String)editorLookup_.get(d);
	if(key == null){return false;}
	return componentLookup_.containsKey(key);
}
/**
 * Insert the method's description here.
 * Creation date: (8/30/2002 1:50:48 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public IDocumentEditor getActiveDocumentEditor() {
	return (IDocumentEditor)tabbedPane_.getSelectedComponent();
}
public IDocumentEditor[] getDocumentEditors(){
	return (IDocumentEditor[])componentLookup_.values().toArray(new IDocumentEditor[0]);	
}

public IDocumentEditor getDocumentEditor(IDocument doc){
	if(doc == null){return null;}
	String key = (String)editorLookup_.get(doc);
	if(key == null){return null;}
	Component comp = (Component)componentLookup_.get(key);
	return (IDocumentEditor)comp;
}
/**
 * Insert the method's description here.
 * Creation date: (8/30/2002 1:50:48 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public IDocument getActiveDocumentEditorKey() {
	String key= ((String)keyLookup_.get(getActiveDocumentEditor()));
	return (IDocument)editorLookup_.get(key);
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 11:43:39 AM)
 * @param event butterfly.statemachine.interfaces.IStateEvent
 */
public void handleEvent(butterfly.statemachine.interfaces.IStateEvent event) {
	//logger_.debug("DocumentFrame is forwarding and event...");
	listenerManager_.fireEvent(event);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:17:45 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void removeActiveDocumentEditor() {
	
	removeDocumentEditor(getActiveDocumentEditorKey());
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:17:45 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void removeDocumentEditor(IDocument doc) {
	if(doc == null){return;}
	String key = (String)editorLookup_.get(doc);
	if(key == null){return;}
	Component comp = (Component)componentLookup_.get(key);
	if(comp instanceof IStateEventSource){
		((IStateEventSource)comp).removeStateEventListener(this);
	}
	int index = tabbedPane_.indexOfComponent(comp);
	
	tabbedPane_.removeTabAt(index);
	componentLookup_.remove(key);
	keyLookup_.remove(comp);
	editorLookup_.remove(doc);
	editorLookup_.remove(key);
	
	
	
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 11:43:39 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void removeStateEventListener(butterfly.statemachine.interfaces.IStateEventListener l) {
listenerManager_.removeListener(l);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:17:45 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void showDocumentEditor(IDocumentEditor key) {
	Component comp = (Component)key;
	comp.setVisible(true);
	//logger_.debug("key: "+key+" was mapped to the documentView:"+comp);
	tabbedPane_.setSelectedComponent(comp);
//	StateEvent event = new StateEvent(DOCUMENT_EDITOR_SHOWN_EVENT,this);
//	event.addEventData(DOCUMENT_EDITOR_KEY,key);
//	listenerManager_.fireEvent(event);
}
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:17:45 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void showDocumentEditor(IDocument doc) {
	String key = (String)editorLookup_.get(doc);
	JComponent comp = (JComponent)componentLookup_.get(key);
	if(comp == null){return;}
	comp.setVisible(true);
	//logger_.debug("key: "+key+" was mapped to the documentView:"+comp);
	tabbedPane_.setSelectedComponent(comp);
	
			StateEvent se = new StateEvent(DOCUMENT_EDITOR_SHOWN_EVENT,this);
			listenerManager_.fireEvent(se);
	
//	StateEvent event = new StateEvent(DOCUMENT_EDITOR_SHOWN_EVENT,this);
//	event.addEventData(DOCUMENT_EDITOR_KEY,comp);
//	listenerManager_.fireEvent(event);
}
	/**
	 * @see javax.swing.event.ChangeListener#stateChanged(ChangeEvent)
	 */
	public void stateChanged(ChangeEvent e) {
		
		
		if(e.getSource().equals(tabbedPane_)){
			if(currentEditor_!=null){
				editorManager_.closeEditor(currentEditor_);
				currentEditor_=null;
			}
			if(tabbedPane_.getSelectedIndex()>-1){
				String key = tabbedPane_.getTitleAt(tabbedPane_.getSelectedIndex());
				Object curr = componentLookup_.get(key);
				if(curr instanceof IEditor){
					currentEditor_=(IEditor)curr;
					editorManager_.openEditor(currentEditor_);
				}
			}
			
			StateEvent se = new StateEvent(DOCUMENT_EDITOR_SHOWN_EVENT,this);
			listenerManager_.fireEvent(se);
		}
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.ITabCloseRequestListener#handleTabCloseRequest(butterfly.xmlview.gui.TabCloseRequestEvent)
	 */
	public void handleTabCloseRequest(TabCloseRequestEvent evt) {
		String key = tabbedPane_.getTitleAt(evt.index);
		Object missing = componentLookup_.get(key);
		if(missing instanceof IEditor){
			editorManager_.closeEditor((IEditor)missing);
		}
		Hashtable h = new Hashtable();
		h.put(DOCUMENT_EDITOR_KEY,missing);
		StateEvent se = new StateEvent(DOCUMENT_EDITOR_REMOVED_EVENT,this);
		se.setEventData(h);
		listenerManager_.fireEvent(se);		
	}

	

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.editors.interfaces.IEditorManager#setEditorSiteManager(butterfly.xmlview.gui.editors.interfaces.IEditorSiteManager)
	 */
	public void setEditorSiteManager(IEditorSiteManager mngmt) {
		// TODO Auto-generated method stub
		editorManager_.setEditorSiteManager(mngmt);
	}

}
