/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

import butterfly.xmlview.gui.interfaces.IEditPane;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.EditInfo;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.interfaces.IEditInfo;
import butterfly.xmlview.model.interfaces.IEditable;
/**
 * Insert the type's description here.
 * Creation date: (12/2/2002 5:33:31 PM)
 * @author: 
 */
public class EditPane extends javax.swing.JPanel implements IEditPane{
	private JScrollPane scrollPane_;
	private JPanel editPanel_;
	private JLabel title_;
	private IEditable toEdit_;

	class Info implements IEditable{
		
		/**
		 * @see butterfly.xmlview.model.interfaces.IEditable#getDescription()
		 */
		public String getDescription() {
			return "The properties editor.";
		}

		
		/**
		 * @see butterfly.xmlview.model.interfaces.IEditable#getTitle()
		 */
		public String getTitle() {
			return "Properties";
		}

		/**
		 * @see butterfly.xmlview.model.interfaces.IEditable#getEditableProperties()
		 */
		public IEditInfo[] getEditableProperties() {
			EditInfo ei = new EditInfo(null);
			//AttributesEditor ae = new AttributesEditor();
			//ae.setEnabled(false);
			//ei.setEditingComponent(ae);
			
			return new IEditInfo[]{ei};
		}

	}


	class UpdateAction extends AbstractAction{
		private IEditInfo info_;
		private JTextComponent value_;
		public UpdateAction(IEditInfo info,JTextComponent value){
			info_ = info;
			value_ = value;
		}
		public void actionPerformed(java.awt.event.ActionEvent ae){
			info_.handleEdit(value_.getText());
			edit(toEdit_);
		}
		public Object getTarget(){
			return info_.getTarget();
		}
	}
/**
 * EditPane constructor comment.
 */
public EditPane() {
	super();

	//JLabel editorTitle_;
	
	setLayout(new GridBagLayout());
	
	GridBagConstraints tcons = new GridBagConstraints();
	tcons.fill = tcons.BOTH;
	tcons.weightx = 1;
	tcons.weighty = 0;
	tcons.gridx = 0;
	tcons.gridy = 0;
	title_ = new JLabel("");
	add(title_,tcons);

	
	GridBagConstraints cons = new GridBagConstraints();
	cons.fill = cons.BOTH;
	cons.weightx = 1;
	cons.weighty = 1;
	cons.gridx = 0;
	cons.gridy = 1;

	editPanel_ = new JPanel();
	editPanel_.setBorder(javax.swing.BorderFactory.createEmptyBorder());
	editPanel_.setLayout(new GridBagLayout());
	
	//scrollPane_ = new JScrollPane(editPanel_);
	
	//add(scrollPane_,cons);
	add(new JScrollPane(editPanel_),cons);
	//setBorder(ShadowBorder.getInstance());
	edit(new Info());
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 5:38:34 PM)
 * @param toedit butterfly.xmlview.model.interfaces.IEditable
 */
public void edit(IEditable toedit) {
	toEdit_ = toedit;
	editPanel_.removeAll();
	
	title_.setText(toedit.getTitle());
    IEditInfo[] info = toedit.getEditableProperties();

    GridBagConstraints current = new GridBagConstraints();
    current.weightx = 1;
    current.weighty = 0;
    current.gridwidth = 2;
    current.gridheight = 1;
    current.gridx = 0;
    current.gridy = 0;
    current.insets = new java.awt.Insets(0,0,0,0);
    current.fill = current.HORIZONTAL;
    current.anchor = current.NORTHEAST;

    IEditInfo field = null;
    //grid height per component is 1 and width is 2
    for (int i = 0; i < info.length; i++) {
        field = info[i];

        if (EditorFactory.getEditor(field) == null) {

            JLabel label = new JLabel(field.getLabelDescription());
            label.setToolTipText(field.getDescription());
            current.weightx = 0;
            current.fill = current.NONE;
            editPanel_.add(label, current);
            current.fill = current.HORIZONTAL;
            current.weightx = 1;
            current.gridx = current.gridx + 2;

            JTextField ef = new JTextField(field.getValue());
           
	        ef.setEditable(field.isEditable());
            final UpdateAction ua = new UpdateAction(field, ef);
            FocusListener fl = new FocusListener() {
                public void focusGained(java.awt.event.FocusEvent e) {

                }
                public void focusLost(java.awt.event.FocusEvent e) {
                    ua.actionPerformed(null);
                    //System.out.println(ua.getTarget());
                }
            };
            ef.addFocusListener(fl);
            ef.addActionListener(new ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent a) {
                    ua.actionPerformed(a);
                    //System.out.println(ua.getTarget());
                }
            });
            ef.setToolTipText(field.getDescription());
            editPanel_.add(ef, current);
            current.gridx = current.gridx - 2;
        } else {
            current.gridwidth = 4;
            current.weightx = 1.0;
            current.weighty = 1.0;
            current.fill = current.BOTH;
            JComponent editor = (JComponent)EditorFactory.getEditor(field);
            //editor.setBackground(Color.black);
            editPanel_.add(editor, current);
            current.gridwidth = 2;
            current.weightx = 1;
            current.weighty = 0;
        }

        current.gridy = current.gridy + 1;
    }
    current.weighty=1.0;
    editPanel_.add(new JPanel(),current);
    editPanel_.revalidate();
    repaint();
}
/**
 * Insert the method's description here.
 * Creation date: (12/2/2002 6:01:00 PM)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	try{
		JFrame frame = new JFrame();
		frame.setSize(300,300);
		EditPane pane = new EditPane();
		frame.setContentPane(pane);
		Element el = new Element("something");
	Attribute a1 = new Attribute(el,"role");
	a1.setData("butterfly.xmlview.model.IAttribute");
	Attribute a2 = new Attribute(el,"id");
	a2.setData("Element");
	el.addAttribute(a1);
	el.addAttribute(a2);
		pane.edit(el);
		frame.show();
	}catch(Exception e){
		e.printStackTrace();
	}	
	
}
}
