/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.interfaces.IValidatedDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/2/2002 2:30:32 PM)
 * @author: 
 */
public class ElementDetailPane
	extends JPanel
	implements
		Configurable,
		butterfly.xmlview.gui.interfaces.IXmlStructurePane,
		IActionRequester {
	private static final Logger logger_ =
		Logger.getLogger(ElementDetailPane.class);
	private Vector history_ = new Vector();
	//private Hashtable elementStructureLookup_ = new Hashtable(3);
	private IValidatedDocument document_;
	private HtmlDisplayPane display_ = new HtmlDisplayPane() {
		public void handleHyperlinkEvent(javax.swing.event.HyperlinkEvent e) {
			ElementDetailPane.this.handleHyperlinkEvent(e);
		}
	};
	public static final String DEFAULT_HTML =
		"<html><a href=\"http://www.butterfly.action/back\">back</a> <a href=\"http://www.butterfly.action/forward\">forward</a><br>\n<b>Element Structure</b><br>\n<b>Name:</b> %%name%%<br><b>Namespace:</b> %%namespace%%<br><b>Allowed Attributes:</b><br>%%allowed-attributes%%<br>Allowed Sub-Elements:</b><br>%%allowed-subelements%%</html>";
	private String currentKey_ = "";
	//private Stack history_ = new Stack();
	private int currentIndex_ = 0;
	private JToolBar toolBar_ = new JToolBar();
	private static ImageIcon backicon_ =
		new ImageIcon("icons/stock_previous-16.png");
	private static ImageIcon forwardicon_ =
		new ImageIcon("icons/stock_next-16.png");
	/**
	 * ElementDetailPane constructor comment.
	 */
	class BackAction extends AbstractAction {
		public BackAction() {
			putValue(this.NAME, "Back");
			putValue(this.LONG_DESCRIPTION, "Back");
			putValue(this.SMALL_ICON, backicon_);
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			back();
		}

	}

	class ForwardAction extends AbstractAction {
		public ForwardAction() {
			putValue(this.NAME, "Forward");
			putValue(this.LONG_DESCRIPTION, "Forward");
			putValue(this.SMALL_ICON, forwardicon_);
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			forward();
		}

	}

	public ElementDetailPane() {
		super();
		display_.setHtml(DEFAULT_HTML, new Hashtable());
		setLayout(new BorderLayout());
		add(new JScrollPane(display_), BorderLayout.CENTER);
		add(toolBar_, BorderLayout.NORTH);
		JLabel title = new JLabel("Structure");
		title.setFont(title.getFont().deriveFont(Font.BOLD));
		toolBar_.add(title);
		toolBar_.add(new BackAction()).setToolTipText("Previous");
		toolBar_.add(new ForwardAction()).setToolTipText("Next");
		Hashtable data = new Hashtable();
		data.put("allowed-attributes", new Vector());
		data.put("allowed-subelements", new Vector());
		data.put("name","No Element Selected");
		data.put("namespace","");
		display_.setData(data);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/2/2002 2:30:32 PM)
	 * @param elname java.lang.String
	 */
	public void displayStructureFor(String elname) {
		displayStructureFor(elname, null);
	}
	public void displayStructureFor(String elname, String namespacestr) {
		displayStructureForKey(elname,namespacestr,true);
	}

	public void displayStructureForKey(String key) {
		displayStructureForKey(key, true);

	}
	public void displayStructureForKey(String key,boolean uh) {
		displayStructureForKey(getName(key),getNamespace(key), uh);

	}

	public void displayStructureForKey(String el,String ns, boolean uh) {
		logger_.debug("display structure for:" + el+":"+ns);
		
		String key = getKey(el,ns);
		currentKey_ = key;
		IElementStructure struct =
			(IElementStructure) document_.getValidationDocument().getElementStructure(el,ns);//elementStructureLookup_.get(key);
		if (uh) {
			history_.add(currentKey_);
//			int total = (history_.size() - 1) - currentIndex_;
//			for (int i = 0; i < total; i++) {
//				history_.remove(currentIndex_ + i + 1);
//			}
			currentIndex_ = history_.size()-1;
		}
		if (struct == null) {
			logger_.debug("the structure for "+el+" was not found");
			return;
		}
		Hashtable data = new Hashtable();
		data.put("name", struct.getName());
		String namespace = struct.getNamespace();
		if (namespace == null) {
			namespace = "default";
		}
		if (namespace.trim().length() < 1) {
			namespace = "default";
		}
		data.put("namespace", namespace);

		String attributes = "";
		String subels = "";

		for (int i = 0; i < struct.attributeCount(); i++) {
			attributes += struct.attributeAt(i);
			if (i < struct.attributeCount() - 1) {
				attributes += ", ";
			}
		}
		for (int i = 0; i < struct.subElementCount(); i++) {
			if(struct.subElementAt(i)==null){continue;}
			namespace = struct.subElementAt(i).getNamespace();

			subels += "<a href=\"http://www.butterfly.action/show."
				+ getKey(struct.subElementAt(i))
				+ "\">"
				+ struct.subElementAt(i).getName()
				+ "</a>";
			if (i < struct.subElementCount() - 1) {
				subels += ", ";
			}
		}

		data.put("allowed-attributes", attributes);
		data.put("allowed-subelements", subels);

		display_.setData(data);

	}

	public void back() {
		if (currentIndex_ > 0) {
			currentIndex_--;
			String key = (String) history_.elementAt(currentIndex_);
			displayStructureForKey(key, false);
		}
	}
	public void forward() {
		if (currentIndex_ < history_.size() - 1) {
			currentIndex_++;
			String key = (String) history_.elementAt(currentIndex_);
			displayStructureForKey(key, false);
		}
	}
	
	private String getNamespace(String key){
		String ns = key.substring(0,key.lastIndexOf(":"));
		if(ns.equals("null")){
			ns = null;
		}
		return ns;
	}
	private String getName(String key){
		return key.substring(key.lastIndexOf(":")+1);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/2/2002 5:21:48 PM)
	 * @param e javax.swing.event.HyperlinkEvent
	 */
	public void handleHyperlinkEvent(javax.swing.event.HyperlinkEvent e) {
		if (e.getEventType().ACTIVATED == e.getEventType()) {
			String url = e.getURL().toExternalForm();
			String actionname = display_.getHyperlinkAction(url);
			//logger_.debug(
			//	"current:" + currentIndex_ + " size:" + history_.size());
			if (actionname != null) {
				if (actionname.startsWith("show.")) {
//					int total = (history_.size() - 1) - currentIndex_;
//					for (int i = 0; i < total; i++) {
//						history_.remove(currentIndex_ + i + 1);
//					}

					displayStructureForKey(actionname.substring(5));
					//history_.add(currentKey_);
					//currentIndex_++;
				} else if (actionname.startsWith("back")) {
					back();
				} else if (actionname.startsWith("forward")) {
					forward();
				} else {
					display_.handleHyperlinkEvent(e);
				}

			}

		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/2/2002 2:30:32 PM)
	 * @param struct butterfly.xmlview.model.interfaces.IElementStructure[]
	 */
//	public void setElementStructure(IElementStructure[] struct) {
//
//		elementStructureLookup_.clear();
//
//		if (struct == null) {
//			return;
//		}
//
//		if (struct.length > 0) {
//			String el = getKey(struct[0]);
//
//			for (int i = 0; i < struct.length; i++) {
//				//logger_.debug("adding struct:" + getKey(struct[i]));
//				elementStructureLookup_.put(getKey(struct[i]), struct[i]);
//
//			}
//			displayStructureForKey(el);
//		}
//	}
	public String getKey(String name, String namespace) {
		return "" + namespace + ":" + name;
	}
	public String getKey(IElementStructure el) {
		return getKey(el.getName(), el.getNamespace());
	}
	/**
	 * @see org.apache.avalon.framework.configuration.Configurable#configure(Configuration)
	 */
	public void configure(Configuration arg0) throws ConfigurationException {
		display_.configure(arg0);
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#requestActions()
	 */
	public void requestActions() {
		display_.requestActions();
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#setActionLookup(IActionLookup)
	 */
	public void setActionLookup(IActionLookup lookup) {
		display_.setActionLookup(lookup);
	}

	/**
	 * @return Returns the document_.
	 */
	public IValidatedDocument getDocument() {
		return document_;
	}

	/**
	 * @param document_ The document_ to set.
	 */
	public void setDocument(IValidatedDocument document) {
		this.document_ = document;
	}

}
