/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

import butterfly.xmlview.gui.interfaces.IComponent;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.XmlStructureBuilder;
/**
 * Insert the type's description here.
 * Creation date: (9/5/2002 10:09:08 PM)
 * @author: 
 */
public class ElementStructurePane extends javax.swing.JPanel implements IComponent{
	private IElementStructure[] elementStructure_;
	private Hashtable nodeLookup_ = new Hashtable(13);
	private JTree elementTree_;
	private static Logger logger_ = Logger.getLogger(ElementStructurePane.class);
/**
 * ElementStructurePane constructor comment.
 */
public ElementStructurePane() {
	super();
	
	setLayout(new GridBagLayout());


}
/**
 * Insert the method's description here.
 * Creation date: (9/5/2002 10:11:12 PM)
 */
public void buildView() {
	if(elementTree_ != null){
		elementTree_.removeAll();
		remove(elementTree_);
	}

	DefaultMutableTreeNode root = new DefaultMutableTreeNode("Element Structure Reference");

	elementTree_ = new JTree(root);
	
	for(int i = 0; i < elementStructure_.length; i++){
		IElementStructure curr = elementStructure_[i];
		
		
		DefaultMutableTreeNode node = new DefaultMutableTreeNode("<"+curr.getName()+">");
		nodeLookup_.put(curr.getNamespace()+":"+curr.getName(),node);
		DefaultMutableTreeNode attrs = new DefaultMutableTreeNode("Attributes");
		for(int j = 0; j < curr.attributeCount(); j++){
			DefaultMutableTreeNode at = new DefaultMutableTreeNode("@"+curr.attributeAt(j));
			attrs.add(at);
		}
		node.add(attrs);
		
		DefaultMutableTreeNode els = new DefaultMutableTreeNode("Sub-elements");
		for(int k = 0; k < curr.subElementCount(); k++){
			DefaultMutableTreeNode el = new DefaultMutableTreeNode("<"+curr.subElementAt(k).getName()+">");
			els.add(el);
		}
		node.add(els);
		root.add(node);
	}
	
	
	//elementTree_.setCellRenderer(new TextPaneTreeCellRenderer());
	
	GridBagConstraints constrs = new GridBagConstraints();
	constrs.gridx = 0;
	constrs.gridy = 0;
	constrs.gridwidth = 1;
	constrs.gridheight = 1;
	constrs.fill = constrs.BOTH;
	constrs.weightx = 1.0;
	constrs.weighty = 1.0;

	add(elementTree_,constrs);

	revalidate();
}
/**
 * Insert the method's description here.
 * Creation date: (10/20/2002 4:17:38 PM)
 * @param struct java.lang.String
 */
public void createStructure(String struct) {}
/**
 * Insert the method's description here.
 * Creation date: (10/22/2002 3:30:19 PM)
 * @param elementname java.lang.String
 */
public void displayStructureFor(String elementname) {
	if(elementname.indexOf(":") < 0){
		elementname = ":"+elementname;
	}
	DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeLookup_.get(elementname);
	logger_.debug("node found for "+elementname+ " = "+(node != null));
	//Object root = //
	//expandAll(elementTree_, new TreePath(node), true);
	//expandAll(true);
	expandAll(false);
	expandTo(elementTree_,node,true);
}
  private void expandAll(JTree tree, TreePath parent, boolean expand) {
        // Traverse children
        
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path, expand);
            }
        }
    
        // Expansion or collapse must be done bottom-up
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)elementTree_.getModel().getRoot();


       
        // Traverse tree from root
        expandAll(elementTree_, new TreePath(root), expand);
    }
  private void expandTo(JTree tree, DefaultMutableTreeNode node, boolean expand) {
        // Traverse children
        
       TreePath path = new TreePath(getPathToRoot(node,0));
       tree.expandPath(path);
    }
/**
 * Insert the method's description here.
 * Creation date: (9/7/2002 4:19:57 PM)
 * @param schema java.lang.String
 */
public void loadSchema(String schema) {
	
 
    //String xml = fs.readFile(args[1]);
try{
    XmlStructureBuilder builder = new XmlStructureBuilder();
    IElementStructure[] str= builder.buildElementStructure(schema,false);
    elementStructure_ = str;
    buildView();
}catch(Exception e){
	logger_.warn("Unable to load schema."+schema,e);
}
}
/**
 * Insert the method's description here.
 * Creation date: (9/7/2002 4:22:38 PM)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	try{
	butterfly.xmlview.io.XmlViewFileSystem fs = new butterfly.xmlview.io.XmlViewFileSystem();
	String xsd = fs.readFile(args[0]);
	JFrame frame = new JFrame();
	frame.setSize(400,400);
	ElementStructurePane pane = new ElementStructurePane();
	pane.loadSchema(xsd);
	frame.setContentPane(pane);
	frame.show();
	}catch(Exception e){
		e.printStackTrace();
	}
}
/**
 * Insert the method's description here.
 * Creation date: (9/5/2002 10:10:13 PM)
 * @param els butterfly.xmlview.model.interfaces.IElementStructure[]
 */
public void setElementStructure(IElementStructure[] els) {
	elementStructure_ = els;
	buildView();	
}

protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
	TreeNode[]              retNodes;

	/* Check for null, in case someone passed in a null node, or
	   they passed in an element that isn't rooted at root. */
	if(aNode == null) {
	    if(depth == 0)
		return null;
	    else
		retNodes = new TreeNode[depth];
	}
	else {
	    depth++;
	    retNodes = getPathToRoot(aNode.getParent(), depth);
	    retNodes[retNodes.length - depth] = aNode;
	}
	return retNodes;
	}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlStructurePane#displayStructureFor(String, String)
	 */
	public void displayStructureFor(String elname, String ns) {
	}

}
