/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class FileChooserField extends JPanel {
	private JFileChooser chooser_;
	private JButton browse_;
	private JTextField fileName_;
	private String fileMask_="*.*";
	private String label_;
	
	public FileChooserField(){
		init();
	}
	public FileChooserField(String label){
		label_ = label;
		init();
		
	}
	
	protected void init(){
		chooser_ = new JFileChooser();
		browse_ = new JButton("Browse");
		
		browse_.addActionListener(
			new ActionListener(){
				public void actionPerformed(ActionEvent ae){
					int accept = chooser_.showOpenDialog(FileChooserField.this);	
					if(accept == JFileChooser.APPROVE_OPTION){
						String file = chooser_.getSelectedFile().getAbsolutePath();
						fileName_.setText(file);	
					}
				}	
			}
		);
		fileName_ = new JTextField("");
		
		setLayout(new GridBagLayout());
		
		GridBagConstraints cons = new GridBagConstraints();
		cons.gridx = 0;
		cons.gridy = 0;
		cons.gridheight = 1;
		cons.gridwidth = 1;
		cons.weightx = .6;
		cons.weighty = 1;
		cons.anchor = cons.WEST;
		cons.fill = cons.HORIZONTAL;
		
		add(new JPanel(),cons);
		cons.weightx = 0;
		cons.weighty = 0;
		cons.gridx++;
		
		if(label_ != null){
			browse_.setText(label_);
		}
		//else{
		add(browse_,cons);
		
		//browse_.setSize(browse_.getWidth(),fileName_.getHeight());
		//}
		cons.gridx++;
		cons.weightx=1;
		cons.weighty=1;
		add(fileName_,cons);
		
			
	}
	/**
	 * Returns the fileName.
	 * @return JTextField
	 */
	public JTextField getFileNameField() {
		return fileName_;
	}

	
}
