/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.interfaces.IComponent;
import butterfly.xmlview.io.interfaces.IDocumentAccessHistory;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class HistoryViewer extends JPanel implements IComponentRequester,IComponent{
	private JList list_;
	private IComponentLookup componentLookup_;
	private ListSelectionListener selectionListener_;
	/**
	 * Constructor for HistoryViewer.
	 */
	public HistoryViewer() {
		super();
		list_ = new JList();
		list_.setSelectionMode(list_.getSelectionModel().SINGLE_SELECTION);
		setPreferredSize(new Dimension(200,200));
		setSize(300,300);
		addComponentListener(
			new ComponentAdapter() {
				
				/**
				 * @see java.awt.event.ComponentListener#componentShown(ComponentEvent)
				 */
				public void componentShown(ComponentEvent e) {
					updateHistory();
				}

			
			}
		);
		list_.addListSelectionListener(
			new ListSelectionListener() {
				/**
				 * @see javax.swing.event.ListSelectionListener#valueChanged(ListSelectionEvent)
				 */
				public void valueChanged(ListSelectionEvent e) {
					if(selectionListener_ != null){
						System.out.println("sel changed to:"+e.getFirstIndex());
						selectionListener_.valueChanged(e);	
					}
				}
			}
		);
		
		setLayout(new BorderLayout());
		add(new JScrollPane(list_),BorderLayout.CENTER);
		JLabel hits = new JLabel("Recent Files");
		hits.setFont(hits.getFont().deriveFont(Font.BOLD));
		add(hits,BorderLayout.NORTH);
	}

	public void updateHistory(){
		IDocumentAccessHistory history = (IDocumentAccessHistory)getComponentLookup().getComponent(IDocumentAccessHistory.ROLE);
		if(history != null){
		String[] docs = history.getDocumentList();	
		list_.setListData(docs);
		}
	}
	
	/**
	 * Returns the componentLookup.
	 * @return IComponentLookup
	 */
	public IComponentLookup getComponentLookup() {
		return componentLookup_;
	}

	/**
	 * Sets the componentLookup.
	 * @param componentLookup The componentLookup to set
	 */
	public void setComponentLookup(IComponentLookup componentLookup) {
		componentLookup_ = componentLookup;
	}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
	public void requestComponents() {
		updateHistory();
	}

	

	/**
	 * Sets the actionListener.
	 * @param actionListener The actionListener to set
	 */
	public void setSelectionListener(ListSelectionListener listener) {
		selectionListener_ = listener;
	}

}
