/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Rectangle;

import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/**
 * @author Administrator
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class HorizontalTreeUI extends BasicTreeUI {

	/**
	 * Constructor for HorizontalTreeUI.
	 */
	public HorizontalTreeUI() {
		super();
	}
	
	
//
//	private int yPad_ = 20;
//	private int leftPad_ = 10;
//	private int rightPad_ = 10;
//	private Hashtable columnLocations_ = new Hashtable();
//	
	public int getColumn(TreePath path){
		if(path == null){return 0;}
		return path.getPathCount()-1;
	}
	
	public int getSubRow(TreePath path){
		if(path == null){
			return 0;
		}
		TreePath parent= path.getParentPath();
		if(parent != null){
			if(parent.getPathCount() > 0){	
				DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)parent.getLastPathComponent();
				return tnode.getIndex((DefaultMutableTreeNode)path.getLastPathComponent());
			}
		}		
		return 0;
	}
//	/**
//	 * @see javax.swing.plaf.basic.BasicTreeUI#paintRow(Graphics, Rectangle, Insets, Rectangle, TreePath, int, boolean, boolean, boolean)
//	 */
//	protected void paintRow(
//		Graphics g,
//		Rectangle clipBounds,
//		Insets insets,
//		Rectangle bounds,
//		TreePath path,
//		int row,
//		boolean isExpanded,
//		boolean hasBeenExpanded,
//		boolean isLeaf) {
//		int x = 0;
//		
//		int subrow = getSubRow(path);
//		int column = getColumn(path);
//		if(column == 0){
//			x = 10;
//		}
//		else{
//			x = ((Integer)columnLocations_.get(new Integer(column))).intValue();	
//		}
//		Integer next = new Integer(x+bounds.width+leftPad_+rightPad_);
//		Integer key = new Integer(column+1);
//		Integer curr = (Integer)columnLocations_.get(key);
//		if(curr != null){
//			if(curr.intValue() < next.intValue()){
//				columnLocations_.put(key,next);	
//			}	
//		}
//		else{
//			columnLocations_.put(key,next);		
//		}
//		bounds = new Rectangle(x+leftPad_,subrow*(getRowHeight()+yPad_),bounds.width,bounds.height);
//		super.paintRow(
//			g,
//			clipBounds,
//			insets,
//			bounds,
//			path,
//			row,
//			isExpanded,
//			hasBeenExpanded,
//			isLeaf);
//	}
//
//	/**
//	 * @see javax.swing.plaf.TreeUI#getClosestPathForLocation(JTree, int, int)
//	 */
//	public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
//		return super.getClosestPathForLocation(tree, x, y);
//	}
//
//	/**
//	 * @see javax.swing.plaf.TreeUI#getPathBounds(JTree, TreePath)
//	 */
//	public Rectangle getPathBounds(JTree tree, TreePath path) {
//		return super.getPathBounds(tree, path);
//	}
//	

	/**
	 * @see javax.swing.plaf.TreeUI#getPathBounds(JTree, TreePath)
	 */
	public Rectangle getPathBounds(JTree tree, TreePath path) {
		Rectangle bounds = new Rectangle(0,0,40,20);
		bounds.x= getColumn(path) * 40;
		bounds.y= getSubRow(path) * 30;
		return bounds;
	}

}
