/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IButterflyAction;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IHtmlDisplayPane;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/2/2002 1:23:33 PM)
 * @author: 
 */
public class HtmlDisplayPane extends JScrollPane implements IDocumentEditor,IActionRequester,Configurable,IHtmlDisplayPane,HyperlinkListener{
	private JEditorPane pane_;
	private String startIdentifier_ = "%%";
	private String endIndentifier_ = "%%";
	private String template_;
	public final static String TEMPLATE_KEY = "html-template";
	public final static String ACTION_URL_KEY = "www.butterfly.action/";
	private IActionLookup actionLookup_;
	private IDocument document_;
	private String applicationPath_;
	private static Logger logger_ = Logger.getLogger(JTextPane.class);
/**
 * HtmlDisplayPane constructor comment.
 */
public HtmlDisplayPane() {
	super();
	pane_ = new JEditorPane();
	pane_.setEditorKit(new RelativeHTMLEditorKit());
	pane_.addHyperlinkListener(this);
	getViewport().setView(pane_);
	setBorder(javax.swing.BorderFactory.createEmptyBorder());
	
	try{
		File  file = new File("./");
		applicationPath_=file.toURL().toString()+"/";
	}catch(Exception e){}
}


/**
 * configure method comment.
 */
public void configure(Configuration conf) throws ConfigurationException {
    try {
        String temp = conf.getAttribute(TEMPLATE_KEY, "none");
        if (!temp.equals("none")) {
            temp = loadTemplate(temp);

            setTemplate(temp);
        }
    } catch (Exception e) {
        e.printStackTrace();
        logger_.debug("No template specified in HtmlDisplayPane configuration.", e);
    }

}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:11:43 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int find(java.lang.String srch, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:11:43 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:11:43 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getDocument() {
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:30:34 PM)
 * @return java.lang.String
 */
public java.lang.String getEndIndentifier() {
	return endIndentifier_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 5:18:35 PM)
 * @return java.lang.String
 * @param url java.lang.String
 */
public String getHyperlinkAction(String url) {
    
    if (url.indexOf("http://") > -1) {
        url = url.substring(7);
    }

    int start = url.indexOf(ACTION_URL_KEY);
    if (start < 0) {
        return null;
    }
    start += ACTION_URL_KEY.length();

    String actionname = url.substring(start);

    return actionname;

}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 11:56:23 AM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getIDocument() {
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:11:43 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public butterfly.xmlview.model.interfaces.INode[] getSelectedNodes() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:30:34 PM)
 * @return java.lang.String
 */
public java.lang.String getStartIdentifier() {
	return startIdentifier_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:29:50 PM)
 * @return java.lang.String
 */
public java.lang.String getTemplate() {
	return template_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 4:57:44 PM)
 * @param he javax.swing.event.HyperlinkEvent
 */
public void handleHyperlinkEvent(HyperlinkEvent e) {
	String url = e.getURL().toExternalForm();
	/*
	if(url.indexOf("http://") > -1){
		url = url.substring(7);
	}
	if(e.getEventType().ACTIVATED == e.getEventType()){
		
		String actionname = getHyperlinkAction(url);
		logger_.debug("action role:"+actionname);
		IButterflyAction action = (IButterflyAction)actionLookup_.getAction(actionname);
		if(action != null){
			action.actionPerformed(null);
		}
	}
	*/
	if(e.getEventType().ACTIVATED == e.getEventType()){
	if(url != null){
		LinkActionInfo info = HtmlTemplateUtilities.parseLink(url);
		logger_.debug("attempting to invoke action:"+info.getRole());
		IButterflyAction action = (IButterflyAction)actionLookup_.getAction(info.getRole());
		String[] vars = info.getVariables();
		String[] values = info.getValues();
		if(vars != null){
		for(int i = 0; i < vars.length; i++){
			try{
				Class[] ptypes = {String.class};
				Method m = action.getClass().getMethod("set"+vars[i],ptypes);
				//if(f.getType().getClass() == String.class){
					String[] pass = {values[i]};
					m.invoke(action,pass);
				//}
			}catch(Exception e2){
				e2.printStackTrace();
				logger_.debug("unable to access the field "+vars[i]+" for the action "+info.getRole());
			}
		}
		}
		action.actionPerformed(null);
	}
	}
	//logger_.debug("html display hyperlink event: "+url);	
}
	/**
	 * Called when a hypertext link is updated.
	 *
	 * @param e the event responsible for the update
	 */
public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent e) {
	handleHyperlinkEvent(e);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:11:43 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void loadDocument(butterfly.xmlview.model.interfaces.IDocument doc) {
	document_ =doc;
	setHtml(doc.toString(),new Hashtable());
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 2:25:13 PM)
 * @return java.lang.String
 * @param url java.lang.String
 */
public String loadTemplate(String url) {
	try{
		String temp = butterfly.xmlview.io.XmlViewFileSystem.readFileS(url);
		return temp;
	}catch(Exception e){
		e.printStackTrace();
		logger_.debug("Error loading template: "+url,e);
	}
	return url;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 2:05:23 PM)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	//String template = "<html><head></head><body><b>%%name%%</b><br><b>%%url%%</b></body></html>";
	//Hashtable data = new Hashtable();
	//data.put("name","jules");
	//data.put("url","americanartists.org");	
	//HtmlDisplayPane disp = new HtmlDisplayPane();
	//disp.setHtml(template,data);
	//JFrame f = new JFrame();
	//f.setSize(300,300);
	//f.setContentPane(disp);
	//f.show();
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:26:03 PM)
 * @return java.lang.String
 * @param keyname java.lang.String
 */
public String makeKey(String keyname) {
	return startIdentifier_ + keyname + endIndentifier_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:11:43 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int replace(java.lang.String srch, java.lang.String rep, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:27:11 PM)
 * @return java.lang.String
 * @param key java.lang.String
 * @param value java.lang.String
 */
public String replaceKey(String text, String key, String value) {

	int start = 0;
	while((start = text.indexOf(key)) > -1){
		text = text.substring(0,start) + value + text.substring(start + key.length());
	}
	return text;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 4:57:03 PM)
 */
public void requestActions() {}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 4:57:03 PM)
 * @param lookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup lookup) {
	actionLookup_ = lookup;	
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:31:06 PM)
 * @param data java.util.Hashtable
 */
public void setData(Hashtable data) {
	pane_.setContentType("text/html");
	pane_.setEditable(false);
	
	
	
	data.put("application-path",applicationPath_);
	Enumeration keys = data.keys();

	String currentkey = null;
	Object currentvalue = null;
	String key = null;
	String text = template_;
	
	
	while(keys.hasMoreElements()){
		currentkey = (String)keys.nextElement();
		currentvalue = data.get(currentkey);

		key = makeKey(currentkey);
		if(currentvalue == null){
			currentvalue = "";
		}
		text = replaceKey(text,key,currentvalue.toString());
	}

	pane_.setText(text);
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:30:34 PM)
 * @param newEndIndentifier java.lang.String
 */
public void setEndIndentifier(java.lang.String newEndIndentifier) {
	endIndentifier_ = newEndIndentifier;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:24:14 PM)
 * @param template java.lang.String
 * @param data java.util.Hashtable
 */
public void setHtml(String template, Hashtable data) {
	pane_.setContentType("text/html");
	pane_.setEditable(false);
	template_ = template;
	setData(data);
	//logger_.debug(pane_.getText());
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:38:55 AM)
 * @param start int
 */
public void setSelectionEnd(int end) {
	pane_.setSelectionEnd(end);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:38:55 AM)
 * @param start int
 */
public void setSelectionStart(int start) {
	pane_.setSelectionStart(start);	
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:30:34 PM)
 * @param newStartIdentifier java.lang.String
 */
public void setStartIdentifier(java.lang.String newStartIdentifier) {
	startIdentifier_ = newStartIdentifier;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/2002 1:29:50 PM)
 * @param newTemplate java.lang.String
 */
public void setTemplate(java.lang.String newTemplate) {
	template_ = newTemplate;
}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
	}

	/**
	 * @return Returns the actionLookup_.
	 */
	public IActionLookup getActionLookup() {
		return actionLookup_;
	}

}
