/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.util.StringTokenizer;
import java.util.Vector;
/**
 * Insert the type's description here.
 * Creation date: (11/23/2002 8:52:28 PM)
 * @author: 
 */
public class HtmlTemplateUtilities {
	public final static String ACTION_URL_KEY = "www.butterfly.action/";
/**
 * HtmlTemplateUtilities constructor comment.
 */
public HtmlTemplateUtilities() {
	super();
}
public static String getHyperlinkAction(String url) {
    
    if (url.indexOf("http://") > -1) {
        url = url.substring(7);
    }
    if(url.indexOf("?") > -1){
		url = url.substring(0,url.indexOf("?"));
    }

    int start = url.indexOf(ACTION_URL_KEY);
    if (start < 0) {
        return null;
    }
    start += ACTION_URL_KEY.length();

    String actionname = url.substring(start);

    return actionname;

}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 8:57:28 PM)
 * @return java.lang.String
 * @param link java.lang.String
 */
public static String getLinkParameters(String link) {
	if(link.indexOf("?") < 0){return null;}
	String params = link.substring(link.indexOf("?")+1);
	return params;
}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 8:55:06 PM)
 * @return butterfly.xmlview.gui.LinkActionInfo
 * @param lnk java.lang.String
 */
public static LinkActionInfo parseLink(String lnk) {
	LinkActionInfo info = new LinkActionInfo();
	info.setSource(lnk);
	String role = getHyperlinkAction(lnk);
	info.setRole(role);
	String params = getLinkParameters(lnk);
	if(params != null){
		Vector values = new Vector();
		Vector vars = new Vector();
		StringTokenizer tk = new StringTokenizer(params,"&",false);
		while(tk.hasMoreTokens()){
			String param = tk.nextToken();
			int start = param.indexOf("=");
			if(start > -1){
				String var = param.substring(0,start);
				String value = param.substring(start+1);
				vars.add(var);
				values.add(value);
			}
		}
		info.setVariables((String[])vars.toArray(new String[0]));
		info.setValues((String[])values.toArray(new String[0]));
	}
	return info;
}
}
