/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.xmlview.gui;

import java.io.File;
import java.util.Hashtable;

import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.io.interfaces.IDocumentAccessHistory;
import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Jumpstart extends HtmlDisplayPane implements IComponentRequester{
	private IComponentLookup componentLookup_;
	private static String jumpstartPage_="Jumpstart.htm";
	
	/**
	 * 
	 */
	public Jumpstart() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	

	/* (non-Javadoc)
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
	public void requestComponents() {
		// TODO Auto-generated method stub
		IFileOpenAction open =
		(IFileOpenAction) getActionLookup().getAction(IFileOpenAction.ROLE);
		File file = new File(jumpstartPage_);
		open.setFile(file);
		open.setShowFile(false);
		open.actionPerformed(null);
		IDocument doc = open.getDocument();
		//System.out.println("Jump template"+doc.toString());
		IDocumentAccessHistory hist =
		(IDocumentAccessHistory) componentLookup_.getComponent(IDocumentAccessHistory.ROLE);
		String[] files = hist.getDocumentList();
		int prjcount = 1;
		int filecount = 1;
		String doclist = "<b>Recent Documents:</b><br>";
		String prjlist = "<b>Recent Projects:</b><br>";
		for (int i = 0; i < files.length; i++) {
			String curr = files[i];
			if (!(curr.toLowerCase().indexOf("jumpstart") > -1)) {
				if (curr.endsWith(".bfp")) {
					prjlist += "<a href=\"http://www.butterfly.action/butterfly.actions.interfaces.IFileOpenAction?FileName="+curr+"\">"+prjcount + ". " + curr + "</a><br>";
					prjcount++;
				} else {
					doclist += "<a href=\"http://www.butterfly.action/butterfly.actions.interfaces.IFileOpenAction?FileName="+curr+"\">"+filecount + ". " + curr + "</a><br>";
					filecount++;
				}
			}
			
		}
		
		//BasicDocument bdoc = new BasicDocument();
		//doc.setText("The Jumpstart page allows you to quickly open your most frequently accessed files. It also lets you create popular file types with a single click.");
		
		doc.setName("Jumpstart");
		Hashtable data = new Hashtable();
		data.put("recent-projects", prjlist);
		data.put("recent-documents", doclist);
		loadDocument(doc);
		setData(data);
	}

	/* (non-Javadoc)
	 * @see butterfly.components.interfaces.IComponentRequester#setComponentLookup(butterfly.components.interfaces.IComponentLookup)
	 */
	public void setComponentLookup(IComponentLookup lookup) {
		// TODO Auto-generated method stub
		componentLookup_=lookup;
	}

}
