/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */

package butterfly.xmlview.gui;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.actions.interfaces.INewXmlDocumentAction;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.io.interfaces.IDocumentAccessHistory;
import butterfly.xmlview.model.BasicDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.INode;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class JumpstartPage extends JPanel implements IDocumentEditor{
	private class OpenTrigger extends AbstractAction{
		public String file=null;
			/* (non-Javadoc)
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			// TODO Auto-generated method stub
			IFileOpenAction open = (IFileOpenAction)getActionLookup().getAction(IFileOpenAction.ROLE);
			open.setFile(new File(file));
			open.actionPerformed(null);
		}

}
	
	private class JumpstartDocument extends BasicDocument{
		
		public String getName(){
			return "Jumpstart";
		}
	}
	private JumpstartDocument doc_=new JumpstartDocument();
	
	private IComponentLookup componentLookup_;
	private IActionLookup actionLookup_;
	/**
	 * 
	 */
	public JumpstartPage(IComponentLookup lookup, IActionLookup alookup) {
		super();
		componentLookup_=lookup;
		actionLookup_=alookup;
		init();
		// TODO Auto-generated constructor stub
	}

	public void init(){
		try {
			setLayout(new GridBagLayout());
			GridBagConstraints cons = new GridBagConstraints(
				0,0,
				1,1,
				1,0,
				GridBagConstraints.NORTHWEST,
				GridBagConstraints.HORIZONTAL,
				new Insets(0,0,0,0),
				0,0
			);
			
			JLabel quickactions = new JLabel("I Want to:");
			quickactions.setFont(quickactions.getFont().deriveFont(Font.BOLD).deriveFont((float)18));
			add(quickactions,cons);
			
			AbstractAction nxml = (AbstractAction)getActionLookup().getAction(INewXmlDocumentAction.ROLE);
			AbstractAction open = (AbstractAction)getActionLookup().getAction(IFileOpenAction.ROLE);
			cons.gridy++;
			JButton button = new JButton(nxml);
			button.setText("Create a New XML Document");
			add(button,cons);
			cons.gridy++;
			JButton openb = new JButton(open);
			openb.setText("Open an Existing XML Document");
			add(openb,cons);
			
			JLabel recentprj = new JLabel("Recent Projects:");
			recentprj.setFont(quickactions.getFont().deriveFont(Font.BOLD).deriveFont((float)18));
			cons.gridy+=2;
			add(recentprj,cons);
			
			
			
			
			
		
			//AbstractAction nproj = (AbstractAction)getActionLookup().getAction(INewProjectActio.ROLE);
			
			IDocumentAccessHistory hist =
			(IDocumentAccessHistory) getLookup().getComponent(IDocumentAccessHistory.ROLE);
			String[] files = hist.getDocumentList();
			int prjcount = 1;
			int filecount = 1;
			
			for (int i = 0; i < files.length; i++) {
				String curr = files[i];
				
					if (curr.endsWith(".bfp")) {
						OpenTrigger trigger = new OpenTrigger();
						JButton bt = new JButton(trigger);
						bt.setText(files[i]);
						trigger.file=files[i];
						cons.gridy++;
						add(bt,cons);
						filecount++;
						prjcount++;
					} else {
						
					}
				
				
			}
			JLabel recentdocs = new JLabel("Recent Documents:");
			recentdocs.setFont(quickactions.getFont().deriveFont(Font.BOLD).deriveFont((float)18));
			cons.gridy+=2;
			add(recentdocs,cons);
			for (int i = 0; i < files.length; i++) {
				String curr = files[i];
				
				if (curr.endsWith(".bfp")) {
					
					prjcount++;
				} else {
					OpenTrigger trigger = new OpenTrigger();
					JButton bt = new JButton(trigger);
					bt.setText(files[i]);
					trigger.file=files[i];
					cons.gridy++;
					add(bt,cons);
					filecount++;
				}
				
				
			}
			
			

		} catch (Exception e2) {
			e2.printStackTrace();
		}
	}

	/**
	 * @return Returns the actionLookup_.
	 */
	public IActionLookup getActionLookup() {
		return actionLookup_;
	}

	

	/**
	 * @return Returns the componentLookup_.
	 */
	public IComponentLookup getLookup() {
		return componentLookup_;
	}

	

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#focusOnNode(butterfly.xmlview.model.interfaces.INode)
	 */
	public void focusOnNode(INode node) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getIDocument()
	 */
	
	public IDocument getIDocument() {
		// TODO Auto-generated method stub
		return doc_;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getSelectedNodes()
	 */
	public INode[] getSelectedNodes() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#loadDocument(butterfly.xmlview.model.interfaces.IDocument)
	 */
	public void loadDocument(IDocument doc) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		// TODO Auto-generated method stub

	}

}
