/*
 * Created on May 3, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package butterfly.xmlview.gui;

import java.util.Hashtable;

import butterfly.xmlview.gui.interfaces.IMarkerRenderer;
import butterfly.xmlview.model.WriteProtectionMarker;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.xslt.BreakpointMarker;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class MarkerRendererFactory {
	
	
	
	private static LockRenderer lockRenderer_=new LockRenderer();
	private static ErrorRenderer errorRenderer_ = new ErrorRenderer();
	private static WarningRenderer warningRenderer_=new WarningRenderer();
	private static BreakpointRenderer breakpointRenderer_=new BreakpointRenderer();
	private static Hashtable renderers_ = new Hashtable();
	/**
	 * 
	 */
	private MarkerRendererFactory() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public static IMarkerRenderer getRenderer(IMarker marker){
		IMarkerRenderer rend= (IMarkerRenderer)renderers_.get(new Integer(marker.getID()));
		
		if(rend == null && marker instanceof WriteProtectionMarker){
			rend = lockRenderer_;	
		}
		if(rend == null && marker instanceof BreakpointMarker){
			rend = breakpointRenderer_;
		}
		if(rend == null && marker.getType()==IMarker.WARNING_MARKER){
			return warningRenderer_;	
		}
		if(rend==null ){
			rend = errorRenderer_;
		}
		return rend;
	}

	public static void registerRenderer(IMarker m, IMarkerRenderer c){
		renderers_.put(new Integer(m.getID()),c);
	}
}
