/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import java.util.StringTokenizer;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.log4j.Logger;

import butterfly.xmlview.gui.editors.interfaces.IEditor;
import butterfly.xmlview.gui.editors.interfaces.IEditorManager;
import butterfly.xmlview.gui.editors.interfaces.IEditorSite;
import butterfly.xmlview.gui.editors.interfaces.IEditorSiteManager;
/**
 * Insert the type's description here.
 * Creation date: (11/16/2002 5:12:35 PM)
 * @author: 
 */
public class MultiViewLayoutHandler implements butterfly.xmlview.gui.interfaces.ILayoutHandler {
	
//	class MultiViewSite extends MultiViewComponent implements IEditorManager{
//		private EditorManager manager_=new EditorManager();
//		private IEditor openEditor_;
//		
//		public void setEditorSiteManager(IEditorSiteManager sites){
//			manager_.setEditorSiteManager(sites);
//			viewChanged();
//		}
//		
//		/* (non-Javadoc)
//		 * @see butterfly.xmlview.gui.MultiViewComponent#viewChanged()
//		 */
//		public void viewChanged() {
//			// TODO Auto-generated method stub
//			if(openEditor_!=null){
//				manager_.closeEditor(openEditor_);
//			}
//			IEditor next = null;
//			if(getSelectedIndex() > -1){
//				Component comp =(Component) tab_.getComponent(getSelectedIndex());
//				if(comp instanceof IEditor){
//					next =((IEditor)comp);
//					manager_.openEditor(next);
//				}
//			}
//			openEditor_=next;
//			super.viewChanged();
//		}
//
//	}
	
	private Hashtable panes_;
	private Hashtable components_;
	private Configuration[] paneConfigurations_;
	public static final String COMPONENT_ID = "layout-id";
	public static final String PANE_ORIENTATION = "orientation";
	public static final String FIRST_PANE = "first";
	public static final String SECOND_PANE = "second";
	public static final String DIVIDER_LOCATION = "divider-location";
	public static final String DIVIDER_SIZE = "divider-size";
	public static final String SCROLL_PANE = "scroll";
	public static final String marker = "";
	private static Logger logger_ = Logger.getLogger(MultiViewLayoutHandler.class);
/**
 * SplitPaneLayoutHandler constructor comment.
 */
public MultiViewLayoutHandler() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 5:12:35 PM)
 * @param parent java.awt.Container
 * @param comp java.awt.Component
 * @param param org.apache.avalon.framework.configuration.Configuration
 */
public void addComponent(java.awt.Container parent, java.awt.Component comp, org.apache.avalon.framework.configuration.Configuration[] param) throws Exception {}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 7:29:13 PM)
 * @param id java.lang.String
 * @param num int
 * @param comp java.awt.Component
 */
private void addComponent(String id, int num, java.awt.Component comp) {}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 7:11:07 PM)
 * @param parent java.awt.Container
 * @param comps java.awt.Component[]
 * @param conf org.apache.avalon.framework.configuration.Configuration[]
 */
public void buildLayout(
		java.awt.Container parent,
		java.awt.Component[] comps,
		org.apache.avalon.framework.configuration.Configuration[] conf) {
	buildLayout(parent,comps,conf,null);
}

public void buildLayout(
    java.awt.Container parent,
    java.awt.Component[] comps,
    org.apache.avalon.framework.configuration.Configuration[] conf,IEditorSiteManager site) {

	//if(parent instanceof JDesktopPane){
		//JInternalFrame frame = new JInternalFrame();
		//parent.add(frame);
		//frame.setSize(parent.getSize());
		//frame.getContentPane().setLayout(new GridBagLayout());
		//parent = frame.getContentPane();
		//frame.setVisible(true);
		////return;
		
	//}
	//else{   
   	 parent.setLayout(new GridBagLayout());
	//}
    components_ = new Hashtable();
    

    
    GridBagConstraints constr = new GridBagConstraints();
    constr.gridx = 0;
    constr.gridy = 0;
    constr.weightx = 1.0;
    constr.weighty = 1.0;
    constr.fill = constr.BOTH;
    constr.anchor = GridBagConstraints.NORTH;

    logger_.debug("initialized = "+(paneConfigurations_ != null));
    logger_.debug("confs ok = "+(conf != null && conf.length == comps.length));
    logger_.debug("components ready for storage = "+(components_ != null));

    for (int i = 0; i < comps.length; i++) {
    	
	    logger_.debug("storage information ready = "+(conf[i] != null && comps[i] != null));
	    if(conf[i].getAttribute(SCROLL_PANE,"yes").equals("yes")){
			    //logger_.debug("Making "+comps[i].getClass()+" a scroll pane");
				//logger_.debug("conf.name"+conf[i].getAttribute(COMPONENT_ID,"na"));
				JScrollPane sc = new JScrollPane(comps[i]);
				comps[i] = sc;
            
	    }
	   
        components_.put(conf[i].getAttribute(COMPONENT_ID, "" + 1), comps[i]);
    }
    for (int i = 0; i < paneConfigurations_.length; i++) {
        try {
            JSplitPane pane = new BorderLessSplitPane(JSplitPane.HORIZONTAL_SPLIT);
            pane.setOneTouchExpandable(false);
            float loc = paneConfigurations_[i].getAttributeAsFloat(DIVIDER_LOCATION, 0);
            int size = paneConfigurations_[i].getAttributeAsInteger(DIVIDER_SIZE, 10);
            String id = paneConfigurations_[i].getAttribute(COMPONENT_ID);
            int orient = paneConfigurations_[i].getAttributeAsInteger(PANE_ORIENTATION,0);

			MultiViewSite first = new MultiViewSite();
			MultiViewSite second = new MultiViewSite();
			
			first.setEditorSiteManager(site);
			second.setEditorSiteManager(site);
			
			first.setBorder(new ShadowBorder());
			second.setBorder(new ShadowBorder());
			components_.put(id+".first",first);
			components_.put(id+".second",second);

            if(orient < 1){
           	 pane.setOrientation(pane.HORIZONTAL_SPLIT);
           	 pane.setLeftComponent(first);
           	 pane.setRightComponent(second);
           	// pane.setDividerLocation(loc * parent.getWidth());
            }
            else{
				pane.setOrientation(pane.VERTICAL_SPLIT);
				pane.setTopComponent(first);
				pane.setBottomComponent(second);
				//pane.setDividerLocation(loc * parent.getHeight());
            }
            pane.setResizeWeight(loc);
            pane.setDividerSize(size);

            components_.put(id, pane);
            

            if (i == 0) {
                parent.add(pane, constr);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
     for (int i = 0; i < paneConfigurations_.length; i++) {
        try {
	        String id = paneConfigurations_[i].getAttribute(COMPONENT_ID);
	        String one = paneConfigurations_[i].getAttribute(FIRST_PANE);
	        String two = paneConfigurations_[i].getAttribute(SECOND_PANE);
            JSplitPane pane = (JSplitPane)components_.get(id);     
           
            MultiViewComponent first = (MultiViewComponent)components_.get(id+".first");
			MultiViewComponent sec = (MultiViewComponent)components_.get(id+".second");
			
			StringTokenizer fcs = new StringTokenizer(one,",",false);
			StringTokenizer scs = new StringTokenizer(two,",",false);
			
			String cid = null;
			JComponent c1 = null;
			if(fcs.countTokens() > 1){
				while(fcs.hasMoreElements()){
					cid = fcs.nextToken();
           	  	  	c1 = (JComponent)components_.get(cid);
           	  	
           	   	 	first.addView(cid,c1);
				}
			}
			else{
				cid = fcs.nextToken();
           	  	c1 = (JComponent)components_.get(cid);
           	  	if(c1 instanceof IEditorManager){
           	  		((IEditorManager)c1).setEditorSiteManager(site);
           	  	}
           	  	else if(c1 instanceof IEditor){
           	  		IEditor ed = (IEditor)c1;
           	  		ed.setEditorSite(site.getEditorSite(ed));
           	  	}
           	  	c1.setMinimumSize(new Dimension(1,1));
			if(pane.getOrientation() == pane.HORIZONTAL_SPLIT){
            	pane.setLeftComponent(c1);
           		
            }
            else{
				pane.setTopComponent(c1);
				
            }
			}
			if(scs.countTokens() > 1){
			while(scs.hasMoreElements()){
				cid = scs.nextToken();
           	    c1 = (JComponent)components_.get(cid);
          
           	    sec.addView(cid,c1);
			}
			}
			else{
				cid = scs.nextToken();
           	  	c1 = (JComponent)components_.get(cid);
           	  
           	  	c1.setMinimumSize(new Dimension(1,1));
			if(pane.getOrientation() == pane.HORIZONTAL_SPLIT){
            	pane.setRightComponent(c1);
           		
            }
            else{
				pane.setBottomComponent(c1);
				
            }
			}
           
            
			
			
//            if(pane.getOrientation() == pane.HORIZONTAL_SPLIT){
//            	pane.setLeftComponent(c1);
//           		pane.setRightComponent(c2);
//            }
//            else{
//				pane.setTopComponent(c1);
//				pane.setBottomComponent(c2);
//            }
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 7:15:29 PM)
 * @param conf org.apache.avalon.framework.configuration.Configuration
 */
public void configureLayout(org.apache.avalon.framework.configuration.Configuration[] conf) {
	
	paneConfigurations_ = conf;	
}
}
