/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import org.apache.log4j.Logger;

import butterfly.actions.contenthandlers.ContentType;
import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.contenthandlers.interfaces.IContentType;
import butterfly.actions.contenthandlers.interfaces.IContentTypeLookup;
import butterfly.actions.contenthandlers.interfaces.IUneditableContentTypeHandler;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.interfaces.IComponent;
import butterfly.xmlview.io.interfaces.IDocumentCache;
import butterfly.xmlview.io.interfaces.IFileSystem;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IEditInfo;
import butterfly.xmlview.model.interfaces.IEditable;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class NewFileWizard extends JDialog implements IComponent,IComponentRequester{
	private IComponentLookup lookup_;
	private Hashtable pages_;
	private NewFileTemplate selectedPage_;
	private JLabel contentNameLabel_;
	private JLabel contentDescriptionLabel_;
	private JPanel contentPanel_;
	private JTree tree_;
	private NewFileTemplate[] templates_;
	private static Logger logger_ = Logger.getLogger(NewFileWizard.class);
	
	
	class NewFileTemplate	implements IEditable{
		private IContentType type_;
		private Properties properties_;
		private IEditInfo[] editableProperties_;
		public NewFileTemplate(IContentType type){
			type_ = type;	
		}
		
		public String getDisplayName(){
			return type_.getDisplayName();	
		}
		
		/**
		 * @see butterfly.xmlview.model.interfaces.IEditable#getDescription()
		 */
		public String getDescription() {
			return type_.getDescription();
		}

		/**
		 * @see butterfly.xmlview.model.interfaces.IEditable#getEditableProperties()
		 */
		public IEditInfo[] getEditableProperties() {
			if(editableProperties_ == null){
			Properties props = (Properties)type_.getDefaultProperties().clone();
			properties_ = props;
			Enumeration enum = props.propertyNames();
			Vector edits = new Vector();
			while(enum.hasMoreElements()){
				String pname = (String)enum.nextElement();
				PropertiesEditInfo info = new PropertiesEditInfo(props,pname);
				info.setLabelDescription(info.getPropertyName());
				String desc = props.getProperty(ContentType.DESCRIPTION_ATTRIBUTE+pname);
				if(desc != null){
					info.setDescription(desc);	
				}
				edits.add(info);
			}
			editableProperties_ = ((IEditInfo[])edits.toArray(new IEditInfo[0]));
			}
			return editableProperties_;
		}

		/**
		 * @see butterfly.xmlview.model.interfaces.IEditable#getTitle()
		 */
		public String getTitle() {
			return "";//type_.getName();
		}
		
		public String toString(){
			return getDisplayName();	
		}

		/**
		 * Returns the type.
		 * @return IContentType
		 */
		public IContentType getType() {
			return type_;
		}

		/**
		 * Sets the type.
		 * @param type The type to set
		 */
		public void setType(IContentType type) {
			type_ = type;
		}

		/**
		 * Returns the properties.
		 * @return Properties
		 */
		public Properties getProperties() {
			return properties_;
		}

		/**
		 * Sets the properties.
		 * @param properties The properties to set
		 */
		public void setProperties(Properties properties) {
			properties_ = properties;
		}

	}
	/**
	 * Constructor for NewFileWizard.
	 * @param owner
	 * @param modal
	 * @throws HeadlessException
	 */
	public NewFileWizard(Frame owner, boolean modal) throws HeadlessException {
		super(owner, modal);
		init();
	}

	protected void init(){
		if(lookup_ == null){ButterflyApplication.setLookups(this);}
		contentPanel_ = new JPanel();
		setContentPane(contentPanel_);
		NewFileTemplate[] temps = getFileTemplates();
		templates_=temps;
		pages_ = new Hashtable(temps.length);
		for(int i=0; i < temps.length; i++){
			pages_.put(temps[i].getDisplayName(),temps[i]);	
			pages_.put(temps[i].getType(),temps[i]);
		}
		
		Dimension max = getToolkit().getScreenSize();
		int x = (int)(((float)max.width)/2.0);
		int y = (int)(((float)max.height)/2.0);
		int width = 500;
		int height = 300;
		
		
		final EditPane editor = new EditPane();
		JTree tree = new JTree(temps);
		tree_ = tree;
		tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		tree.addTreeSelectionListener(
			new TreeSelectionListener(){
				public void valueChanged(TreeSelectionEvent e){
					pageSelected((NewFileTemplate)((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject());
					editor.edit((NewFileTemplate)((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject());
					
				}
			}
		);
		
		setSize(400,400);
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints cons = new GridBagConstraints();
		cons.gridx = 0;
		cons.gridy = 0;
		cons.gridheight = 5;
		cons.gridwidth = 1;
		cons.fill = cons.BOTH;
		cons.weighty = 1.0;
		cons.weightx = 0;
		cons.anchor = cons.NORTHEAST;
		
		JScrollPane tscroll = new JScrollPane(tree);
		tscroll.setMinimumSize(new Dimension(width/3,height));
		
		getContentPane().add(tscroll,cons);
		
		
		contentNameLabel_ = new JLabel(temps[0].getDisplayName());
		contentDescriptionLabel_ = new JLabel(temps[0].getDescription());
		
		cons.weighty = 0;
		cons.gridx = 1;
		cons.gridy = 0;
		cons.gridheight = 1;
		cons.gridwidth = 1;
		cons.fill = cons.HORIZONTAL;
		cons.weighty = 0;
		cons.weightx = 1;
		getContentPane().add(contentNameLabel_,cons);
		
		cons.gridy++;
		getContentPane().add(contentDescriptionLabel_,cons);
		
		
		cons.fill = cons.BOTH;
		cons.weighty = 1.0;
		cons.gridy++;
		cons.gridheight = 3;
		getContentPane().add(new JScrollPane(editor),cons);
		
		JButton ok = new JButton("Ok");
		ok.addActionListener(
			new ActionListener(){
				public void actionPerformed(ActionEvent ae){
					createFile();
				}	
			}
		);
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(
			new ActionListener(){
				public void actionPerformed(ActionEvent ae){
					setVisible(false);
				}	
			}
		);
		JPanel buttonpanel = new JPanel();
		buttonpanel.setLayout(new GridBagLayout());
		GridBagConstraints cons3 = new GridBagConstraints();
		cons3.gridx = 1;
		cons3.gridy = 0;
		cons3.gridheight = 1;
		cons3.gridwidth = 1;
		cons3.fill = cons.HORIZONTAL;
		cons3.weighty = 0;
		cons3.weightx = 0.0;
		cons3.anchor = cons.NORTHEAST;
		
	
		buttonpanel.add(ok,cons3);
		cons3.gridx++;
		buttonpanel.add(cancel,cons3);
		cons3.gridx = 0;
		cons3.weightx = 1.0;
		buttonpanel.add(new JPanel(),cons3);
		cons3.gridx = 3;
		buttonpanel.add(new JPanel(),cons3);
			
		GridBagConstraints cons2 = new GridBagConstraints();
		cons2.gridx = 0;
		cons2.gridy = 5;
		cons2.gridheight = 1;
		cons2.gridwidth = 2;
		cons2.fill = cons.HORIZONTAL;
		cons2.weighty = 0;
		cons2.weightx = 1.0;
		cons2.anchor = cons.NORTHWEST;
		getContentPane().add(buttonpanel,cons2);
		
		
	/*	JButton ok = new JButton("Ok");
		cons.gridy++;
		cons.gridwidth = 1;
		getContentPane().add(ok,cons);
		
		JButton cancel = new JButton("Cancel");
		cons.gridx++;
		getContentPane().add(cancel,cons);*/
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
		
		TreePath path = new TreePath(((DefaultMutableTreeNode)root.getChildAt(0)).getPath());
		tree.getSelectionModel().setSelectionPath(path);
		//tree.getSelectionModel().s
		pageSelected(temps[0]);
		
		setSize(width,height);
		setLocation(x-(width/2),y-(height/2));
		setResizable(false);
		setTitle("New Document"); 
	}
	
	public void createFile(){
		try{
		IContentHandlerLookup lookup = (IContentHandlerLookup)lookup_.getComponent(IContentHandlerLookup.ROLE);
		IContentHandler handler = lookup.getContentHandler(selectedPage_.getType().getName());
		IDocument doc = handler.createDocument(null,selectedPage_.getProperties());
		//doc.setName("Docment"+newDocCount_+".xml");
		IFileSystem filesystem = (IFileSystem)lookup_.getComponent(IFileSystem.ROLE);
		if(doc.getName()==null){
			File nf = filesystem.createNewFile("xml");
			doc.setName(nf.getName());
			doc.setExists(false);
			doc.setSourceFileName(nf.getAbsolutePath());
		}
//		if(doc.getSourceFileName() != null){
//			filesystem.saveTempFile(doc.getSourceFileName(),doc.toString());
//		}
		logger_.debug("caching document");
		IDocumentCache cache = (IDocumentCache)lookup_.getComponent(IDocumentCache.ROLE);
		if(cache != null){
			cache.cacheDocument(doc);	
		}
		logger_.debug("showing document");
		handler.showDocument(doc,IContentHandler.READ_WRITE);
		}catch(Exception e){
			e.printStackTrace();
		}
		setVisible(false);
	}
	
	public void pageSelected(NewFileTemplate temp){
		//logger_.debug("page selected:"+temp);
		selectedPage_ = temp;
		contentNameLabel_.setText(temp.getDisplayName());
		contentDescriptionLabel_.setText(temp.getDescription());
		contentPanel_.revalidate();
	}
	
	
	
	protected NewFileTemplate[] getFileTemplates(){
		IContentTypeLookup ctypes = (IContentTypeLookup)lookup_.getComponent(IContentTypeLookup.ROLE);
		IContentHandlerLookup chandlers = (IContentHandlerLookup)lookup_.getComponent(IContentHandlerLookup.ROLE);
		Enumeration enum = ctypes.getContentTypes();
		Vector temps = new Vector();
		IContentType type = null;
		while(enum.hasMoreElements()){
			type = (IContentType)enum.nextElement();
			if(!(chandlers.getContentHandler(type.getName()) instanceof IUneditableContentTypeHandler) ){
				temps.add(new NewFileTemplate((IContentType)type));	
			}
		}
		return ((NewFileTemplate[])temps.toArray(new NewFileTemplate[0]));
	}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
	public void requestComponents() {
	}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#setComponentLookup(IComponentLookup)
	 */
	public void setComponentLookup(IComponentLookup lookup) {
		lookup_ = lookup;
	}

	/**
	 * @see java.awt.Component#show()
	 * @deprecated
	 */
	public void show(IContentType type) {
		int index = -1;
		for(int i = 0; i < templates_.length; i++){
			if(templates_[i].getType().equals(type)){
				index = i;
				break;
			}	
		}
		if(index>-1){
			tree_.setSelectionRow(index);
		}
		super.show();
	}

}
