/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Color;

import butterfly.xmlview.gui.interfaces.INodeStyle;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class NodeStyle implements INodeStyle {
	private Color foreground_;
	private Color background_;
	private boolean bold_;
	private boolean italicized_;
	
	

	/**
	 * Returns the bold.
	 * @return boolean
	 */
	public boolean isBold() {
		return bold_;
	}

	/**
	 * Returns the italicized.
	 * @return boolean
	 */
	public boolean isItalicized() {
		return italicized_;
	}

	/**
	 * Sets the background.
	 * @param background The background to set
	 */
	public void setBackground(Color background) {
		background_ = background;
	}

	/**
	 * Sets the bold.
	 * @param bold The bold to set
	 */
	public void setBold(boolean bold) {
		bold_ = bold;
	}

	/**
	 * Sets the foreground.
	 * @param foreground The foreground to set
	 */
	public void setForeground(Color foreground) {
		foreground_ = foreground;
	}

	/**
	 * Sets the italicized.
	 * @param italicized The italicized to set
	 */
	public void setItalicized(boolean italicized) {
		italicized_ = italicized;
	}

	/**
	 * Returns the background.
	 * @return Color
	 */
	public Color getBackground() {
		return background_;
	}

	/**
	 * Returns the foreground.
	 * @return Color
	 */
	public Color getForeground() {
		return foreground_;
	}

}
