/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultTreeModel;

import butterfly.xmlview.gui.interfaces.IComponent;
import butterfly.xmlview.gui.interfaces.INodeSelectionListener;
import butterfly.xmlview.gui.interfaces.IXmlRenderer;
import butterfly.xmlview.gui.tree.DocumentTree;
import butterfly.xmlview.gui.tree.DocumentTreeModel;
import butterfly.xmlview.gui.tree.PipelineTreeEditor;
import butterfly.xmlview.gui.tree.TreeEditorLookup;
import butterfly.xmlview.gui.tree.XmlTreeEditor;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.interfaces.IComment;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IProcessingInstruction;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.model.pipeline.PipelineDocument;
import butterfly.xmlview.model.pipeline.ResultNode;
import butterfly.xmlview.model.pipeline.SourceNode;
import butterfly.xmlview.model.pipeline.TransformationNode;
import butterfly.xmlview.model.transformation.DocumentSource;
import butterfly.xmlview.model.transformation.Pipeline;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PipelineEditor extends DocumentTree implements IXmlRenderer,IComponent{
	private JScrollPane scrollPane_;
	private JPanel debugPane_;
	private JSplitPane contentPane_;
	/**
	 * Constructor for PipelineEditor.
	 * @param t
	 */
	public PipelineEditor(DefaultTreeModel t) {
		super(t);
	}
	public PipelineEditor() {
		super(new DocumentTreeModel(new javax.swing.tree.DefaultMutableTreeNode("XML Pipeline")));
		((DocumentTreeModel)getTreeModel()).setTree(this);
		TreeEditorLookup lookup = new TreeEditorLookup();
	
	XmlTreeEditor ed = new PipelineTreeEditor();
	ed.setAllowUndeclaredElements(false);
	ed.setShowAttributes(true);
	lookup.registerTreeEditor(IElement.class, ed);
	lookup.registerTreeEditor(SourceNode.class,ed);
	lookup.registerTreeEditor(TransformationNode.class,ed);
	lookup.registerTreeEditor(IValueNode.class,ed );
	lookup.registerTreeEditor(ResultNode.class,ed);
	lookup.registerTreeEditor(IDocumentDeclaration.class, ed);
	lookup.registerTreeEditor(IProcessingInstruction.class,ed);
	lookup.registerTreeEditor(IComment.class, ed);
	lookup.registerTreeEditor(IDTDNode.class, ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
//	lookup.registerTreeEditor(DocumentRoot.class,ed);
	setTreeEditorLookup(lookup);
	scrollPane_ = new JScrollPane(this);
	//contentPane_=new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
	//contentPane_.setLeftComponent(scrollPane_);
	//buildDebugPane();
	//contentPane_.setRightComponent(debugPane_);
	//contentPane_.setDividerLocation(500);
	//contentPane_.setOneTouchExpandable(true);
	}

//	public void buildDebugPane(){
//		debugPane_=new JPanel();
//		debugPane_.setLayout(new GridBagLayout());
//		GridBagConstraints cons = new GridBagConstraints();
//		cons.gridx=0;
//		cons.gridy=0;
//		cons.fill=GridBagConstraints.BOTH;
//		debugPane_.add(new JLabel("Debugger"),cons);
//	}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getSelectedTag()
	 */
	public String getSelectedTag() {
		return null;
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#addNodeSelectionListener(INodeSelectionListener)
	 */
	public void addNodeSelectionListener(INodeSelectionListener l) {
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#removeNodeSelectionListener(INodeSelectionListener)
	 */
	public void removeNodeSelectionListener(INodeSelectionListener l) {
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getSelectedTagXPath()
	 */
	public String getSelectedTagXPath() {
		return null;
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getXmlModel()
	 */
	public IXmlDocument getXmlModel() {
		return null;
	}

//	public void openDebugger(){
//		
//		contentPane_.setDividerLocation(contentPane_.getWidth()-200);
//		contentPane_.setLastDividerLocation(50000);
//	}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#renderXmlDocument(IXmlDocument)
	 */
	public JComponent renderXmlDocument(IXmlDocument doc) {
		Pipeline pl = new Pipeline();
		pl.setSource(new DocumentSource(doc));
		//pl.addTransformation(0,new XSLTTransformation(),new Properties());
		this.loadDocument(new PipelineDocument(pl));
		expandColumn(1);
		//contentPane_.setDividerLocation(50000);
		//contentPane_.setLastDividerLocation(contentPane_.getWidth()-200);
		return scrollPane_;
		//return contentPane_;
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#setSelectionEnd(int)
	 */
	public void setSelectionEnd(int start) {
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#setSelectionStart(int)
	 */
	public void setSelectionStart(int start) {
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#focusOnNode(INode)
	 */
	public void focusOnNode(INode node) {
	}
	

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getIDocument()
	 */
	public IDocument getIDocument() {
		return null;
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getSelectedNodes()
	 */
	public INode[] getSelectedNodes() {
		return null;
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
	}

}
