/*
 * Created on Jun 16, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package butterfly.xmlview.gui;

import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.model.DocumentGeneratedSourceEvent;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentSourceEvent;
import butterfly.xmlview.model.interfaces.IDocumentSourceListener;
import butterfly.xmlview.model.interfaces.INode;

/**
 * @author Jules White
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PlainTextEditor extends JEditorPane implements IDocumentEditor , IDocumentSourceListener, DocumentListener{
	private IDocument document_;
	private boolean locked_=false;
	
	
	public PlainTextEditor(){
		getDocument().addDocumentListener(this);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#focusOnNode(butterfly.xmlview.model.interfaces.INode)
	 */
	public void focusOnNode(INode node) {
		// TODO Auto-generated method stub
		setSelection(node.getStart(),node.getLength());
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(butterfly.xmlview.model.interfaces.IDocumentEvent)
	 */
	public void handleDocumentSourceEvent(IDocumentSourceEvent evt) {
		if(!isLocked()){
			if (evt instanceof DocumentGeneratedSourceEvent || document_.length() != getDocument().getLength()) {
				
				try {
					//getDocument().remove(evt.getStart(),evt.getLength());
					//getDocument().insertString(evt.getStart(),evt.getText(),null);
					INode curr = null;
					INode[] where = getSelectedNodes();
					if (where.length > 0) {
						curr = where[0];
					}
					
					if (evt.getLength() >= getDocument().getLength()) {
						setText(evt.getText());
					} else {
						if (evt.getLength() > 0) {
							getDocument().remove(
								evt.getStart(),
								evt.getLength());
						}
						if (evt.getText() != null) {
							getDocument().insertString(
								evt.getStart(),
								evt.getText(),
								null);
						}
					}
					//setText(model_.toString());
					//setText(evt.getText());
					//setText(getXmlModel().toString());
					if (curr != null) {
						//focusOnNode(curr);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
				
			}
		}
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
	 */
	public void changedUpdate(DocumentEvent e) {
		lock();
		try{
		
		Document doc = (Document) e.getDocument();
		int changeLength = e.getLength();
		String text = doc.getText(e.getOffset(), changeLength);
		document_.removeString(e.getOffset(),e.getLength());
		document_.insertString(e.getOffset(),text);
		}catch(Exception ex){
			ex.printStackTrace();
		}
		unlock();
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
	 */
	public void insertUpdate(DocumentEvent e) {
		lock();
		try{
		int changeLength = e.getLength();
		String text = getDocument().getText(e.getOffset(), changeLength);
		document_.insertString(e.getOffset(),text);
		}catch(Exception ex){
			ex.printStackTrace();
		}
		unlock();
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
	 */
	public void removeUpdate(DocumentEvent e) {
		lock();
		try{
		Document doc = (Document) e.getDocument();
		int changeLength = e.getLength();

		document_.removeString(e.getOffset(), changeLength);
		}catch(Exception ex){
			ex.printStackTrace();
		}
		unlock();
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getIDocument()
	 */
	public IDocument getIDocument() {
		// TODO Auto-generated method stub
		return document_;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getSelectedNodes()
	 */
	public INode[] getSelectedNodes() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#loadDocument(butterfly.xmlview.model.interfaces.IDocument)
	 */
	public void loadDocument(IDocument doc) {
		// TODO Auto-generated method stub
		if(document_!=null){
			document_.removeDocumentSourceListener(this);
		}
		document_=doc;
		document_.addDocumentSourceListener(this);
		
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		// TODO Auto-generated method stub
		super.setSelectionStart(start);
		super.setSelectionEnd(start+length);
	}

	public void lock(){
		locked_=true;
	}
	public void unlock(){
		locked_=false;
	}
	public boolean isLocked(){
		return locked_;
	}
}
