/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.util.Properties;

import javax.swing.JComponent;

import butterfly.xmlview.model.EditInfo;
import butterfly.xmlview.model.interfaces.IAcceptor;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PropertiesEditInfo extends EditInfo {
	private IAcceptor acceptor_;
	private JComponent editor_;
	/**
	 * Constructor for PropertiesEditInfo.
	 * @param target
	 */
	public PropertiesEditInfo(Properties target) {
		super(target);
	}

	/**
	 * Constructor for PropertiesEditInfo.
	 * @param target
	 * @param property
	 */
	public PropertiesEditInfo(Properties target, String property) {
		super(target, property);
	}
	
	public PropertiesEditInfo(Properties target, String property,IAcceptor acceptor) {
		super(target, property);
		acceptor_ = acceptor;
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.IEditInfo#handleEdit(String)
	 */
	public boolean handleEdit(String ntext) {
		Properties props = (Properties)getTarget();
		boolean valid = true;
		if(acceptor_ != null){
			valid = validate(ntext);
		}
		if(valid){
			props.setProperty(getPropertyName(),ntext);
		}
		return valid;
	}
	
	protected boolean validate(String value){
		for(int i = 0; i < value.length(); i++){
			acceptor_.accept(value.charAt(i));
			if(acceptor_.getState() == acceptor_.FATAL_ERROR_STATE){
				break;	
			}	
		}
		return (acceptor_.getState() == IAcceptor.ACCEPT_STATE);
	}

	/**
	 * @see butterfly.xmlview.model.EditInfo#setTarget(Object)
	 */
	public void setTarget(Object newTarget) {
		if(!(newTarget instanceof Properties)){
			return;	
		}
		super.setTarget(newTarget);
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.IEditInfo#getValue()
	 */
	public String getValue() {
		return ((Properties)getTarget()).getProperty(getPropertyName());
	}

}
