package butterfly.xmlview.gui;

import javax.swing.text.html.*;
import javax.swing.text.*;

public class RelativeHTMLEditorKit extends HTMLEditorKit {

  public ViewFactory getViewFactory() {
    return new HTMLFactoryX();
  }


  public static class HTMLFactoryX extends HTMLFactory
    implements ViewFactory {
    
    public View create(Element elem) {
      Object o = 
        elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
      if (o instanceof HTML.Tag) {
	HTML.Tag kind = (HTML.Tag) o;
        if (kind == HTML.Tag.IMG) 
          return new RelativeImageView(elem);
      }
      return super.create( elem );
    }
  }
}










