/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer;
import butterfly.xmlview.gui.interfaces.ISearchControl;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.search.interfaces.ISearch;
import butterfly.xmlview.search.interfaces.ISearchResult;
/**
 * Insert the type's description here.
 * Creation date: (12/9/2002 11:11:14 AM)
 * @author: 
 */
public class SearchControl extends javax.swing.JInternalFrame implements ISearchControl,IComponentRequester,Configurable{
	private IActionLookup actionLookup_;
	private IComponentLookup componentLookup_;
	private JLabel searchTypeLabel_ = new JLabel("Search type:");
	private JLabel searchStringLabel_ = new JLabel("Search for:");
	private JTextField searchStringField_ = new JTextField();
	private JComboBox searchType_ = new JComboBox();
	private JButton findNext_ = new JButton("Find Next");
	private JButton findPrev_ = new JButton("Find Prev");
	private JButton replace_ = new JButton("Replace/Find Next");
	private JButton replacePrev_ = new JButton("Replace/Find Prev");
	private JButton replaceAll_ = new JButton("Replace All");
	private JLabel replaceLabel_ = new JLabel("Replace with:");
	private JTextField replaceValue_ = new JTextField();
	private JButton cancel_ = new JButton("Cancel");
	private Hashtable searches_ = new Hashtable(3);
	private Configuration configuration_;
	public static String SEARCH_ROLE = "role";
	private String lastSearch_;
	
	//private ISearchResult lastResult_;
	private static Logger logger_ = Logger.getLogger(SearchControl.class);
	//private JButton findPrev_ = new JButton("Find
/**
 * SearchControl constructor comment.
 */
public SearchControl() {
	super();
	//setModal(true);
	setMinimumSize(new java.awt.Dimension(400,200));
	setClosable(false);
	setResizable(false);
	setMaximizable(false);
	setIconifiable(false);
	getContentPane().setLayout(new GridBagLayout());
	GridBagConstraints cons = new GridBagConstraints();
	cons.insets = new java.awt.Insets(10,5,10,5);
	cons.gridx = 0;
	cons.gridy = 0;
	cons.weightx = 0;
	cons.weighty = 0;
	cons.gridwidth = 1;
	cons.gridheight = 1;
	cons.anchor = cons.NORTHWEST;
	cons.fill = cons.BOTH;

	getContentPane().add(searchTypeLabel_,cons);

	cons.gridx = 1;
	cons.weightx = 1;
	cons.gridwidth = 3;

	getContentPane().add(searchType_,cons);

	cons.anchor = cons.NORTHWEST;
	cons.gridwidth = 1;
	cons.gridy=1;
	cons.gridx=0;
	cons.weightx = 0;
	cons.weighty = 0;

	getContentPane().add(searchStringLabel_,cons);

	cons.gridwidth = 3;
	cons.gridx=1;
	cons.weightx = 1;
	cons.weighty = 0;

	getContentPane().add(searchStringField_,cons);
	
	cons.anchor = cons.NORTHEAST;
	cons.gridwidth = 1;
	cons.gridx=0;
	cons.gridy=2;
	cons.weightx = 0;
	cons.weighty = 0;
	
	getContentPane().add(replaceLabel_,cons);
	cons.gridx=1;
	cons.gridy=2;
	cons.gridwidth=3;
	cons.weightx=1.0;
	getContentPane().add(replaceValue_,cons);
	

	cons.anchor = cons.NORTHEAST;
	cons.gridwidth = 1;
	cons.gridx=1;
	//cons.gridy=2;
	cons.gridy=3;
	cons.weightx = 0;
	cons.weighty = 0;

	findNext_.addActionListener(new ActionListener(){
		public void actionPerformed(java.awt.event.ActionEvent ae){
			findNext();
		}
	});

	getContentPane().add(findNext_,cons);

	cons.anchor = cons.NORTHEAST;
	cons.gridwidth = 1;
	cons.gridx=2;
	cons.gridy=3;//cons.gridy=2;
	cons.weightx = 0;
	cons.weighty = 0;

	findPrev_.addActionListener(new ActionListener(){
		public void actionPerformed(java.awt.event.ActionEvent ae){
			findPrev();
		}
	});

	//findPrev_.setEnabled(false);
	
	getContentPane().add(findPrev_,cons);

	cons.anchor = cons.NORTHWEST;
	cons.gridwidth = 1;
	cons.gridx=3;
	cons.gridy=3;//cons.gridy=2;
	cons.weightx = 0;
	cons.weighty = 0;
	cons.fill = cons.NONE;

	cancel_.addActionListener(new ActionListener(){
		public void actionPerformed(java.awt.event.ActionEvent ae){
			cancel();
		}
	});

	getContentPane().add(cancel_,cons);
	
	cons.anchor=cons.NORTHWEST;
	cons.gridy++;
	cons.gridx=1;
	replace_.addActionListener(
		new ActionListener() {
			/**
			 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
			 */
			public void actionPerformed(ActionEvent e) {
				replace();
				findNext();
			}
		}
	);
	getContentPane().add(replace_,cons);
	cons.gridx++;
	replaceAll_.addActionListener(
		new ActionListener() {
			/**
			 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
			 */
			public void actionPerformed(ActionEvent e) {
				replaceAll();
			}
		}
	);
	getContentPane().add(replacePrev_,cons);
	cons.gridx++;
	replacePrev_.addActionListener(
		new ActionListener() {
			/**
			 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
			 */
			public void actionPerformed(ActionEvent e) {
				replace();
				findPrev();
			}
		}
	);
	getContentPane().add(replaceAll_,cons);
	

	cons.gridy = 3;
	cons.gridx = 0;
	cons.gridwidth = 3;
	cons.weightx = 1;
	cons.weighty = 1;
	getContentPane().add(new JPanel(),cons);
	super.setSize(300,200);
	
	setReplaceEnabled(false);
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 12:05:01 PM)
 */
public void cancel() {
	setVisible(false);	
}
/**
 * configure method comment.
 */
public void configure(org.apache.avalon.framework.configuration.Configuration arg1) throws org.apache.avalon.framework.configuration.ConfigurationException {
	configuration_ = arg1;	
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 12:08:24 PM)
 */
public boolean findNext() {
	System.out.println("findNext()");
    //Runnable r = new Runnable() {
       // public void run() {
            IDocumentEditorOrganizer organizer =
                (IDocumentEditorOrganizer) getComponentLookup().getComponent(
                    IDocumentEditorOrganizer.ROLE);
            IDocumentEditor ed = organizer.getActiveDocumentEditor();
            IDocument doc = ed.getIDocument();
            if(doc == null){
            	System.out.println("no doc");
            	return false;}
            IXmlViewInformer inform = (IXmlViewInformer)getComponentLookup().getComponent(IXmlViewInformer.ROLE);

            String sname = (String) searchType_.getSelectedItem();
            ISearch search = (ISearch) searches_.get(sname);
            if(!doc.equals(search.getDocument())){
            	search.setDocument(doc);
            }
            System.out.println("go...");
            String pattern = searchStringField_.getText();
            ISearchResult result = search.next(pattern);
            if(result == null){
            	return false;	
            }
            if(result.getNode() != null){
            	ed.focusOnNode(result.getNode());	
            }
            else{
            	ed.setSelection(result.getStart(),result.getLength());
            }
            return true;
        
      //  }
   // };
   // javax.swing.SwingUtilities.invokeLater(r);
    

}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 12:08:24 PM)
 */
public boolean findPrev() {
	System.out.println("findPrev()");
   // Runnable r = new Runnable() {
    //    public void run() {
            IDocumentEditorOrganizer organizer =
                (IDocumentEditorOrganizer) getComponentLookup().getComponent(
                    IDocumentEditorOrganizer.ROLE);
            IDocumentEditor ed = organizer.getActiveDocumentEditor();
            IDocument doc = ed.getIDocument();
            if(doc == null){
            	System.out.println("no doc");
            	return false;}
            IXmlViewInformer inform = (IXmlViewInformer)getComponentLookup().getComponent(IXmlViewInformer.ROLE);

            String sname = (String) searchType_.getSelectedItem();
            ISearch search = (ISearch) searches_.get(sname);
            if(!doc.equals(search.getDocument())){
            	search.setDocument(doc);
            }
            System.out.println("go...");
            String pattern = searchStringField_.getText();
            ISearchResult result = search.previous(pattern);
            if(result == null){
            	return false;
            	
            }
            if(result.getNode() != null){
            	ed.focusOnNode(result.getNode());	
            }
            else{
            	ed.setSelection(result.getStart(),result.getLength());
            }
            return true;
    //    }
    //};
    //javax.swing.SwingUtilities.invokeLater(r);
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:28:36 AM)
 * @return butterfly.actions.interfaces.IActionLookup
 */
public butterfly.actions.interfaces.IActionLookup getActionLookup() {
	return actionLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:28:36 AM)
 * @return butterfly.components.interfaces.IComponentLookup
 */
public butterfly.components.interfaces.IComponentLookup getComponentLookup() {
	return componentLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 12:01:35 PM)
 * @param search butterfly.actions.search.interfaces.ISearch
 */
public void registerSearch(ISearch search) {
	searches_.put(search.getName(),search);
	searchType_.addItem(search.getName());	
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:28:26 AM)
 */
public void requestComponents() {
	Configuration[] searchconf = configuration_.getChildren();
	
	for(int i = 0; i < searchconf.length; i++){
		try{
			String role = searchconf[i].getAttribute(SEARCH_ROLE);
			ISearch search = (ISearch)getComponentLookup().getComponent(role);
			registerSearch(search);
		}catch(Exception e){
			e.printStackTrace();
		}
		
	}	
}

/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:28:36 AM)
 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup newActionLookup) {
	actionLookup_ = newActionLookup;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:28:36 AM)
 * @param newComponentLookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(butterfly.components.interfaces.IComponentLookup newComponentLookup) {
	componentLookup_ = newComponentLookup;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 4:09:21 PM)
 * @param x int
 * @param y int
 */
public void setSize(int x, int y) {}

public void setReplaceEnabled(boolean rep){
	replace_.setVisible(rep);
	replaceAll_.setVisible(rep);	
	replaceLabel_.setVisible(rep);
	replaceValue_.setVisible(rep);
	replacePrev_.setVisible(rep);
	pack();
	revalidate();
}

public void replaceAll(){
	String sname = (String) searchType_.getSelectedItem();
	ISearch search = (ISearch) searches_.get(sname);
	IDocumentEditorOrganizer organizer =
                (IDocumentEditorOrganizer) getComponentLookup().getComponent(
                    IDocumentEditorOrganizer.ROLE);
            IDocumentEditor ed = organizer.getActiveDocumentEditor();
            IDocument doc = ed.getIDocument();
            if(doc == null){
            	System.out.println("no doc");
            	return;}
    search.setDocument(doc);
    ISearchResult curr = null;
    findNext();
    while(replace()){
    	findNext();
    }	
}

public boolean replace(){
		IDocumentEditorOrganizer organizer =
                (IDocumentEditorOrganizer) getComponentLookup().getComponent(
                    IDocumentEditorOrganizer.ROLE);
            IDocumentEditor ed = organizer.getActiveDocumentEditor();
            IDocument doc = ed.getIDocument();
            if(doc == null){
            	System.out.println("no doc");
            	return false;}
            	
        String sname = (String) searchType_.getSelectedItem();
        ISearch search = (ISearch) searches_.get(sname);
        if(!doc.equals(search.getDocument())){
        	return false;	
        }
        ISearchResult result = search.current();
        if(result == null){
        	return false;	
        }     
        if(result.getStart()>-1){
       	 int start = result.getStart(); 
       	 int length = result.getLength();
       	 doc.removeString(start,length);
       	 doc.insertString(start,replaceValue_.getText());
       	 	return true;  
        }
        return false;
}
}
