/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;
import javax.swing.border.AbstractBorder;
import java.awt.*;

public class ShadowBorder extends AbstractBorder
{
    private static final Color borderColor = new Color(132, 130, 132);
    private static final Color shadow1Color = new Color(143, 141, 138);
    private static final Color shadow2Color = new Color(171, 168, 165);
    private static final ShadowBorder instance = new ShadowBorder();

    public Insets getBorderInsets(Component c)
    {
        return new Insets(8, 1, 3, 3);
    }

    public Insets getBorderInsets(Component c, Insets insets)
    {
        insets.left = 1;
        insets.top = 8;
        insets.right = insets.bottom = 3;
        return insets;
    }

    public boolean isBorderOpaque()
    {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
    {
        Color oldColor = g.getColor();
        g.translate(x, y);

        g.setColor(borderColor);
        g.drawRoundRect(0, 0, width - 3, height - 3,10,10);
        g.fillRect(0,height-10,10,10);
        g.fillRect(width-10,height-10,10,10);

        g.setColor(shadow1Color);
        g.drawLine(width - 2, 3, width - 2, height - 5);
        g.drawLine(1, height - 2, width - 2, height - 2);

        g.setColor(shadow2Color);
        g.drawLine(width - 1, 5, width - 1, height - 7);
        g.drawLine(2, height - 1, width - 3, height - 1);

        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    /**
     * Border instances may be reused, hence this method that always returns the
     * same instance
     */
    public static ShadowBorder getInstance()
    {
        return instance;
    }
}
