/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
/*
 * Created on Mar 8, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package butterfly.xmlview.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class SplashScreen extends JWindow {
	private static SplashScreen instance_;
	private JLabel progress_;
	
	
	private class Artwork{
		public String file;
		public String title;
		public String medium;
		public String artist;
		public String url;
		public String copyright;
		
		public Artwork(String file, String title, String medium, String artist,String url,String copy){
			this.file=file;
			this.title=title;
			this.medium=medium;
			this.artist=artist;
			this.url = url;
			copyright=copy;
		}
	}
	
	private Artwork[] artworks_ = new Artwork[]{
		new Artwork("icons/splash/red_storm_low_res.jpg","Approaching Storm","Oil and Acrylic on Paper","Jules White","http://www.americanartists.org","Copyright 2004 Jules White"),
		new Artwork("icons/splash/appreciating_utility_web.jpg","Appreciating Utility","Acrylic on Canvas","Jules White","http://www.americanartists.org","Copyright 2004 Jules White"),
		new Artwork("icons/splash/boston_newest.jpg","Night Clouds Over Boston","Acrylic and Ink on Canvas","Jules White","http://www.americanartists.org","Copyright 2004 Jules White")
			 
	};
	
	
	/**
	 * 
	 */
	public SplashScreen() {
		super();
		instance_=this;
		// TODO Auto-generated constructor stub
		setContentPane(new JPanel());
		getContentPane().setLayout(new GridBagLayout());
		getContentPane().setBackground(Color.WHITE);
		((JPanel)getContentPane()).setBorder(new LineBorder(Color.GRAY,2));
		GridBagConstraints cons = new GridBagConstraints();
		cons.gridx=0;
		cons.gridy=0;
		cons.fill = cons.BOTH;
		cons.weightx=1;
		cons.weighty=1;
		JPanel artwork = getArtwork();
		JLabel title = new JLabel(new ImageIcon("icons/splash/splash_title.jpg"));
		title.setOpaque(true);
		title.setBackground(Color.GRAY);
		title.setForeground(Color.BLACK);
		title.setFont(title.getFont().deriveFont(Font.BOLD).deriveFont((float)18));
		setSize(400,400);
		Dimension screen = getToolkit().getScreenSize();
		setLocation( (screen.width/2)-(getWidth()/2), (screen.height/2)-(getHeight()/2) );
		getContentPane().add(artwork,cons);
		cons.gridy=1;
		cons.weightx=1;
		cons.weighty=0;
		cons.fill=cons.HORIZONTAL;
		getContentPane().add(title,cons);
		
		progress_=new JLabel("Initializing...");
		progress_.setOpaque(true);
		progress_.setBackground(new Color(182,178,177));
		cons.gridy++;
		getContentPane().add(progress_,cons);
	//	setLocation(400,400);
		show();
	}
	
	
	public JPanel getArtwork(){
		Artwork art = curate();
		ImageIcon icon = new ImageIcon(art.file);
		if(icon.getIconWidth() > icon.getIconHeight()){
			icon.setImage(icon.getImage().getScaledInstance(400,-1,Image.SCALE_FAST));
		}
		else{
			icon.setImage(icon.getImage().getScaledInstance(-1,260,Image.SCALE_FAST));
		}
		if(icon.getIconHeight()>260){
			icon.setImage(icon.getImage().getScaledInstance(-1,260,Image.SCALE_FAST));
		}
		
		JLabel label = new JLabel(icon);
		JLabel info = new JLabel(art.title+" by "+art.artist+", "+art.medium);
		JLabel copy = new JLabel("Image "+art.copyright);
		copy.setHorizontalAlignment(JLabel.RIGHT);
		info.setHorizontalAlignment(JLabel.RIGHT);
		JLabel url = new JLabel(art.url);
		url.setHorizontalAlignment(JLabel.RIGHT);
		info.setFont(info.getFont().deriveFont((float)10));
		copy.setFont(copy.getFont().deriveFont((float)8));
		url.setFont(info.getFont());
		JPanel panel = new JPanel();
		panel.setLayout(new GridBagLayout());
		panel.setBackground(Color.WHITE);
		GridBagConstraints cons = new GridBagConstraints();
		cons.fill=cons.BOTH;
		cons.weightx=1;
		cons.weighty=1;
		JPanel pada = new JPanel();
		pada.setBackground(Color.WHITE);
		panel.add(pada,cons);
		
		cons.fill = cons.HORIZONTAL;
		cons.gridx = 0;
		cons.gridy = 1;
		cons.weightx=1;
		cons.weighty=0;
		cons.anchor=cons.NORTH;
	
		panel.add(label,cons);
		cons.weighty=0;
		cons.fill=cons.HORIZONTAL;
		cons.gridy=2;
		panel.add(info,cons);
		cons.gridy++;
		panel.add(url,cons);
		cons.gridy++;
		panel.add(copy,cons);
		cons.fill=cons.BOTH;
		cons.gridy++;
		cons.weightx=1;
		cons.weighty=1;
		JPanel padb = new JPanel();
		padb.setBackground(Color.WHITE);
		panel.add(padb,cons);
		return panel;		
	}
	
	public Artwork curate(){
		double rand = Math.random();
		int max = artworks_.length-1;
		int min = 0;
		int length = max-min;
		int choose = (int)Math.rint(max*rand)+min;
		return artworks_[choose];
	}

	/**
	 * @param owner
	 */
	public SplashScreen(Frame owner) {
		super(owner);
		// TODO Auto-generated constructor stub
		
	}

	/**
	 * @param gc
	 */
	public SplashScreen(GraphicsConfiguration gc) {
		super(gc);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param owner
	 */
	public SplashScreen(Window owner) {
		super(owner);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param owner
	 * @param gc
	 */
	public SplashScreen(Window owner, GraphicsConfiguration gc) {
		super(owner, gc);
		// TODO Auto-generated constructor stub
	}
	
	public static void ensureVisible(){
		if(instance_!=null){
			instance_.show();
		}
	}
	
	public static void progress(String msg){
		if(instance_!=null){
			instance_.setProgressMessage(msg);
		}
	}
	public void setProgressMessage(String msg){
		progress_.setText(msg);
	}

}
