/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class TabbedPaneUI extends BasicTabbedPaneUI {
	private static ImageIcon tabEdge_=new ImageIcon("icons/tabedge.gif");
	private static ImageIcon tabEdgeRight_=new ImageIcon("icons/tabedge-r3.gif");
	private static ImageIcon tabAreaRight_= new ImageIcon("icons/tab_area_right.gif");
	private static Color darkShadow_=new Color(241,243,243);
	private static Color selectedColor_=new Color(135,135,135);
	/**
	 * Constructor for TabbedPaneUI.
	 */
	public TabbedPaneUI() {
		super();
	}

	
	/**
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#paintTab(Graphics, int, Rectangle[], int, Rectangle, Rectangle)
	 */
	
	protected void paintTab(
		Graphics g,
		int tabPlacement,
		Rectangle[] rects,
		int tabIndex,
		Rectangle iconRect,
		Rectangle textRect) {
		//super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
		  Rectangle tabRect = rects[tabIndex];
        int selectedIndex = tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        boolean last = tabIndex==tabPane.getTabCount()-1;
        
        int cropx = 0;
        int cropy = 0;
//        if(isSelected){
//        g.setColor(((Color)UIManager.get("TabbedPane.selected")).brighter());
//        }
//        else{
        g.setColor(((Color)UIManager.get("TabbedPane.unselected")));	
//        }
		g.fillRect(tabRect.x,tabRect.y+1,tabRect.width-1,tabRect.height);
		g.setColor((Color)UIManager.get("TabbedPane.foreground"));
		if(isSelected){
			//g.drawRoundRect(tabRect.x,tabRect.y,tabRect.width,tabRect.height-1,4,4);
			g.setColor(darkShadow_);	
			//g.fillRect(tabRect.x,tabRect.y,10,tabRect.height);
			//g.fillRect(tabRect.x+1,tabRect.y-1,tabRect.width-10,tabRect.height-5);
			//g.setColor(Color.black);
			//g.drawRoundRect(tabRect.x,tabRect.y,tabRect.width-8,tabRect.height-1,5,5);
			//g.setColor(new Color(241,243,243));	
			//g.fillRoundRect(tabRect.x+1,tabRect.y,tabRect.width-9,tabRect.height-1,5,5);
			g.fillRect(tabRect.x,tabRect.y-4,tabRect.width+10,4);
			g.drawImage(tabEdge_.getImage(),tabRect.x-1,tabRect.y-2,tabPane);
			g.drawImage(tabEdgeRight_.getImage(),tabRect.x+tabRect.width-20,tabRect.y-2,tabPane);
			g.setColor(selectedColor_);
			if(tabIndex != tabPane.getTabCount()-1 && tabIndex !=0){
				g.drawLine(tabRect.x,tabRect.y+tabRect.height-1,tabRect.x+tabRect.width,tabRect.y+tabRect.height-1);
			}
			else if(tabIndex != 0){

				g.drawLine(tabRect.x+3,tabRect.y+tabRect.height-1,tabRect.x+tabRect.width-11,tabRect.y+tabRect.height-1);
		
			}
			else if(tabIndex==0){
				//g.fillRect(tabRect.x,tabRect.y,20,20);
				g.drawLine(tabRect.x+5,tabRect.y+tabRect.height-1,tabRect.x+tabRect.width,tabRect.y+tabRect.height-1);
			}
			//g.drawLine(tabRect.x,tabRect.y,tabRect.x,tabRect.y+tabRect.height);
			//g.drawLine(tabRect.x+tabRect.width,tabRect.y,tabRect.x+tabRect.width,tabRect.y+tabRect.height);
		}
		else if(tabIndex != selectedIndex-1)
		{
			g.setColor(selectedColor_);
			//g.drawLine(tabRect.x,tabRect.y,tabRect.x,tabRect.y+tabRect.height);
			g.drawLine(tabRect.x+tabRect.width-1,tabRect.y,tabRect.x+tabRect.width-1,tabRect.y+tabRect.height);
			//g.drawLine(tabRect.x+1,tabRect.y+tabRect.height-1,tabRect.x+tabRect.width-2,tabRect.y+tabRect.height-1);
		}
		if(!isSelected){
			g.setColor(selectedColor_);
			//g.drawLine(tabRect.x,tabRect.y,tabRect.x,tabRect.y+tabRect.height);
			g.drawLine(tabRect.x,tabRect.y+tabRect.height-1,tabRect.x+tabRect.width-1,tabRect.y+tabRect.height-1);
		}
		
		if(!isSelected && tabIndex==0){
			g.setColor(selectedColor_);
			//g.drawLine(tabRect.x,tabRect.y,tabRect.x,tabRect.y+tabRect.height);
			g.drawLine(tabRect.x,tabRect.y,tabRect.x,tabRect.y+tabRect.height-1);
		}
//	
//		else{
//			//g.drawLine(tabRect.x+tabRect.width,tabRect.y,tabRect.x+tabRect.width,tabRect.y+tabRect.height);
//			g.drawLine(tabRect.x,tabRect.y+4,tabRect.x,tabRect.y+tabRect.height-4);
//			g.setColor(Color.DARK_GRAY);
//			g.fillRoundRect(tabRect.x+tabRect.width,tabRect.y,5000,5000,40,40);
//			g.setColor((Color)UIManager.get("TabbedPane.unselected"));
//			g.fillRoundRect(tabRect.x+tabRect.width+1,tabRect.y+1,5000,5000,40,40);
//		}
        
        String title = tabPane.getTitleAt(tabIndex);
        Font font = tabPane.getFont();
//        if(isSelected){
//        	font = font.deriveFont(Font.BOLD)
//        }
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = getIconForTab(tabIndex);

        layoutLabel(tabPlacement, metrics, tabIndex, title, icon, 
                    tabRect, iconRect, textRect, isSelected);

        paintText(g, tabPlacement, font, metrics, 
                  tabIndex, title, textRect, isSelected);

        paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);

    
	}

	/**
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#getTabLabelShiftX(int, int, boolean)
	 */
	protected int getTabLabelShiftX(
		int tabPlacement,
		int tabIndex,
		boolean isSelected) {
		return 0;
	}

	/**
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#getTabLabelShiftY(int, int, boolean)
	 */
	protected int getTabLabelShiftY(
		int tabPlacement,
		int tabIndex,
		boolean isSelected) {
		return 0;
	}

	/**
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#paintTabArea(Graphics, int, int)
	 */
	protected void paintTabArea(
		Graphics g,
		int tabPlacement,
		int selectedIndex) {
		Rectangle b = g.getClipBounds();
		
		g.setColor(darkShadow_);
		//g.drawLine(b.x,b.y,b.x+b.width,b.y);
		//g.drawRoundRect(b.x+1,b.y,b.width-2,b.height-1,15,15);
		//g.setColor(((Color)UIManager.get("TabbedPane.unselected")));	
		g.fillRect(b.x,b.y,b.width,b.height);
		//g.drawLine(b.x,b.y+b.height,b.x+b.width,b.y+b.height);
		super.paintTabArea(g, tabPlacement, selectedIndex);
		g.setColor(selectedColor_);
		//g.drawImage(tabAreaRight_.getImage(),b.x+b.width-20,b.y,tabPane);
		
		//g.drawLine(b.x,b.y,b.x+b.width,b.y);
		//g.drawLine(b.x+8,b.y+b.height-1,b.x+b.width-5,b.y+b.height-1);
	}



	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#calculateTabWidth(int, int, java.awt.FontMetrics)
	 */
	protected int calculateTabWidth(int tabPlacement, int tabIndex,
			FontMetrics metrics) {
		// TODO Auto-generated method stub
		int width = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
		if(tabIndex == tabPane.getSelectedIndex()){
			width += 30;
		}
		return width;
	}
	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#getContentBorderInsets(int)
	 */
	protected Insets getContentBorderInsets(int tabPlacement) {
		// TODO Auto-generated method stub
		Insets ins = super.getContentBorderInsets(tabPlacement);
		ins.left = 3;
		ins.bottom = 5;
		return ins;
	}
	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#paintContentBorderBottomEdge(java.awt.Graphics, int, int, int, int, int, int)
	 */
	protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement,
			int selectedIndex, int x, int y, int w, int h) {
		// TODO Auto-generated method stub
//		super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x,
//				y, w, h);
		g.setColor(darkShadow_);
		g.fillRect(x,y,w,h-1);
		g.setColor(selectedColor_);
		g.fillRect(x,y+h-1,w,1);
		//int gap = getTabBounds(selectedIndex,)
	}
	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#paintContentBorder(java.awt.Graphics, int, int)
	 */
	
}
