/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.statemachine.StateListenerManager;
import butterfly.statemachine.interfaces.IStateEventListener;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.editors.interfaces.IEditor;
import butterfly.xmlview.gui.editors.interfaces.IEditorSite;
import butterfly.xmlview.gui.interfaces.INodeSelectionListener;
import butterfly.xmlview.gui.interfaces.IXmlEditor;
import butterfly.xmlview.gui.interfaces.IXmlRenderer;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/16/2002 11:22:19 AM)
 * @author: 
 */
public class TabbedXmlEditor extends MultiViewComponent implements IXmlEditor,IComponentRequester,IActionRequester,Composable,Configurable,IComponent,IStateEventListener,IStateEventSource,INodeSelectionListener,ChangeListener,IEditor{
	private String defaultRendererKey_;
	private IXmlDocument xmlModel_;
	private Hashtable renderers_ = new Hashtable(3);
	private Hashtable rendererKeys_ = new Hashtable(3);
	private IXmlRenderer currentRenderer_;
	private String currentRendererKey_;
	private static Logger logger_ = Logger.getLogger(TabbedXmlEditor.class);
	private Vector tabKeys_ = new Vector();
	private JTabbedPane tabbedPane_;
	private Component currentRendering_;
	private Vector renderersList_ = new Vector();
	private JPanel viewButtonPanel_;
	private ButtonGroup viewButtonGroup_;
	private Hashtable viewButtonLookup_ = new Hashtable(2);
	private StateListenerManager listenerManager_ = new StateListenerManager();

	
	private IActionLookup actionLookup_;
	private IComponentLookup componentLookup_;
	
	private ComponentSelector selector_;
	private ComponentManager componentManager_;
	private Hashtable openModels_ = new Hashtable(5);
	//private ElementDetailPane elementDetails_;
	
	public static final String TITLE_KEY = "title";
	public static final String ROLE_KEY = "role";
	public static final String RENDERERS_KEY = "renderers";
	public static final String DEFAULT_RENDERER_KEY = "default-renderer";
/**
 * XmlEditor constructor comment.
 */
public TabbedXmlEditor() {
	super();
	ButterflyApplication.setLookups(this);
	setLayoutManagerForLayer(INFO_LAYER,new GridBagLayout());
	//JInternalFrame f = new JInternalFrame();
	ClosablePanel panel = new ClosablePanel();
	GridBagConstraints cons = new GridBagConstraints(0,1,5,1,1,1,GridBagConstraints.NORTHEAST,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0);
	//JTextArea f = new JTextArea("Element: name\nNamespace:acfa:\"http://www.americanartists.org\"\nAttributes:first,last,middle\nContent Model:#CDATA\nDocumentation:Unavailable");
	//elementDetails_ = new ElementDetailPane();
	//ElementDetailPane f = elementDetails_;
	//f.setEditable(false);
	//panel.setOpaque(false);
	//f.setOpaque(false);
	//((JComponent)panel.getContentPane()).setOpaque(false);
	//f.setFont(new Font("Verdana",0,10));
	//f.setBorder(new EmptyBorder(0,0,0,0));
	//f.setSize(new Dimension(200,200));
	panel.getContentPane().setLayout(new GridBagLayout());
	//panel.getContentPane().add(f,cons);
	panel.setBorder(new LineBorder(Color.GRAY,1));
	//panel.setSize(300,300);
	cons.gridwidth = 1;
	cons.insets = new Insets(0,0,0,20);
	cons.weightx = 1.0;
	cons.weighty =1.0;
	cons.fill = cons.NONE;
	//add(panel,cons,INFO_LAYER);
}

public void updateElementDetails(INode[] nodes){
//	if(nodes == null){
//		nodes = getCurrentRenderer().getSelectedNodes();
//	}
//	if(nodes != null){
//		if(nodes.length > 0){
//		INodeStructure struct = ((IValidatedDocument)getDocument()).getValidationDocument().getNodeStructure(nodes[0]);
//		if(struct instanceof IElementStructure){
//			logger_.debug("displaying the structure for:"+nodes[0]);
//			elementDetails_.displayStructureFor(((IElementStructure)struct).getName(),((IElementStructure)struct).getNameSpace());	
//		}
//		}
//	}
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 9:32:40 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void addStateEventListener(butterfly.statemachine.interfaces.IStateEventListener l) {
	listenerManager_.addListener(l);	
}
/**
 * compose method comment.
 */
public void compose(ComponentManager arg1) throws ComponentException {
	componentManager_ = arg1;	
}
/**
 * configure method comment.
 */
public void configure(Configuration arg1) throws ConfigurationException {
//	setLayout(new GridBagLayout());
//	
//	viewButtonPanel_ = new JPanel();
//	viewButtonPanel_.setLayout(new BoxLayout(viewButtonPanel_,BoxLayout.X_AXIS));
//	GridBagConstraints cons = new GridBagConstraints();
//	cons.weightx = 1.0;
//	cons.weighty = 0;
//	cons.gridx = 0;
//	cons.gridy = 0;
//	add(viewButtonPanel_,cons);

	
    Configuration defaultrendchild = arg1.getChild(DEFAULT_RENDERER_KEY);
    String defaultrendererkey = null;
    if (defaultrendchild != null) {
        defaultrendererkey = defaultrendchild.getValue();
        setDefaultRendererKey(defaultrendererkey);
    }
    logger_.debug("Default renderer set to:" + defaultrendererkey);

    Configuration renderersparent = arg1.getChild(RENDERERS_KEY);
    logger_.debug("Configuring renderers...");
    if (renderersparent != null) {
	    logger_.debug("Listing renderers...");
        Configuration[] children = renderersparent.getChildren();
        if (children != null) {
	        logger_.debug("Loading renderers...");
	        try{
		  
            for (int i = 0; i < children.length; i++) {
				logger_.debug("Getting renderer information...");
                String role = children[i].getAttribute(ROLE_KEY);
                logger_.debug("Renderer role:"+role);
                String title = children[i].getAttribute(TITLE_KEY);
				logger_.debug("Loading renderer role:"+role+" title:"+title);
                try {
	                
                    IXmlRenderer renderer = (IXmlRenderer)componentManager_.lookup(role);
                    registerRenderer(title, renderer);
                } catch (Exception e) {
                    logger_.warn(
                        "Unable to load renderer for role: " + role + " title:" + title,
                        e);
                }

            }
	        } catch(Exception e){
	            logger_.warn("Exception occurred when retrieving a renderer's information.",e);
            }
        }
        else{
			logger_.debug("No renderers listed for XmlEditor");
        }
    }
    else{
		logger_.debug("No renderers listed for XmlEditor");
    }
	logger_.debug("XmlEditor configured.");
	
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/18/2002 12:31:41 PM)
 * @param rendering java.awt.Component
 */
public void displayRendering(Component view) {
//	if(currentRendering_ != null){
//		remove(currentRendering_);
//		
//	}
//	currentRendering_ = view;
//	view.setSize(getWidth(),getHeight());
//	//setLayout(new GridBagLayout());
//	GridBagConstraints lc = new GridBagConstraints();
//	lc.weightx = 1.0;
//	lc.weighty = 1.0;
//	lc.gridx= 0;
//	lc.gridy = 1;
//	lc.gridwidth = 10;
//	lc.gridheight = 20;
//	add(view,lc);
//
//	logger_.debug("width: "+getWidth()+" height:"+getHeight());
//
//	revalidate();	
}
/**
 * compose method comment.
 */
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 12:10:49 AM)
 * @param x int
 * @param y int
 */
public void dispose() {
		
	
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:42:40 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {
	getCurrentRenderer().focusOnNode(node);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:36:51 AM)
 * @return butterfly.actions.interfaces.IActionLookup
 */
public butterfly.actions.interfaces.IActionLookup getActionLookup() {
	return actionLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:36:51 AM)
 * @return butterfly.components.interfaces.IComponentLookup
 */
public butterfly.components.interfaces.IComponentLookup getComponentLookup() {
	return componentLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:33:00 AM)
 * @return butterfly.xmlview.gui.IXmlRenderer
 */
public IXmlRenderer getCurrentRenderer() {
	int index = getSelectedIndex();
	String title = getTitleAt(index);
	return (IXmlRenderer)renderers_.get(title);
//	if(currentRenderer_ == null){
//		currentRenderer_ = getRenderer(getDefaultRendererKey());
//	}
//	return currentRenderer_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:35:22 AM)
 * @return java.lang.String
 */
public String getCurrentRendererKey() {
	if(currentRendererKey_ == null){
		currentRendererKey_ = defaultRendererKey_;
	}
	return currentRendererKey_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/20/2002 12:00:46 PM)
 * @return java.awt.Component
 */
public Component getCurrentRendering() {
	return currentRendering_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:31:11 AM)
 * @return java.lang.String
 */
public String getDefaultRendererKey() {
	return defaultRendererKey_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:42:40 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getDocument() {
	return getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:42:40 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public IDocument getIDocument() {
	return getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:27:29 AM)
 * @return butterfly.xmlview.gui.IXmlRenderer
 * @param key java.lang.Object
 */
public IXmlRenderer getRenderer(Object key) {
	return (IXmlRenderer)renderers_.get(key);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:42:40 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public butterfly.xmlview.model.interfaces.INode[] getSelectedNodes() {
	return getCurrentRenderer().getSelectedNodes();
}
/**
 * Insert the method's description here.
 * Creation date: (10/17/2002 7:16:32 PM)
 * @return java.lang.String
 */
public java.lang.String getSelectedTag() {
	return getCurrentRenderer().getSelectedTag();
}
/**
 * Insert the method's description here.
 * Creation date: (10/17/2002 7:16:32 PM)
 * @return java.lang.String
 */
public java.lang.String getSelectedTagXPath() {
	return getCurrentRenderer().getSelectedTagXPath();
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:22:19 AM)
 * @return butterfly.xmlview.model.XmlDocument
 */
public IXmlDocument getXmlModel() {
	return xmlModel_;//getCurrentRenderer().getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 9:31:58 AM)
 * @param event butterfly.statemachine.interfaces.IStateEvent
 */
public void handleEvent(butterfly.statemachine.interfaces.IStateEvent event) {
	logger_.debug("XmlEditor is forwarding an event...");
	event.setSource(this);
	listenerManager_.fireEvent(event);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:42:40 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void loadDocument(butterfly.xmlview.model.interfaces.IDocument doc) {
	loadXmlModel((IXmlDocument)doc);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:22:19 AM)
 * @param root butterfly.xmlview.model.Node
 */
public void loadXmlModel(IXmlDocument root) {
	if(root.getElementStructures() != null){
		//elementDetails_.setElementStructure(root.getElementStructures());
	}
	else{
		//elementDetails_.setVisible(false);	
	}
//	Enumeration keys = renderers_.keys();
//	while(keys.hasMoreElements()){
//		Object key = keys.nextElement();
//		IXmlRenderer curr = (IXmlRenderer)renderers_.get(key);
//		addView(key.toString(),curr.renderXmlDocument(root));	
//	}
	Object key=null;
	IXmlRenderer curr = null;
	for(int i = 0; i < renderersList_.size(); i++){
		curr = (IXmlRenderer)renderersList_.elementAt(i);
		key = (Object)rendererKeys_.get(curr);
		addView(key.toString(),curr.renderXmlDocument(root));
	}
	/*
	 if (tabbedPane_ == null) {
		 
	    setLayout(new GridBagLayout());
        tabbedPane_ = new JTabbedPane();
        
		tabbedPane_.setMinimumSize(new Dimension(500,25));
		//tabbedPane_.setBackground(java.awt.Color.yellow);
        setLayout(new GridBagLayout());
        GridBagConstraints lc = new GridBagConstraints();
        lc.weightx = 1.0;
        lc.anchor = lc.WEST;
        lc.weighty = 0;
        lc.gridx = 0;
        lc.gridy = 0;
        lc.gridwidth = 1;
        lc.gridheight = 1;
        add(tabbedPane_, lc);

        tabbedPane_.addChangeListener(new ChangeListener(){
			public void stateChanged(javax.swing.event.ChangeEvent event){
				int index = tabbedPane_.getSelectedIndex();
				try{
					String key = (String)tabKeys_.elementAt(index);
					switchDocument(key);
				}catch(Exception e){}
			}
		}	
		);
		
    }
	 
	String key = null;
	if(root.getSourceFileName() == null){

	}
	else{
		File file = new File(root.getSourceFileName());
		key = file.getName();
		openModels_.put(file.getName(),root);
		openModels_.put(root,new Integer(tabbedPane_.getTabCount()));
		tabbedPane_.addTab(file.getName(),new JLabel(""));

	}
	switchDocument(key);
	//xmlModel_ = root;
	
*/
	xmlModel_ = root;
	
//	IXmlRenderer renderer = getCurrentRenderer();

//	Component view = renderer.renderXmlDocument(xmlModel_);
	//removeAll();
//	displayRendering(view);
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:25:05 AM)
 * @param key java.lang.Object
 * @param renderer butterfly.xmlview.gui.IXmlRenderer
 */
public void registerRenderer(Object key, IXmlRenderer renderer) {
    boolean setSelected = false;
    if (viewButtonGroup_ == null) {
        setSelected = true;
        viewButtonGroup_ = new ButtonGroup();
    }
    //  tabbedPane_.addTab(key.toString(), new JLabel(""));
    renderer.addNodeSelectionListener(this);
    renderers_.put(key, renderer);
    rendererKeys_.put(renderer,key);
    renderersList_.add(renderer);
    //  tabKeys_.add(key);
    //addView(key.toString(),renderer.renderXmlDocument(getXmlModel()));

 //   JRadioButton button = new JRadioButton(key.toString(), false);
//    viewButtonGroup_.add(button);
//    viewButtonPanel_.add(button);
//    button.addItemListener(new ItemListener() {
//        public void itemStateChanged(ItemEvent e) {
//            if (e.getStateChange() == ItemEvent.SELECTED) {
//                switchRenderer(((JRadioButton) e.getSource()).getText());
//            }
//        }
//    });
//    viewButtonLookup_.put(key.toString(), button);
//    button.setSelected(setSelected);

	if(renderer != null && renderer instanceof IStateEventSource){
		((IStateEventSource)renderer).addStateEventListener(this);
	}
	if(renderer != null && renderer instanceof IComponentRequester){
		logger_.debug("set the renderer's component lookup");
		((IComponentRequester)renderer).setComponentLookup(getComponentLookup());
	}
	if(renderer != null && renderer instanceof IActionRequester){
		((IActionRequester)renderer).setActionLookup(getActionLookup());
	}

    
    logger_.debug("Registered renderer:" + renderer + " with key:" + key);

}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 9:32:40 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void removeStateEventListener(IStateEventListener l) {
	listenerManager_.removeListener(l);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:36:44 AM)
 */
public void requestActions() {}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:36:44 AM)
 */
public void requestComponents() {}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:36:51 AM)
 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup newActionLookup) {
	actionLookup_ = newActionLookup;
	if(renderers_ != null){
		Enumeration keys = renderers_.keys();
		while(keys.hasMoreElements()){
			Object val = renderers_.get(keys.nextElement());
			if(val instanceof IActionRequester){
				logger_.debug("setting the action lookup for "+val);
				((IActionRequester)val).setActionLookup(actionLookup_);
			}
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:36:51 AM)
 * @param newComponentLookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(butterfly.components.interfaces.IComponentLookup newComponentLookup) {
	componentLookup_ = newComponentLookup;
	if(renderers_ != null){
		Enumeration keys = renderers_.keys();
		while(keys.hasMoreElements()){
			Object val = renderers_.get(keys.nextElement());
			if(val instanceof IComponentRequester){
				logger_.debug("setting the component lookup for "+val);
				((IComponentRequester)val).setComponentLookup(componentLookup_);
			}
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:33:00 AM)
 * @param newCurrentRenderer butterfly.xmlview.gui.IXmlRenderer
 */
public void setCurrentRenderer(IXmlRenderer newCurrentRenderer) {
	currentRenderer_ = newCurrentRenderer;
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:31:11 AM)
 * @param newDefaultRenderer java.lang.String
 */
public void setDefaultRendererKey(String newDefaultRenderer) {
	defaultRendererKey_ = newDefaultRenderer;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:35:24 AM)
 * @param start int
 */
public void setSelectionEnd(int end) {
	getCurrentRenderer().setSelectionEnd(end);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:35:24 AM)
 * @param start int
 */
public void setSelectionStart(int start) {
	getCurrentRenderer().setSelectionStart(start);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:27:00 AM)
 * @param key java.lang.String
 */
public void switchDocument(String key) {
	/*
	xmlModel_ = (IXmlDocument)openModels_.get(key);
	if(xmlModel_ == null){
		logger_.warn("There is no xml model registered under the key:"+key);
	}
	Integer index = (Integer)openModels_.get(xmlModel_);
	
	tabbedPane_.setSelectedIndex(index.intValue());
	
	IXmlRenderer renderer = getCurrentRenderer();

	Component view = renderer.renderXmlDocument(xmlModel_);
	//removeAll();
	displayRendering(view);
	//view.setSize(getWidth(),getHeight());
	
	//view.setVisible(true);
	*/
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:27:00 AM)
 * @param key java.lang.String
 */
public void switchRenderer(String key) {
//	if(currentRenderer_ != null){
//		xmlModel_ = currentRenderer_.getXmlModel();
//	}
//	if(xmlModel_ == null){
//		return;
//	}
//	currentRendererKey_ = key;
	setSelectedView(key);
//	currentRenderer_ = renderer;
//	Component view = renderer.renderXmlDocument(xmlModel_);
//	//removeAll();
//	displayRendering(view);
//	((AbstractButton)viewButtonLookup_.get(key)).setSelected(true);
	//view.setSize(getWidth(),getHeight());
	
	//view.setVisible(true);
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:25:05 AM)
 * @param key java.lang.Object
 * @param renderer butterfly.xmlview.gui.IXmlRenderer
 */
public void unRegisterRenderer(Object key) {
//	IXmlRenderer rend = getRenderer(key);
//	if(rend != null && rend instanceof IStateEventSource){
//		((IStateEventSource)rend).removeStateEventListener(this);
//	}
//	renderers_.remove(key);
//	tabKeys_.remove(key);
}
	/**
	 * @see butterfly.xmlview.gui.interfaces.INodeSelectionListener#selectedNodesChanged(INode[])
	 */
	public void selectedNodesChanged(INode[] sel) {
		logger_.debug("updating element details");
		updateElementDetails(sel);
	}

	/**
	 * @see javax.swing.event.ChangeListener#stateChanged(ChangeEvent)
	 */
	public void stateChanged(ChangeEvent e) {
		
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		getCurrentRenderer().setSelection(start,length);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.editors.interfaces.IEditor#setEditorSite(butterfly.xmlview.gui.editors.interfaces.IEditorSite)
	 */
	public void setEditorSite(IEditorSite site) {
		// TODO Auto-generated method stub
		//site.getMenuBar().createMenu("XML");
	}

}
