/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer;
import butterfly.xmlview.model.interfaces.IElement;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class TreeGridUI extends BasicTreeUI {
	
	   /**
     * TreeMouseListener is responsible for updating the selection
     * based on mouse events.
     */
    public class MouseHandler extends MouseAdapter implements MouseMotionListener
 {
	/**
	 * Invoked when a mouse button has been pressed on a component.
	 */
	public void mousePressed(MouseEvent e) {
		if(getCellRenderer() instanceof IInteractiveTreeCellRenderer){
			TreePath path = getClosestPathForLocation(tree, e.getX(),e.getY());

			Rectangle bounds=null;
			if(path != null) {
				bounds = getPathBounds(tree, path);
			}
			if(e.getY() <= (bounds.y + bounds.height)) {
				
				int boxWidth=0;
				if(getExpandedIcon() != null){
					boxWidth = getExpandedIcon().getIconWidth();
				}
				else{
					boxWidth = 8;
				}
				if(e.getX() >= (bounds.x+boxWidth)){
					
					
					MouseEvent me = new MouseEvent((Component)e.getSource(),e.getID(),e.getWhen(),e.getModifiers(),e.getX()-(bounds.x),e.getY()-bounds.y,e.getClickCount(),e.isPopupTrigger(),e.getButton());
					TreeNode node = (TreeNode)path.getLastPathComponent();
					//((IInteractiveTreeCellRenderer)getCellRenderer()).focusGained(tree,node);
					((IInteractiveTreeCellRenderer)getCellRenderer()).mousePressed(tree,node,me,tree.getLocationOnScreen().x+bounds.x,tree.getLocationOnScreen().y+bounds.y);
				}
			}
		}
	    if (! e.isConsumed()) {
		handleSelection(e);
		selectedOnPress = true;
	    } else {
		selectedOnPress = false;
	    }
	}

        void handleSelection(MouseEvent e) {
        	
	    if(tree != null && tree.isEnabled()) {
                if (isEditing(tree) && tree.getInvokesStopCellEditing() 
                                       ) {
                    return;
                }
				if(isEditing(tree)){
					completeEditing(true,false,true)	;
				}
                if (tree.isRequestFocusEnabled()) {
		    tree.requestFocus();
                }
		TreePath     path = getClosestPathForLocation(tree, e.getX(),
							      e.getY());

		if(path != null) {
		    Rectangle       bounds = getPathBounds(tree, path);

		    if(e.getY() > (bounds.y + bounds.height)) {
			return;
		    }

		  
		    if(SwingUtilities.isLeftMouseButton(e))
			checkForClickInExpandControl(path, e.getX(), e.getY());
		    
		    int x = e.getX();
		    
		 
		    if (x > bounds.x) {
			if (x <= (bounds.x + bounds.width) && 
			    !startEditing(path, e)) {
			    selectPathForEvent(path, e);
			}
		    }
		   
		}
	    }
	}

        public void mouseDragged(MouseEvent e) {
	}

        /**
	 * Invoked when the mouse button has been moved on a component
	 * (with no buttons no down).
	 */
        public void mouseMoved(MouseEvent e) {
	}

        public void mouseReleased(MouseEvent e) {
        	if(getCellRenderer() instanceof IInteractiveTreeCellRenderer){
        		TreePath path = getClosestPathForLocation(tree, e.getX(),e.getY());

        		Rectangle bounds=null;
        		if(path != null) {
        			bounds = getPathBounds(tree, path);
        		}
        		if(e.getY() <= (bounds.y + bounds.height)) {
        			
        			int boxWidth=0;
        			if(getExpandedIcon() != null)
        				boxWidth = getExpandedIcon().getIconWidth();
        			else
        				boxWidth = 8;
        			if(e.getX() >= (bounds.x+boxWidth)){
        				
        				
        				MouseEvent me = new MouseEvent((Component)e.getSource(),e.getID(),e.getWhen(),e.getModifiers(),e.getX()-(bounds.x),e.getY()-bounds.y,e.getClickCount(),e.isPopupTrigger(),e.getButton());
        				TreeNode node = (TreeNode)path.getLastPathComponent();
        				((IInteractiveTreeCellRenderer)getCellRenderer()).mouseReleased(tree,node,me,tree.getLocationOnScreen().x+bounds.x,tree.getLocationOnScreen().y+bounds.y);
        			}
        		}
        	}
	    if ((! e.isConsumed()) && (! selectedOnPress)) {
		handleSelection(e);
	    }
        }

        boolean selectedOnPress;
    } 


	private static final ImageIcon expanded = new ImageIcon("icons/treeex.gif");
	private static final ImageIcon collapsed = new ImageIcon("icons/treecol.gif");
	/**
	 * Constructor for TreeGridUI.
	 */
	public TreeGridUI() {
		super();
		
	}

	/**
	 * @see javax.swing.plaf.basic.BasicTreeUI#paintHorizontalPartOfLeg(Graphics, Rectangle, Insets, Rectangle, TreePath, int, boolean, boolean, boolean)
	 */
	
	protected int getVisibleDescendantCount(JTree tree,TreePath path,int row){
		Object last = path.getLastPathComponent();
		if(last instanceof TreeNode){
			return getVisibleDescendantCount(tree,(TreeNode)last,row);
		}
		return 0;	
	}
	
	protected int getVisibleDescendantCount(JTree tree,TreeNode node,int row){
			int count = 0;
			if(tree.isExpanded(row)){
			for(int i = 0; i < node.getChildCount(); i++){
				row++;
				int subcount = 0;
				if(tree.isExpanded(row)){
					subcount += getVisibleDescendantCount(tree,node.getChildAt(i),row);
				}
				row+=subcount;
				count+= subcount+1;

			}
			}
			return count;
	}
	
	
	protected void paintHorizontalPartOfLeg(
		Graphics g,
		Rectangle clipBounds,
		Insets insets,
		Rectangle bounds,
		TreePath path,
		int row,
		boolean isExpanded,
		boolean hasBeenExpanded,
		boolean isLeaf) {
		
//		int count = getVisibleDescendantCount(tree,path,row);
////		super.paintHorizontalPartOfLeg(
////			g,
////			clipBounds,
////			insets,
////			bounds,
////			path,
////			row,
////			isExpanded,
////			hasBeenExpanded,
////			isLeaf);
//		g.setColor(Color.BLACK);
//		bounds = tree.getPathBounds(path);
//		//System.out.println("count:"+count);
		if(isElement(path)){
		g.setColor(new Color(200,200,255));
		g.fillRoundRect(bounds.x,bounds.y+2,tree.getWidth()-bounds.x-(2*path.getPathCount()),bounds.height-2,5,5);
		//g.fillRect(bounds.x,bounds.y+2,tree.getWidth()-bounds.x-(2*path.getPathCount()),bounds.height-2);
		}
//		
//		g.setColor(Color.GRAY);
//		g.drawRect(bounds.x,bounds.y+2,tree.getWidth()-bounds.x-(2*path.getPathCount()),((count+1)*bounds.height)-2);
	}
	
	

	protected boolean isElement(TreePath path){
		Object last = path.getLastPathComponent();
		if(last instanceof DefaultMutableTreeNode){
			return ((DefaultMutableTreeNode)last).getUserObject() instanceof IElement;
		}
		if(last instanceof IElement){
			return true;
		}
		return false;
	}

	/**
	 * @see javax.swing.plaf.basic.BasicTreeUI#paintVerticalPartOfLeg(Graphics, Rectangle, Insets, TreePath)
	 */
	protected void paintVerticalPartOfLeg(
		Graphics g,
		Rectangle clipBounds,
		Insets insets,
		TreePath path) {
		int row = tree.getRowForPath(path);
		int count = getVisibleDescendantCount(tree,path,row);
//		super.paintHorizontalPartOfLeg(
//			g,
//			clipBounds,
//			insets,
//			bounds,
//			path,
//			row,
//			isExpanded,
//			hasBeenExpanded,
//			isLeaf);
		g.setColor(Color.BLACK);
		Rectangle bounds = tree.getPathBounds(path);
		//System.out.println("count:"+count);
		if(isElement(path)){
		//Graphics copy = g.copyArea(0,0)
		g.setColor(Color.LIGHT_GRAY);
		//g.
		//g.fillRect(bounds.x,bounds.y+2,tree.getWidth()-bounds.x-(2*path.getPathCount()),bounds.height-2);
		}
		
		g.setColor(Color.GRAY);
		//g.drawRect(bounds.x,bounds.y+2,tree.getWidth()-bounds.x-(2*path.getPathCount()),((count+1)*bounds.height)-2);
	
	}

	/**
	 * @see javax.swing.plaf.basic.BasicTreeUI#paintRow(Graphics, Rectangle, Insets, Rectangle, TreePath, int, boolean, boolean, boolean)
	 */
//	protected void paintRow(
//		Graphics g,
//		Rectangle clipBounds,
//		Insets insets,
//		Rectangle bounds,
//		TreePath path,
//		int row,
//		boolean isExpanded,
//		boolean hasBeenExpanded,
//		boolean isLeaf) {
//		if(editingComponent != null && editingRow == row)
//	    return;
//
//	int leadIndex;
//
//	if(tree.hasFocus()) {
//	    leadIndex = tree.getLeadSelectionRow();
//	}
//	else
//	    leadIndex = -1;
//
//	
//	Component component = currentCellRenderer.getTreeCellRendererComponent
//	              (tree, path.getLastPathComponent(),
//		       tree.isRowSelected(row), isExpanded, isLeaf, row,
//		       (leadIndex == row));
//	
//	rendererPane.paintComponent(g, component, tree, bounds.x, bounds.y,
//				    bounds.width, bounds.height, true);	
//			    
//	}

	/**
	 * @see javax.swing.plaf.basic.BasicTreeUI#createMouseListener()
	 */
	protected MouseListener createMouseListener() {
		return new MouseHandler();
	}
	protected void paintExpandControl(Graphics g, Rectangle clipBounds,
    Insets insets, Rectangle bounds, TreePath path, int row,
    boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf)
  {
    if (isExpanded)
    {
      g.drawImage(expanded.getImage(), bounds.x - 17, bounds.y + 4, null);
    }
    else
    {
      g.drawImage(collapsed.getImage(), bounds.x - 17, bounds.y + 4, null);
    }
  }

	
	
	

}
