/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

/**
 * @author Administrator
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class TreeTest extends JTree {

	/**
	 * Constructor for TreeTest.
	 */
	public TreeTest() {
		super();
		setUI(new HorizontalTreeUI());
		DefaultMutableTreeNode root = new DefaultMutableTreeNode("a");
		DefaultMutableTreeNode c = new DefaultMutableTreeNode("c");
		root.add(c);
		root.add(new DefaultMutableTreeNode("e"));
		root.add(new DefaultMutableTreeNode("f"));
		root.add(new DefaultMutableTreeNode("g"));
		c.add(new DefaultMutableTreeNode("d"));
		c.add(new DefaultMutableTreeNode("d"));
		DefaultMutableTreeNode d = new DefaultMutableTreeNode("d");
		c.add(d);
		d.add(new DefaultMutableTreeNode("q"));
		
		DefaultTreeModel model = new DefaultTreeModel(root);
		setModel(model);
		model.insertNodeInto(root,new DefaultMutableTreeNode("b"),0);
	}

	/**
	 * Constructor for TreeTest.
	 * @param value
	 */
	public TreeTest(Object[] value) {
		super(value);
	}

	/**
	 * Constructor for TreeTest.
	 * @param value
	 */
	public TreeTest(Vector value) {
		super(value);
	}

	/**
	 * Constructor for TreeTest.
	 * @param value
	 */
	public TreeTest(Hashtable value) {
		super(value);
	}

	/**
	 * Constructor for TreeTest.
	 * @param root
	 */
	public TreeTest(TreeNode root) {
		super(root);
	}

	/**
	 * Constructor for TreeTest.
	 * @param root
	 * @param asksAllowsChildren
	 */
	public TreeTest(TreeNode root, boolean asksAllowsChildren) {
		super(root, asksAllowsChildren);
	}

	/**
	 * Constructor for TreeTest.
	 * @param newModel
	 */
	public TreeTest(TreeModel newModel) {
		super(newModel);
	}
	
	public static void main(String[] args){
		TreeTest tt = new TreeTest();
		JFrame f = new JFrame();
		f.setContentPane(tt);
		f.setSize(300,300);
		f.show();	
	}

}
