/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.statemachine.interfaces.IStateEvent;
import butterfly.statemachine.interfaces.IStateEventListener;
import butterfly.xmlview.gui.tree.DocumentTree;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditor;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditorLookup;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class TreeView extends JPanel implements IDocumentTree,IComponentRequester,IActionRequester{
	private DocumentTree tree_;
	private IDocument document_;
	private JToolBar toolBar_;
	
	private static ImageIcon exicon_ = new ImageIcon("icons/stock_next-16.png");
	private static ImageIcon clicon_ = new ImageIcon("icons/stock_previous-16.png");
	private static ImageIcon ricon_ = new ImageIcon("icons/stock_repeat-16.png");
	
	class ExpandAction extends AbstractAction{
		
		public ExpandAction(){
			putValue(this.LONG_DESCRIPTION,"Expand the tree one level");
			putValue(this.NAME,"Expand One Level");
			putValue(this.SMALL_ICON,exicon_);	
			
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			expandLevel();
		}

	}
	
	class RefreshAction extends AbstractAction{
		
		public RefreshAction(){
			putValue(this.LONG_DESCRIPTION,"Refresh");
			putValue(this.NAME,"Refresh");
			putValue(this.SMALL_ICON,ricon_);	
			
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			//tree_.loadDocument(getdo)
			tree_.removeAll();
			loadDocument(document_);
			tree_.repaint();
		}

	}
	
	class CloseAction extends AbstractAction{
		
		public CloseAction(){
			putValue(this.LONG_DESCRIPTION,"Collapse the tree one level");
			putValue(this.NAME,"Collapse One Level");
			putValue(this.SMALL_ICON,clicon_);	
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			collapseLevel();
		}

	}
	/**
	 * Constructor for TreeView.
	 * @param tnode
	 */
	public TreeView(DefaultTreeModel tnode) {
		setLayout(new BorderLayout());
		//GridBagConstraints cons = new GridBagConstraints(0,0,1,1,1.0,0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0);
		
		toolBar_ = new JToolBar();
		tree_ = new DocumentTree(tnode);
		
		add(toolBar_,BorderLayout.NORTH);
		add(new JScrollPane(tree_),BorderLayout.CENTER);
		
		initToolBar();
	}

	protected void initToolBar(){
		getToolBar().add(new RefreshAction()).setToolTipText("Refresh");
		getToolBar().add(new CloseAction()).setToolTipText("Collapse the tree one level");
		getToolBar().add(new ExpandAction()).setToolTipText("Expand the tree one level");
	}
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#addNode(DefaultMutableTreeNode, Object, int)
	 */
	public void addNode(DefaultMutableTreeNode node, Object value, int index) {
		tree_.addNode(node, value, index);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#addNode(DefaultMutableTreeNode, Object)
	 */
	public void addNode(DefaultMutableTreeNode node, Object value) {
		tree_.addNode(node, value);
	}

	/**
	 * @see butterfly.statemachine.interfaces.IStateEventSource#addStateEventListener(IStateEventListener)
	 */
	public void addStateEventListener(IStateEventListener l) {
		tree_.addStateEventListener(l);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#ensureVisible(Object)
	 */
	public void ensureVisible(Object key) {
		tree_.ensureVisible(key);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#expand(DefaultMutableTreeNode)
	 */
	public void expand(DefaultMutableTreeNode node) {
		tree_.expand(node);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#expandAll(JTree, boolean)
	 */
	public void expandAll(JTree tree, boolean expand) {
		tree_.expandAll(tree, expand);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#expandChildren(DefaultMutableTreeNode, int)
	 */
	public void expandChildren(DefaultMutableTreeNode curr, int levels) {
		tree_.expandChildren(curr, levels);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#expandColumn(int)
	 */
	public void expandColumn(int col) {
		tree_.expandColumn(col);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#expandSavedPaths()
	 */
	public void expandSavedPaths() {
		tree_.expandSavedPaths();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#fireStateEvent(IStateEvent)
	 */
	public void fireStateEvent(IStateEvent evt) {
		tree_.fireStateEvent(evt);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#getActionLookup()
	 */
	public IActionLookup getActionLookup() {
		return tree_.getActionLookup();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#getActiveTreeEditor()
	 */
	public ITreeEditor getActiveTreeEditor() {
		return tree_.getActiveTreeEditor();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#getComponentLookup()
	 */
	public IComponentLookup getComponentLookup() {
		return tree_.getComponentLookup();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#getExpandedPaths()
	 */
	public TreePath[] getExpandedPaths() {
		return tree_.getExpandedPaths();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#getExpandedPaths(DefaultMutableTreeNode, Vector)
	 */
	public void getExpandedPaths(DefaultMutableTreeNode curr, Vector paths) {
		tree_.getExpandedPaths(curr, paths);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getSelectedNode()
	 */
	public DefaultMutableTreeNode getSelectedNode() {
		return tree_.getSelectedNode();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getSelectedTreeNodes()
	 */
	public DefaultMutableTreeNode[] getSelectedTreeNodes() {
		return tree_.getSelectedTreeNodes();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getTreeEditor(Object)
	 */
	public ITreeEditor getTreeEditor(Object node) {
		return tree_.getTreeEditor(node);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#getTreeEditorLookup()
	 */
	public ITreeEditorLookup getTreeEditorLookup() {
		return tree_.getTreeEditorLookup();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getTreeModel()
	 */
	public DefaultTreeModel getTreeModel() {
		return tree_.getTreeModel();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getTreeNode(Object)
	 */
	public DefaultMutableTreeNode getTreeNode(Object node) {
		return tree_.getTreeNode(node);
	}

	/**
	 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(IDocumentEvent)
	 */
	public void handleDocumentEvent(IDocumentEvent evt) {
		tree_.handleDocumentEvent(evt);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#isEditable(Object)
	 */
	public boolean isEditable(Object value) {
		return tree_.isEditable(value);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#loadDocument(IDocument, boolean)
	 */
	public void loadDocument(IDocument doc, boolean showroot) {
		tree_.loadDocument(doc, showroot);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#loadDocument(IDocument)
	 */
	public void loadDocument(IDocument doc) {
		document_ = doc;
		
		tree_.loadDocument(doc);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#makeTableTree()
	 */
	public void makeTableTree() {
		tree_.makeTableTree();
	}

	/**
	 * @see java.awt.event.MouseListener#mouseClicked(MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
		tree_.mouseClicked(e);
	}

	/**
	 * @see java.awt.event.MouseListener#mouseEntered(MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {
		tree_.mouseEntered(e);
	}

	/**
	 * @see java.awt.event.MouseListener#mouseExited(MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {
		tree_.mouseExited(e);
	}

	/**
	 * @see java.awt.event.MouseListener#mousePressed(MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		tree_.mousePressed(e);
	}

	/**
	 * @see java.awt.event.MouseListener#mouseReleased(MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
		tree_.mouseReleased(e);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.DocumentTree#nodeEdited(Object, Object)
	 */
	public Object nodeEdited(Object node, Object nval) {
		return tree_.nodeEdited(node, nval);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#registerNode(Object, DefaultMutableTreeNode)
	 */
	public void registerNode(Object node, DefaultMutableTreeNode tnode) {
		tree_.registerNode(node, tnode);
	}

	/**
	 * @see butterfly.statemachine.interfaces.IStateEventSource#removeStateEventListener(IStateEventListener)
	 */
	public void removeStateEventListener(IStateEventListener l) {
		tree_.removeStateEventListener(l);
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#requestActions()
	 */
	public void requestActions() {
		tree_.requestActions();
	}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#requestComponents()
	 */
	public void requestComponents() {
		tree_.requestComponents();
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#saveExpandedPaths()
	 */
	public void saveExpandedPaths() {
		tree_.saveExpandedPaths();
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#setActionLookup(IActionLookup)
	 */
	public void setActionLookup(IActionLookup lookup) {
		tree_.setActionLookup(lookup);
	}

	/**
	 * @see butterfly.components.interfaces.IComponentRequester#setComponentLookup(IComponentLookup)
	 */
	public void setComponentLookup(IComponentLookup lookup) {
		tree_.setComponentLookup(lookup);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#setTreeEditorLookup(ITreeEditorLookup)
	 */
	public void setTreeEditorLookup(ITreeEditorLookup l) {
		tree_.setTreeEditorLookup(l);
	}

	/**
	 * @see javax.swing.event.TreeExpansionListener#treeCollapsed(TreeExpansionEvent)
	 */
	public void treeCollapsed(TreeExpansionEvent event) {
		tree_.treeCollapsed(event);
	}

	/**
	 * @see javax.swing.event.TreeExpansionListener#treeExpanded(TreeExpansionEvent)
	 */
	public void treeExpanded(TreeExpansionEvent event) {
		tree_.treeExpanded(event);
	}

	/**
	 * @see javax.swing.event.TreeModelListener#treeNodesChanged(TreeModelEvent)
	 */
	public void treeNodesChanged(TreeModelEvent e) {
		tree_.treeNodesChanged(e);
	}

	/**
	 * @see javax.swing.event.TreeModelListener#treeNodesInserted(TreeModelEvent)
	 */
	public void treeNodesInserted(TreeModelEvent e) {
		tree_.treeNodesInserted(e);
	}

	/**
	 * @see javax.swing.event.TreeModelListener#treeNodesRemoved(TreeModelEvent)
	 */
	public void treeNodesRemoved(TreeModelEvent e) {
		tree_.treeNodesRemoved(e);
	}

	/**
	 * @see javax.swing.event.TreeModelListener#treeStructureChanged(TreeModelEvent)
	 */
	public void treeStructureChanged(TreeModelEvent e) {
		tree_.treeStructureChanged(e);
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#unRegisterNode(Object)
	 */
	public void unRegisterNode(Object node) {
		tree_.unRegisterNode(node);
	}

	/**
	 * @see javax.swing.event.TreeSelectionListener#valueChanged(TreeSelectionEvent)
	 */
	public void valueChanged(TreeSelectionEvent e) {
		tree_.valueChanged(e);
	}

	/**
	 * Returns the tree.
	 * @return DocumentTree
	 */
	public DocumentTree getTree() {
		return tree_;
	}

	/**
	 * Sets the tree.
	 * @param tree The tree to set
	 */
	public void setTree(DocumentTree tree) {
		tree_ = tree;
	}

	/**
	 * Returns the toolBar.
	 * @return JToolBar
	 */
	public JToolBar getToolBar() {
		return toolBar_;
	}

	/**
	 * Sets the toolBar.
	 * @param toolBar The toolBar to set
	 */
	public void setToolBar(JToolBar toolBar) {
		toolBar_ = toolBar;
	}

	public void collapseLevel(){
		tree_.collapseLevel((DefaultMutableTreeNode)tree_.getModel().getRoot());	
	}
	public void expandLevel(){
		tree_.expandLevel((DefaultMutableTreeNode)tree_.getModel().getRoot());	
	}
}
