/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import org.xml.sax.SAXParseException;

import butterfly.components.interfaces.IComponent;
import butterfly.xmlview.gui.interfaces.IValidationPane;
import butterfly.xmlview.model.validation.XmlValidationError;
import butterfly.xmlview.model.validation.interfaces.IValidationError;
/**
 * Insert the type's description here.
 * Creation date: (8/31/2002 3:43:14 PM)
 * @author: 
 */
public class ValidationPane extends javax.swing.JPanel implements IValidationPane,IComponent{
	private JButton nextErrorButton_ = new JButton("NextError>>");
	private JButton prevErrorButton_ = new JButton("<<PreviousError");
	//JButton validate = new JButton("Validate");

	private JLabel validationErrorsLabel_ = new JLabel("Validation Error:");
	private JLabel errorCountLabel_ = new JLabel("");
	private int totalErrors_ = 0;
	private int currentErrorNumberLabel_ = 0;
	private JTextPane errorMsgTextArea_ = new JTextPane();

	private IValidationError[] validationErrors_;
	private int currentError_ = 0;
	
/**
 * ValidationPane constructor comment.
 */
public ValidationPane() {
	super();
	init();
}
/**
 * Insert the method's description here.
 * Creation date: (8/31/2002 3:46:12 PM)
 */
public void checkState() {
	
	if(validationErrors_ == null){
		prevErrorButton_.setEnabled(false);
		nextErrorButton_.setEnabled(false);
		errorMsgTextArea_.setEnabled(false);
		errorMsgTextArea_.setText("<b>No validation errors.</b>");
		validationErrorsLabel_.setText("No validation errors.");
		//errorMsgTextArea_.setText("No validation errors");
	
		return;
	}
	if(validationErrors_.length < 1){
		prevErrorButton_.setEnabled(false);
		nextErrorButton_.setEnabled(false);
		errorMsgTextArea_.setEnabled(false);
		errorMsgTextArea_.setText("<b>No validation errors.</b>");
		validationErrorsLabel_.setText("No validation errors.");
		return;
	}

	if(currentError_ > 0){
		prevErrorButton_.setEnabled(true);
	}
	else{
		prevErrorButton_.setEnabled(false);
	}
	if(currentError_ < (validationErrors_.length - 1)){
		nextErrorButton_.setEnabled(true);
	}
	else{
		nextErrorButton_.setEnabled(false);
	}
	errorMsgTextArea_.setEnabled(true);
	//errorMsgTextArea_.setEditable(false);
	
	IValidationError exception = validationErrors_[currentError_];
	String msg = new String(exception.getMessage());
	while(msg.indexOf("<") > -1){
		int start = msg.indexOf("<");
		msg = msg.substring(0,start) +"&lt;"+msg.substring(start + 1);
	}
	while(msg.indexOf(">") > -1){
		int start = msg.indexOf(">");
		msg = msg.substring(0,start) +"&gt;"+msg.substring(start + 1);
	}
	String vmsg = "<b>Validation Error:</b>\n <p>Line:    " + 
							  exception.getLineNumber() + "</p>\n" +
						   "  <p>URI:     " + 
							  exception.getSystemId() + "</p>\n" +
						   "  <p>Message: " + 
							 msg+"</p>";  
	validationErrorsLabel_.setText("Validation Error "+(currentError_ + 1)+" of "+totalErrors_);
	errorMsgTextArea_.setText(vmsg);//validationErrors_[currentError_].getMessage());
	
}
/**
 * Insert the method's description here.
 * Creation date: (9/2/2002 10:39:53 AM)
 * @return butterfly.xmlview.model.validation.interfaces.IValidationError[]
 */
public butterfly.xmlview.model.validation.interfaces.IValidationError[] getValidationErrors() {
	return validationErrors_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/31/2002 3:46:12 PM)
 */
public void init() {
	setLayout(new GridBagLayout());

	//errorMsgTextArea_.setMinimumSize(new Dimension(400,400));
	//errorMsgTextArea_.setPreferredSize(new Dimension(400,400));
	//errorMsgTextArea_.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.black));
	//errorMsgTextArea_.setBackground(java.awt.Color.blue);
	errorMsgTextArea_.setEditable(false);
	errorMsgTextArea_.setAutoscrolls(true);
	errorMsgTextArea_.setContentType("text/html");
	errorMsgTextArea_.setDoubleBuffered(true);
	
	//JPanel pane = new JPanel();
	//pane.setBackground(java.awt.Color.blue);
	//pane.setSize(1000,1000);
	//pane.setMinimumSize(new Dimension(1000,1000));
	//pane.setPreferredSize(new Dimension(1000,1000));
	nextErrorButton_.addActionListener(
		new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				currentError_++;
				checkState();
			}

		}
	);

	prevErrorButton_.addActionListener(
		new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				currentError_--;
				checkState();
			}

		}
	);
	
	GridBagConstraints constr4 = new GridBagConstraints();
	constr4.anchor = constr4.NORTHWEST;
	constr4.gridx = 0;
	constr4.gridy = 0;
	constr4.gridwidth = 2;
	constr4.gridheight = 1;
	constr4.weightx = 1.0;
	constr4.weighty = 0;
	add(validationErrorsLabel_,constr4);
	
	GridBagConstraints constr = new GridBagConstraints();
	constr.anchor = constr.NORTHWEST;
	constr.fill = constr.BOTH;
	constr.gridx = 0;
	constr.gridy = 1;
	constr.gridwidth = 10;
	constr.gridheight = 8;
	constr.weightx = 1.0;
	constr.weighty = 1.0;
	add(new JScrollPane(errorMsgTextArea_),constr);

	GridBagConstraints constr2 = new GridBagConstraints();
	constr2.anchor = constr2.WEST;
	constr2.gridx = 0;
	constr2.gridy = 10;
	constr2.gridwidth = 2;
	constr2.gridheight = 1;
	constr2.weightx = 1.0;
	constr2.weighty = 0;
	add(prevErrorButton_,constr2);

	GridBagConstraints constr3 = new GridBagConstraints();
	constr3.anchor = constr3.EAST;
	constr3.gridx = 8;
	constr3.gridy = 10;
	constr3.gridwidth = 2;
	constr3.gridheight = 1;
	constr3.weightx = 1.0;
	constr3.weighty = 0;
	add(nextErrorButton_,constr3);

	checkState();
	revalidate();
}
/**
 * Insert the method's description here.
 * Creation date: (9/2/2002 8:47:06 AM)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	JFrame frame = new JFrame();
	ValidationPane pane = new ValidationPane();
	XmlValidationError[] error = new XmlValidationError[5];
	for(int i = 0; i < error.length; i++){
		SAXParseException ex = new SAXParseException("msg1"+i,"msg2"+i,"msg3"+i,0,1);
		error[i] = new XmlValidationError(ex);
	}
	pane.setValidationErrors(error);
	frame.setContentPane(pane);
	frame.setSize(400,400);
	frame.show();
}
/**
 * Insert the method's description here.
 * Creation date: (9/2/2002 10:39:53 AM)
 * @param newValidationErrors butterfly.xmlview.model.validation.interfaces.IValidationError[]
 */
public void setValidationErrors(butterfly.xmlview.model.validation.interfaces.IValidationError[] newValidationErrors) {
	validationErrors_ = newValidationErrors;
	currentError_ = 0;
	totalErrors_ = validationErrors_.length;
	checkState();
}
}
