package butterfly.xmlview.gui;

import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.DTDDeclaration;
import butterfly.xmlview.model.DocumentGeneratedSourceEvent;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentSourceEvent;
import butterfly.xmlview.model.interfaces.IDocumentSourceListener;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ITagInfo;
import butterfly.xmlview.model.interfaces.IValidatedDocument;
import butterfly.xmlview.model.validation.*;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class XmlCorrectionListener implements IDocumentSourceListener {
	/**
	 * @see butterfly.xmlview.model.interfaces.IDocumentSourceListener#handleDocumentSourceEvent(IDocumentSourceEvent)
	 */
	private boolean autoMatchLessThan_ = false;
	private boolean autoCorrect_ = true;

	public void handleDocumentSourceEvent(IDocumentSourceEvent evt) {
		if(!autoCorrect_ || evt instanceof DocumentGeneratedSourceEvent){return;}
		IDocument source = evt.getSource();
		XmlCorrection[] corrections = getCorrections(evt);
		for (int i = 0; i < corrections.length; i++) {
			source.insertString(corrections[i].index, corrections[i].text);
		}

	}
	
	//protected IAttribute getPossibleAttributeNames()

	public XmlCorrection[] getCorrections(IDocumentSourceEvent evt) {
		//Exception e = new Exception();
		//e.printStackTrace();
		System.out.println("fetching corrections");
		String txt = evt.getText();
		String endtag = null;
		int adjust = 0;
		if (txt != null) {

			IDocument source = evt.getSource();
			if (source instanceof IModelToSourceMapping) {
				System.out.println("got mapping...");
				INode node =
					((IModelToSourceMapping) source).nodeAt(evt.getStart());
				if (node instanceof IScratchTag) {

					IScratchTag stag = (IScratchTag) node;
					ITagInfo taginfo = stag.getTagInfo();


					

					System.out.println("the tag is " + stag);

					if (taginfo != null) {
						System.out.println("getting tag corrections");
//						if (txt.equals(">")
//							|| txt.equals("[")
//							|| txt.equals("<")
//							|| txt.equals("-")) {
							int type = taginfo.getType();

							if (type == ITagInfo.START_TAG
								&& txt.equals(">")
								&& taginfo.getName() != null) {
								endtag = "</" + taginfo.getName() + ">";
							}
							if (type == ITagInfo.CDATA_START
								&& txt.equals("[")) {
								endtag = "]]>";
							}
							if (type == ITagInfo.DOCTYPE_TAG
								&& txt.equals("[")) {
								endtag = "]>";
							}
							if (type == ITagInfo.COMMENT_START
								&& txt.equals("-")) {
								endtag = "-->";
							}
							if(stag.getParent() instanceof DTDDeclaration){
								String tagtext=stag.getText().trim();
						/*if(tagtext.equals("<!EN")){
							endtag ="TITY >";
							adjust = 4;	
						}
						if(tagtext.startsWith("<!EL")){
							endtag = "EMENT >";
							adjust = 7;
						}
						if(tagtext.equals("<!A")){
							endtag = "TTLIST >";
							adjust = 6;	
						}
						
						if(tagtext.equals("<![IN")){
							endtag = "CLUDE[ ]]>";	
							adjust = 6;
						}
						if(tagtext.equals("<![IG")){
							endtag = "NORE[ ]]>";	
							adjust = 5;
						}*/
						if(tagtext.startsWith("<!EN")){
							endtag ="TITY >";
							endtag=endtag.substring(tagtext.length()-4);
							adjust = 6-(tagtext.length()-4);	
						}
						if(tagtext.startsWith("<!EL")){
							endtag = "EMENT >";
							endtag=endtag.substring(tagtext.length()-4);
							adjust = 7-(tagtext.length()-4);
						}
						if(tagtext.startsWith("<!A")){
							endtag = "TTLIST >";
							endtag=endtag.substring(tagtext.length()-3);
							adjust = 8-(tagtext.length()-3);	
						}
						
						if(tagtext.startsWith("<![IN")){
							endtag = "CLUDE[ ]]>";	
							endtag=endtag.substring(tagtext.length()-5);
							adjust = 8-(tagtext.length()-5);
						}
						if(tagtext.startsWith("<![IG")){
							endtag = "NORE[ ]]>";	
							endtag=endtag.substring(tagtext.length()-5);
							adjust = 7-(tagtext.length()-5);
						}
						}
							System.out.println("txt.length="+txt.length()+ 
							" stag.getCurrentState="+stag.getCurrentState()+
							" txt.charAt(0)="+txt.charAt(0));
							if (txt.length() < 2
								&& stag.getCurrentState().equals(
									ScratchTag.CLOSED_STATE)
								&& Character.isLetter(txt.charAt(0))
								&& (type == ITagInfo.START_TAG ||
									type == ITagInfo.SELF_TERMINATING_TAG)) {
//								System.out.println(
//									"checking to see if this is an attribute");
								int offset =
									evt.getStart() - (stag.getStart() - 1);
								String tval =
									stag.getText().substring(
										1,
										stag.getText().length() - 1);
								int nameend = tval.trim().indexOf(" ");
								boolean no = false;
								if (nameend < 0) {
									nameend = tval.trim().length();
									no = true;
								}
								String name = tval.trim().substring(0, nameend);
								nameend = tval.indexOf(name) + name.length();
								
//								boolean spacebefore = false;
//								if(offset > 0){
//									char c = tval.charAt(offset-1);
//									if(c == ' '){
//										spacebefore = true;	
//									}	
//								}
								//we know that the insert was after the tag name
								//if it passes this test
								if (offset > nameend && !no) {
									//										int nextapos = tval.indexOf("\"",offset+1);
									//										int nextequals = tval.indexOf("=",offset+1);
									int lastapos =
										tval.lastIndexOf("\"", offset - 1);
									int lastequals =
										tval.lastIndexOf("=", offset - 1);
									int matchlastapos =
										tval.lastIndexOf("\"", lastapos - 1);

									if (lastapos < 0
										|| (lastapos > -1
											&& matchlastapos > -1
											&& matchlastapos > lastequals)) {
										endtag = "=\"\"";
									}

								}
								//endtag = "=\"\"";

							}

					//	}
					} else {
						System.out.println("getting non-tag corrections");
						if (autoMatchLessThan_) {
							if (txt.equals("<")
								&& stag.getCurrentState().equals(
									ScratchTag.OPEN_STATE)) {
								endtag = ">";
							}
						}
						String tagtext = stag.getText().trim();
						System.out.println("txt:"+txt+" tagtext:"+tagtext);
						
						if(txt.equals("?") &&
							tagtext.equals("<?")){
							endtag = "?>";								
						}
						if(txt.equals("-") && tagtext.equals("<!--")){
							endtag = "-->";
							adjust=5;
						}
						if(stag.getParent() instanceof DTDDeclaration){
						if(tagtext.startsWith("<!EN")){
							endtag ="TITY >";
							endtag=endtag.substring(tagtext.length()-4);
							adjust = 7-(tagtext.length()-4);	
						}
						if(tagtext.startsWith("<!EL")){
							endtag = "EMENT >";
							endtag=endtag.substring(tagtext.length()-4);
							adjust = 8-(tagtext.length()-4);
						}
						if(tagtext.startsWith("<!A")){
							endtag = "TTLIST >";
							endtag=endtag.substring(tagtext.length()-3);
							adjust = 9-(tagtext.length()-3);	
						}
						
						if(tagtext.startsWith("<![IN")){
							endtag = "CLUDE[ ]]>";	
							endtag=endtag.substring(tagtext.length()-5);
							adjust = 8-(tagtext.length()-5);
						}
						if(tagtext.startsWith("<![IG")){
							endtag = "NORE[ ]]>";	
							endtag=endtag.substring(tagtext.length()-5);
							adjust = 7-(tagtext.length()-5);
						}
						}
						
						if(tagtext.startsWith("<!D")){
							endtag = "OCTYPE [ ]>";
							endtag = endtag.substring(tagtext.length()-3);
							adjust = 8-(tagtext.length()-3);
						}
						if(stag.getCurrentState()==ScratchTag.OPEN_STATE && stag.getDocument() instanceof AbstractValidatedDocument){
							String name = tagtext.substring(1);
							int sp = name.indexOf(" ");
							if(sp < 0){
								sp = name.length();
							}
							name = name.substring(0,sp);
							
							String ns = null;
							if(name.indexOf(":")>0){
								ns = ((XmlDocument)stag.getDocument()).getNamespaceURI(name.substring(0,name.indexOf(":")));
							}
							IElementStructure[] structs = null;
							IValidationDocument vd = ((AbstractValidatedDocument)stag.getDocument()).getValidationDocument();
							if(vd instanceof CompoundValidationDocument){
								structs = ((CompoundValidationDocument)vd).getElementStructures(ns);
							}
							else{
								structs = vd.getElementStructures();	
							}
							if(structs !=null){
							for(int i = 0; i < structs.length; i++){
								if(structs[i].getName().startsWith(name)){
									endtag=structs[i].getName().substring(name.length());
									adjust = endtag.length()+1;	
								}
							}
							}
							
						}
						if (txt.equals("\"")
							&& (stag
								.getCurrentState()
								.equals(ScratchTag.OPEN_STATE)
								|| stag.getCurrentState().equals(
									ScratchTag.CLOSED_STATE))) {
							System.out.println(
								"checking to see if the paren is balanced");
							String text = stag.getText();
							int begin = text.indexOf("\"");
							int count = 0;
							while (begin > -1) {
								count++;
								begin = text.indexOf("\"", begin + 1);
							}
							if ((count % 2) != 0) {
								endtag = "\"";
							}
						}

					}

				}

			}

		}
		XmlCorrection[] corrections = null;
		if (endtag != null) {
			XmlCorrection correct =
				new XmlCorrection(evt.getStart() + 1, endtag);
			correct.cursorAdjustment=adjust;
			corrections = new XmlCorrection[1];
			corrections[0] = correct;
		} else {
			corrections = new XmlCorrection[0];
		}
		return corrections;
	}

	/**
	 * Returns the autoCorrect.
	 * @return boolean
	 */
	public boolean autoCorrectIsOn() {
		return autoCorrect_;
	}

	/**
	 * Sets the autoCorrect.
	 * @param autoCorrect The autoCorrect to set
	 */
	public void setAutoCorrect(boolean autoCorrect) {
		autoCorrect_ = autoCorrect;
	}

}
