/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

/**
 * Insert the type's description here.
 * Creation date: (11/3/2002 7:48:37 PM)
 * @author: 
 */
import java.util.Hashtable;

import javax.swing.text.BoxView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.FlowView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ZoneView;

import butterfly.xmlview.model.AbstractDocument;
import butterfly.xmlview.model.interfaces.IXmlDocument;
 
 
public class XmlEditorKit extends DefaultEditorKit{
	
	private static Hashtable xmlDocuments_ = new Hashtable(5);
	
    class XMLViewFactory implements javax.swing.text.ViewFactory {
        public javax.swing.text.View create(javax.swing.text.Element e){
           return new XmlView(e);
        }
    }
/**
 * XmlEditorKit constructor comment.
 */
public XmlEditorKit() {
	super();
}
  public final javax.swing.text.ViewFactory getViewFactory() {
        return new XMLViewFactory();
   }
   
   public static IXmlDocument getXmlDocument(Document doc){
   		return (IXmlDocument)xmlDocuments_.get(doc);
   }
   
   public static void setXmlDocument(Document doc,IXmlDocument xdoc){
   		xmlDocuments_.put(doc,xdoc);
   }
   
}
