/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.parsers.ElementParser;
/**
 * Insert the type's description here.
 * Creation date: (8/15/2002 3:56:58 PM)
 * @author: 
 */
public class XmlJTree extends javax.swing.JTree implements TreeSelectionListener,javax.swing.event.TreeModelListener {
private static Logger logger_ = Logger.getLogger(XmlJTree.class);
class XmlTreeCellEditor extends DefaultTreeCellEditor{
	public XmlTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
		super(tree,renderer);
	}
         
	public XmlTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
		super(tree,renderer,editor);
	}
           
	public boolean canEditImmediately(EventObject e){
		return true;
	}

}
	private Hashtable nodeLookup_;
	private IXmlDocument xmlModel_;
/**
 * XmlJTree constructor comment.
 */
public XmlJTree() {
	super();
}
/**
 * XmlJTree constructor comment.
 * @param value java.lang.Object[]
 */
public XmlJTree(java.lang.Object[] value) {
	super(value);
}
/**
 * XmlJTree constructor comment.
 * @param value java.util.Hashtable
 */
public XmlJTree(java.util.Hashtable value) {
	super(value);
}
/**
 * XmlJTree constructor comment.
 * @param value java.util.Vector
 */
public XmlJTree(java.util.Vector value) {
	super(value);
}
/**
 * XmlJTree constructor comment.
 * @param newModel javax.swing.tree.TreeModel
 */
public XmlJTree(javax.swing.tree.TreeModel newModel) {
	super(newModel);
}
/**
 * XmlJTree constructor comment.
 * @param root javax.swing.tree.TreeNode
 */
public XmlJTree(javax.swing.tree.TreeNode root) {
	super(root);
}
/**
 * XmlJTree constructor comment.
 * @param root javax.swing.tree.TreeNode
 * @param asksAllowsChildren boolean
 */
public XmlJTree(javax.swing.tree.TreeNode root, boolean asksAllowsChildren) {
	super(root, asksAllowsChildren);
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 4:00:23 PM)
 * @param param javax.swing.tree.TreeNode
 * @param xmlnode butterfly.xmlview.model.Node
 */
public void associate(TreeNode node, INode xmlnode) {
	if(nodeLookup_ == null){
		nodeLookup_ = new Hashtable(17);
	}
	nodeLookup_.put(node,xmlnode);
}
    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path, expand);
            }
        }
    
        // Expansion or collapse must be done bottom-up
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)getModel().getRoot();

        
        // Traverse tree from root
        expandAll(this, new TreePath(root), expand);
    }
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 4:02:10 PM)
 * @return butterfly.xmlview.model.Node
 * @param node javax.swing.tree.TreeNode
 */
public INode getAssociatedNode(TreeNode node) {
	if(nodeLookup_ == null){return null;}
	return (INode)nodeLookup_.get(node);
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 4:04:09 PM)
 * @return java.util.Hashtable
 */
public java.util.Hashtable getNodeLookup() {
	return nodeLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 11:48:50 PM)
 * @return XmlDocument
 */
public IXmlDocument getXmlModel() {
	return xmlModel_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 4:00:23 PM)
 * @param param javax.swing.tree.TreeNode
 * @param xmlnode butterfly.xmlview.model.Node
 */
public void removeAssociation(TreeNode node) {
	if(nodeLookup_ == null){
		return;
	}
	nodeLookup_.remove(node);
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 4:04:09 PM)
 * @param newNodeLookup java.util.Hashtable
 */
public void setNodeLookup(java.util.Hashtable newNodeLookup) {
	nodeLookup_ = newNodeLookup;
	getModel().addTreeModelListener(this);
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 11:48:50 PM)
 * @param newXmlModel XmlDocument
 */
public void setXmlModel(IXmlDocument newXmlModel) {
	xmlModel_ = newXmlModel;
}
public void treeNodesChanged(javax.swing.event.TreeModelEvent e) {
		System.out.println("tree node changed event");
		
        DefaultMutableTreeNode node;
        node = (DefaultMutableTreeNode)
                 (e.getTreePath().getLastPathComponent());

     
        try {
            int index = e.getChildIndices()[0];
            node = (DefaultMutableTreeNode)
                   (node.getChildAt(index));
        } catch (NullPointerException exc) {
	    	return;    
	    }
		
    	String xmlnode = (String)node.getUserObject();

    	INode oldl = getAssociatedNode(node);
    	if(oldl == null){
			return;
    	}
    	if(oldl instanceof IElement){
    		IElement nel = ElementParser.parseElement(xmlnode);
    	
    		IElement current = (IElement)oldl;
	    	
    		
    		if(nel != null){
	    		String xpath = current.getPath();//getXmlModel().getXPath(current);
				current.setName(nel.getName());
				current.clearAttributes();
				for(int i = 0; i < nel.attributeCount(); i++){
					current.addAttribute(nel.attributeAt(i));
				}
				//getXmlModel().updateElementTag(xpath,current);
				getXmlModel().updateNode(current);
    		}
    		node.setUserObject(current);
    		logger_.debug("updating model..");
    		
    	}
    	if(oldl instanceof IValueNode){
	    	IValueNode vnode = (IValueNode)oldl;
			vnode.setData(xmlnode);
			//String xpath = getXmlModel().getXPath(vnode);
			//getXmlModel().updateElementText(xpath,vnode);
			getXmlModel().updateNode(vnode);
			node.setUserObject(vnode);
    	}
		
    	
    	//node.
    //	String elementval = node.get
	
}
	/**
	 * <p>Invoked after nodes have been inserted into the tree.</p>
	 * 
	 * <p>e.path() returns the parent of the new nodes
	 * <p>e.childIndices() returns the indices of the new nodes in
	 * ascending order.
	 */
public void treeNodesInserted(javax.swing.event.TreeModelEvent e) {}
	/**
	 * <p>Invoked after nodes have been removed from the tree.  Note that
	 * if a subtree is removed from the tree, this method may only be
	 * invoked once for the root of the removed subtree, not once for
	 * each individual set of siblings removed.</p>
	 *
	 * <p>e.path() returns the former parent of the deleted nodes.</p>
	 * 
	 * <p>e.childIndices() returns the indices the nodes had before they were deleted in ascending order.</p>
	 */
public void treeNodesRemoved(javax.swing.event.TreeModelEvent e) {}
	/**
	 * <p>Invoked after the tree has drastically changed structure from a
	 * given node down.  If the path returned by e.getPath() is of length
	 * one and the first element does not identify the current root node
	 * the first element should become the new root of the tree.<p>
	 * 
	 * <p>e.path() holds the path to the node.</p>
	 * <p>e.childIndices() returns null.</p>
	 */
public void treeStructureChanged(javax.swing.event.TreeModelEvent e) {}
	/** 
	  * Called whenever the value of the selection changes.
	  * @param e the event that characterizes the change.
	  */
public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
	DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
	if(node.getUserObject() instanceof IElement){
		//logger_.debug("xpath:"+getXmlModel().getXPath((IElement)node.getUserObject()));
	}
	if(node.getUserObject() instanceof IValueNode){
		//logger_.debug("xpath:"+getXmlModel().getXPath((IValueNode)node.getUserObject()));
	}
}
}
