/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IXmlOutline;
import butterfly.xmlview.gui.tree.DocumentTreeModel;
import butterfly.xmlview.gui.tree.TreeEditorLookup;
import butterfly.xmlview.gui.tree.XmlTreeEditor;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IComment;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IProcessingInstruction;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (12/1/2002 1:59:58 PM)
 * @author: 
 */
public class XmlOutline extends TreeView implements IDocumentEditor,IXmlOutline,IStateEventSource{
	private static ImageIcon nextErrorIcon_ =new ImageIcon("icons/stock_error-next-16.png");
	private static ImageIcon prevErrorIcon_ =new ImageIcon("icons/stock_error-previous-16.png");
	private static ImageIcon attrIcon_ =new ImageIcon("icons/stock_attrs-16.png");
	
	class ToggleAttributesAction extends AbstractAction{
		INode current_ = null;
		private boolean curr = true;
		
		public ToggleAttributesAction(){
			putValue(this.NAME,"Show/Hide Attributes");
			putValue(this.LONG_DESCRIPTION,"Show or Hide All Attributes");
			putValue(this.SMALL_ICON,attrIcon_);
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			editor_.setShowAttributes(!curr);
			curr = !curr;
			
			getTree().revalidate();
			getTree().repaint();
		}
	}
	
	
	class NextErrorAction extends AbstractAction{
		INode current_ = null;
		public boolean reverse= false;
		
		public NextErrorAction(){
			putValue(this.NAME,"Next Error");
			putValue(this.LONG_DESCRIPTION,"Go to the Next Error");
			putValue(this.SMALL_ICON,nextErrorIcon_);
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			IScratchTag[] tags = ((XmlDocument)document_).getScratchTags();
			if(tags != null){
				if(tags.length > 0){
					if(current_ == null){
						current_ = tags[0];
						focusOnNode(current_);	
					}	
					else{
						if(!reverse){
						for(int i = 0; i < tags.length; i++){
							if(tags[i].compareTo(current_) > 0){
								current_ = tags[i];
								focusOnNode(current_);
								return;
							}	
						}
						}
						else{
						INode tmp = null;
						for(int i = 0; i < tags.length; i++){
						
							if(tags[i].compareTo(current_) < 0 && (tags[i].compareTo(tmp) >= 0 || tmp==null)){
								tmp = current_;
							}		
							else if(tmp != null){
								current_ = tmp;
								focusOnNode(current_);
								return ;
							}					
						}
						}
						current_ = tags[0];
						focusOnNode(tags[0]);	
					}
				}
			}
		}

	}
	
	
	class PreviousErrorAction extends AbstractAction{
		INode current_ = null;
		
		
		public PreviousErrorAction(){
			putValue(this.NAME,"Previous Error");
			putValue(this.LONG_DESCRIPTION,"Go to the Previous Error");
			putValue(this.SMALL_ICON,prevErrorIcon_);
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			IScratchTag[] tags = ((XmlDocument)document_).getScratchTags();
			if(tags != null){
				if(tags.length > 0){
					if(current_ == null){
						current_ = tags[0];
						focusOnNode(current_);	
					}	
					else{
						
						INode tmp = null;
						for(int i = 0; i < tags.length; i++){
						
							if(tags[i].compareTo(current_) < 0 && (tags[i].compareTo(tmp) >= 0 || tmp==null)){
								tmp = current_;
							}		
							else if(tmp != null){
								current_ = tmp;
								focusOnNode(current_);
								return ;
							}					
						}
						
						current_ = tags[0];
						focusOnNode(tags[0]);	
					}
				}
			}
		}

	}
	
	
	private IDocument document_;
	private XmlTreeEditor editor_;
/**
 * XmlTree constructor comment.
 * @param t javax.swing.tree.DefaultTreeModel
 */
public XmlOutline() {
	super(new DocumentTreeModel(new javax.swing.tree.DefaultMutableTreeNode("Project Files")));
	((DocumentTreeModel)getTreeModel()).setTree(getTree());
	
	TreeEditorLookup lookup = new TreeEditorLookup();
	//setCellEditor(new DocumentTreeCellEditor(this));
	getTree().setRowHeight(0);
	XmlTreeEditor ed = new XmlTreeEditor();
	editor_ =ed;
	ed.setShowAttributes(true);
	lookup.registerTreeEditor(IElement.class, ed);
	lookup.registerTreeEditor(IValueNode.class,ed );
	lookup.registerTreeEditor(IDocumentDeclaration.class, ed);
	lookup.registerTreeEditor(IProcessingInstruction.class,ed);
	lookup.registerTreeEditor(IComment.class, ed);
	lookup.registerTreeEditor(IDTDNode.class, ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
	setTreeEditorLookup(lookup);
	//makeTableTree();
	//setEditable(true);
//	setCellEditor(new DocumentCellEditor(new JTextArea(),this));
//	setCellEditor(
//		new DefaultTreeCellEditor(this,(DefaultTreeCellRenderer)getCellRenderer()){
//			public boolean isCellEditable(EventObject event) {
//				return true;	
//			}	
//		}
//	);
	XmlDocument nodoc = new XmlDocument("<no-document/>");
	loadDocument(nodoc);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int find(java.lang.String srch, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {
	DefaultMutableTreeNode tnode = getTreeNode(node);
	if(tnode != null){
		TreePath toroot = new TreePath(tnode.getPath());
		getTree().setSelectionPath(toroot);
		
		getTree().scrollPathToVisible(toroot);
		//getTree().scrollRowToVisible(getTree().getRowForPath(new TreePath(node.getPath())));
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:36:45 PM)
 * @return IDocument
 */
public IDocument getDocument() {
	
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:36:45 PM)
 * @return IDocument
 */
public IDocument getIDocument() {
	
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public butterfly.xmlview.model.interfaces.INode[] getSelectedNodes() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:41:13 PM)
 * @return butterfly.xmlview.model.interfaces.IXmlDocument
 */
public butterfly.xmlview.model.interfaces.IXmlDocument getXmlModel() {
	return (IXmlDocument)document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:36:45 PM)
 * @param newDocument IDocument
 */
public void loadDocument(IDocument newDocument) {
	document_ = newDocument;
	super.loadDocument(newDocument);
	//getTree().expandAll(getTree(),true);
	getTree().expandColumn(3);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int replace(java.lang.String srch, java.lang.String rep, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:23 AM)
 * @param start int
 */
public void setSelectionEnd(int end) {}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:23 AM)
 * @param start int
 */
public void setSelectionStart(int start) {}
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getSelectedTreeNodes()
	 */
	public DefaultMutableTreeNode[] getSelectedTreeNodes() {
		return super.getSelectedTreeNodes();
	}

	/**
	 * @see butterfly.xmlview.gui.TreeView#initToolBar()
	 */
	protected void initToolBar() {
		JToolBar tbar = getToolBar();
		tbar.setBorder(new EmptyBorder(0,0,0,0));
		JLabel title = new JLabel("Outline");
		title.setFont(title.getFont().deriveFont(Font.BOLD));
		tbar.add(title);
		super.initToolBar();
		
		tbar.add(new PreviousErrorAction()).setToolTipText("Previous Error");
		tbar.add(new NextErrorAction()).setToolTipText("Next Error");
		JToggleButton attr = new JToggleButton(new ToggleAttributesAction());
		attr.setToolTipText("Show/Hide Attributes");
		attr.setText(null);
		attr.setSelected(true);
		//attr.doClick();
		tbar.add(attr);
		//attr.doClick();
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
	}

}
