/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

import org.apache.log4j.Logger;

import butterfly.actions.DeclarePrefixAction;
import butterfly.actions.GenerateSchemaAction;
import butterfly.actions.GetPrefixesInUseAction;
import butterfly.actions.GoToLineAction;
import butterfly.actions.XmlTidyAction;
import butterfly.actions.document.AddElementAction;
import butterfly.actions.document.AddNodeAction;
import butterfly.actions.document.AppendSchemaAction;
import butterfly.actions.document.DocumentNodeAction;
import butterfly.actions.document.IndentNodeAction;
import butterfly.statemachine.DocumentEditorStateEvent;
import butterfly.statemachine.StateListenerManager;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IMarkerRenderer;
import butterfly.xmlview.gui.interfaces.IMarkerView;
import butterfly.xmlview.gui.interfaces.INodeSelectionListener;
import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.CDataNode;
import butterfly.xmlview.model.Comment;
import butterfly.xmlview.model.DTDDeclaration;
import butterfly.xmlview.model.DocumentGeneratedSourceEvent;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.DocumentSourceEvent;
import butterfly.xmlview.model.NamespacePrefixMapping;
import butterfly.xmlview.model.ProcessingInstruction;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.WriteProtectionMarker;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.grammars.DTDGenerator;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.IDocumentSourceEvent;
import butterfly.xmlview.model.interfaces.IDocumentSourceListener;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IMarkerListener;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.ITagInfo;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/15/2002 6:09:38 PM)
 * @author: 
 */
public class XmlSourceEditor
	extends JEditorPane
	implements IMarkerView,IDocumentListener, IStateEventSource, KeyListener,IDocumentEditor {

	protected class SuggestionMenu extends JPopupMenu {
	
		public SuggestionMenu(){
			setOpaque(false);
		}

	}
	
	protected class FindEndTagAction extends DocumentNodeAction{
		public FindEndTagAction(){
			putValue(NAME,"Show Matching Tag");
		}
			/* (non-Javadoc)
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			// TODO Auto-generated method stub
			int where = ((IElement)getNode()).getEndTagStart();
			int dot = getCaret().getDot();
			int l = 0;
			if(dot < where){
			  l =((IElement)getNode()).getEndTagLength();
			}
			else{
				where = getNode().getStart();
				l = getNode().getLength();
			}
			getCaret().setDot(where);
			getCaret().moveDot(where+l);
		}

};
	
	protected class ProtectedDocument extends DefaultStyledDocument{
		
		/**
		 * Constructor for ProtectedDocument.
		 * @param c
		 * @param styles
		 */
		public ProtectedDocument(Content c, StyleContext styles) {
			super(c, styles);
		}

		/**
		 * Constructor for ProtectedDocument.
		 * @param styles
		 */
		public ProtectedDocument(StyleContext styles) {
			super(styles);
		}

		/**
		 * Constructor for ProtectedDocument.
		 */
		public ProtectedDocument() {
			super();
		}

		/**
		 * @see javax.swing.text.Document#insertString(int, String, AttributeSet)
		 */
		public void insertString(int offset, String str, AttributeSet a)
			throws BadLocationException {
			int where = offset;
			//logger_.debug("insert");
			INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(where);
			if(node != null){
				IMarker[] markers = node.getMarkersOfType(WriteProtectionMarker.WRITE_PROTECTED_MARKER_TYPE);
				if(markers != null){
					if(markers.length > 0){
						
						//logger_.debug("the node was write protected");
						return;	
					}	
				}
				
			}
			super.insertString(offset, str, a);
		}

		/**
		 * @see javax.swing.text.Document#remove(int, int)
		 */
		public void remove(int offset, int len) throws BadLocationException {
			int where = offset;
			//logger_.debug("insert");
			INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(where);
			if(node != null){
				IMarker[] markers = node.getMarkersOfType(WriteProtectionMarker.WRITE_PROTECTED_MARKER_TYPE);
				if(markers != null){
					if(markers.length > 0){
						
						//logger_.debug("the node was write protected");
						return;	
					}	
				}
				
			}
			
			super.remove(offset, len);
		}

	}

	protected class MarkerListener implements IMarkerListener {

		/**
		 * @see butterfly.xmlview.model.interfaces.IMarkerListener#markerAdded(INode, IMarker)
		 */
		public void markerAdded(INode node, IMarker m) {
			logger_.debug("marker added to:" + node);
			logger_.debug("node has warnings=" + node.hasWarningMarkers());
			repaint();
		}

		/**
		 * @see butterfly.xmlview.model.interfaces.IMarkerListener#markerRemoved(INode, IMarker)
		 */
		public void markerRemoved(INode node, IMarker m) {
			
			markerView_.removeMarker(m);
			repaint();
		}

	}
	
	protected class InfoAction extends AbstractAction{
			
		
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			JPopupMenu menu = new JPopupMenu();
			menu.setOpaque(false);
			menu.setBorder(new EmptyBorder(0,0,0,0));
			menu.add(new InfoAction()).setText("info");
			menu.show(XmlSourceEditor.this,100,100);
		}

	}
	
	protected class ConvertAction extends AbstractAction{
			
		
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			XmlDocument doc = (XmlDocument)model_;
			int dot = getCaret().getDot();
			ISourceNode node = doc.nodeAt(dot);
			doc.makeChildCapable(node);
		}

	}

	protected class ShowMarkersAction extends AbstractAction {

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			String msg = "Warnings="+node.hasWarningMarkers()+"\n";
			if (node != null) {
				IMarker[] markers = node.getMarkers();
				if (markers != null) {
					for (int i = 0; i < markers.length; i++) {
						msg += "ID:"
							+ markers[i].getType()
							+ " : "
							+ markers[i].getMessage()
							+ "\n";
					}
				}
			} else {
				msg = "no node is present at that index";
			}

			javax.swing.JOptionPane.showMessageDialog(
				XmlSourceEditor.this,
				msg,
				"",
				0,
				null);

		}

	}
	
	protected class ShowMarkerCountAction extends AbstractAction {

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			String msg = "";
			if (node != null) {
				IMarker[] markers = node.getMarkers();
				if (markers != null) {
					for (int i = 0; i < markers.length; i++) {
						msg += "ID:"
							+ markers[i].getType()
							+ " : "
							+ markers[i].getMessage()
							+ "\n";
					}
				}
			} else {
				msg = "no node is present at that index";
			}

			javax.swing.JOptionPane.showMessageDialog(
				XmlSourceEditor.this,
				msg,
				"",
				0,
				null);

		}

	}

	protected class ShowPrefixMappingsAction extends AbstractAction {

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			String msg = "Namespaces: ";
			if (node != null && node instanceof IElement) {
				IElement el = (IElement) node;
				for (int i = 0; i < el.attributeCount(); i++) {
					IAttribute atr = el.attributeAt(i);
					if (atr instanceof NamespacePrefixMapping) {
						msg += "prefix:"
							+ atr.getName()
							+ " uri:"
							+ atr.getData()
							+ ", ";
					}
				}
			} else {
				msg = "no prefixes are defined at that index";
			}

			javax.swing.JOptionPane.showMessageDialog(
				XmlSourceEditor.this,
				msg,
				"",
				0,
				null);

		}

	}

	protected class WriteProtectNodeAction extends AbstractAction {
		
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			if(node != null){
				IMarker[] markers = node.getMarkersOfType(WriteProtectionMarker.WRITE_PROTECTED_MARKER_TYPE);
				if(markers != null){
					if(markers.length > 0){
						node.removeMarker(markers[0]);	
					}	
					else{
						node.addMarker(new WriteProtectionMarker());	
					}					
				}
				else{
						node.addMarker(new WriteProtectionMarker());	
					}	
				
			}
		}

	}
	
	


	protected class ShowNamespaceAction extends AbstractAction {

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			String msg = "Namespace:";
			if (node != null && node instanceof IElement) {
				IElement el = (IElement) node;
				msg += el.getNameSpace();
			} else {
				msg = "no prefixes are defined at that index";
			}

			javax.swing.JOptionPane.showMessageDialog(
				XmlSourceEditor.this,
				msg,
				"",
				0,
				null);

		}

	}
	
	
	
	protected class ShowAttributesAction extends AbstractAction {

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			String msg = "attributes:\n";
			if (node != null && node instanceof IElement) {
				IElement el = (IElement) node;
				for(int i = 0;i < el.attributeCount(); i++){
					msg+= el.attributeAt(i)+"\n";	
				}
				//msg += el.getNameSpace();
			} else {
				msg = "no prefixes are defined at that index";
			}

			javax.swing.JOptionPane.showMessageDialog(
				XmlSourceEditor.this,
				msg,
				"",
				0,
				null);

		}

	}

	protected class XmlDocumentSourceListener
		implements IDocumentSourceListener {

		/**
		 * @see butterfly.xmlview.model.interfaces.IDocumentSourceListener#handleDocumentSourceEvent(IDocumentSourceEvent)
		 */
		public void handleDocumentSourceEvent(IDocumentSourceEvent evt) {
			if (loading_ ){return;}
			
			if (evt instanceof DocumentGeneratedSourceEvent || getXmlModel().length() != getDocument().getLength()) {
				((IXmlDocument) getXmlModel()).lock();
				try {
					//getDocument().remove(evt.getStart(),evt.getLength());
					//getDocument().insertString(evt.getStart(),evt.getText(),null);
					INode curr = null;
					INode[] where = getSelectedNodes();
					if (where.length > 0) {
						curr = where[0];
					}
					logger_.debug(
						"update: " + evt.getStart() + "," + evt.getLength());
					
					if (evt.getLength() >= getDocument().getLength()) {
						setText(evt.getText());
					} else {
						if (evt.getLength() > 0) {
							getDocument().remove(
								evt.getStart(),
								evt.getLength());
						}
						if (evt.getText() != null) {
							getDocument().insertString(
								evt.getStart(),
								evt.getText(),
								null);
						}
					}
					//setText(model_.toString());
					//setText(evt.getText());
					//setText(getXmlModel().toString());
					if (curr != null) {
						//focusOnNode(curr);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
				((IXmlDocument) getXmlModel()).unlock();
			}
			else{
				//corrector_.setCorrections(correctionListener_.getCorrections(evt));
				//corrector_.makeCorrectionsLater();
			}
		}

	}
	
	protected class CorrectAction extends AbstractAction{
		
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			int dot = getCaret().getDot()-1;
			//int lastlt = getText().lastIndexOf("<",dot);
			//int lastsp = getText().lastIndexOf(" ",dot);
			//if(lastsp < lastlt){
			INode node =((IModelToSourceMapping)getXmlModel()).nodeAt(getCaret().getDot());
			if(node != null && node instanceof IScratchTag){
			IScratchTag stag = (IScratchTag)node;
			if(stag.getCurrentState()==ScratchTag.OPEN_STATE && stag.getDocument() instanceof AbstractValidatedDocument){
							logger_.debug("ctrl+space");
							String tagtext = stag.getText().trim();
							String name = tagtext.substring(1);
							int sp = name.indexOf(" ");
							if(sp < 0){
								sp = name.length();
							}
							name = name.substring(0,sp);
							
							String ns = null;
							if(name.indexOf(":")>0){
								ns = ((XmlDocument)stag.getDocument()).getNamespaceURI(name.substring(0,name.indexOf(":")));
							}
							if(stag.getParent()instanceof IElement){
							IElementStructure[] structs = listPossibleElements((IElement)stag.getParent(),name,ns);
							if(structs == null){
								return;								
							}
//							IValidationDocument vd = ((AbstractValidatedDocument)stag.getDocument()).getValidationDocument();
							//if(vd!=null){
//							if(vd instanceof CompoundValidationDocument){
//								structs = ((CompoundValidationDocument)vd).getElementStructures(ns);
//							}
//							else{
//								structs = vd.getElementStructures();	
//							}
							//logger_.debug("searching "+structs.length+" structs for "+name);
							Vector result = new Vector();
							for(int i = 0; i < structs.length; i++){
								if(structs[i].getName().toLowerCase().startsWith(name.toLowerCase())){
									result.add(structs[i].getName());
								}
								else{
									logger_.debug("no match:"+structs[i].getName());	
								}
								
							}
							if(result.size()>0){
								if(result.size()==1){
									SuggestionAction act = new SuggestionAction();
									act.start_=stag.getStart()+1;
									act.suggestion_ = result.elementAt(0)+"></"+result.elementAt(0)+">";
									//act.end_=getCaret().getDot();
									act.actionPerformed(null);
									return;
								}
								else{
								showSuggestionMenu(((DefaultCaret) getCaret()).x,
											((DefaultCaret) getCaret()).y,
											getCaret().getDot(),(String[])result.toArray(new String[0]),true);
								return;
								}	
							//}
							}
							}
							logger_.debug("no results");
							
						}
			}
			DocumentSourceEvent dse = new DocumentSourceEvent(getXmlModel(),dot,0,""+getText().charAt(dot));
			XmlCorrection[] corrections = correctionListener_.getCorrections(dse);
			for (int i = 0; i < corrections.length; i++) {
				try{
					insertString(corrections[i].index, corrections[i].text);
					getCaret().setDot(dot+corrections[i].cursorAdjustment);
					logger_.debug("correction : "+corrections[i].cursorAdjustment);
				}catch(Exception e2){
					e2.printStackTrace();
				}
			}
			//}
		}

	}
	
	
//	protected class Corrector implements Runnable{
//		private XmlCorrection[] corrections_;
//		public void run(){
//			makeCorrections();				
//		}
//		public void makeCorrections(){
//			loading_ = true;
//			if(corrections_ == null){return;}
//			logger_.debug("making "+corrections_.length+" correction(s)");
//				for (int i = 0; i < corrections_.length; i++) {
//					try{
//						logger_.debug("adding correction:"+corrections_[i].text);
//						insertString(corrections_[i].index, corrections_[i].text);
//						getCaret().setDot(corrections_[i].index+corrections_[i].cursorAdjustment);
//					}catch(Exception e){
//						e.printStackTrace();
//					}
//				}	
//			loading_ = false;
//		}
//		public void makeCorrectionsLater(){
//			SwingUtilities.invokeLater(this);
//		}
//		/**
//		 * Returns the corrections.
//		 * @return XmlCorrection[]
//		 */
//		public XmlCorrection[] getCorrections() {
//			return corrections_;
//		}
//
//		/**
//		 * Sets the corrections.
//		 * @param corrections The corrections to set
//		 */
//		public void setCorrections(XmlCorrection[] corrections) {
//			corrections_ = corrections;
//		}
//
//	}
//		
	

	protected class XmlStyleDocument extends DefaultStyledDocument {
		/**
		 * Constructor for XmlStyleDocument.
		 * @param c
		 * @param styles
		 */
		public XmlStyleDocument(Content c, StyleContext styles) {
			super(c, styles);
		}

		/**
		 * Constructor for XmlStyleDocument.
		 * @param styles
		 */
		public XmlStyleDocument(StyleContext styles) {
			super(styles);
		}

		/**
		 * Constructor for XmlStyleDocument.
		 */
		public XmlStyleDocument() {
			super();
		}

		/**
		 * @see javax.swing.text.AbstractDocument#insertUpdate(DefaultDocumentEvent, AttributeSet)
		 */
		protected void insertUpdate(
			DefaultDocumentEvent chng,
			AttributeSet attr) {

			logger_.debug("new insert called **&*&*&*&*&*&*&*&*&*&");
			/*int offset = chng.getOffset();
			int length = chng.getLength();
			if (attr == null) {
			    attr = SimpleAttributeSet.EMPTY;
			}
			
			// Paragraph attributes should come from point after insertion.
			// You really only notice this when inserting at a paragraph
			// boundary.
			Element paragraph = getParagraphElement(offset + length);
			AttributeSet pattr = paragraph.getAttributes();
			// Character attributes should come from actual insertion point.
			Element pParagraph = getParagraphElement(offset);
			Element run = pParagraph.getElement(pParagraph.getElementIndex
							    (offset));
			int endOffset = offset + length;
			boolean insertingAtBoundry = (run.getEndOffset() == endOffset);
			AttributeSet cattr = run.getAttributes();
			
			try {
			    Segment s = new Segment();
			    Vector parseBuffer = new Vector();
			    ElementSpec lastStartSpec = null;
			    boolean insertingAfterNewline = false;
			    short lastStartDirection = ElementSpec.OriginateDirection;
			    // Check if the previous character was a newline.
			    if (offset > 0) {
				getText(offset - 1, 1, s);
				if (s.array[s.offset] == '\n') {
				    // Inserting after a newline.
				    insertingAfterNewline = true;
				    lastStartDirection = createSpecsForInsertAfterNewline
					          (paragraph, pParagraph, pattr, parseBuffer,
						   offset, endOffset);
				    for(int counter = parseBuffer.size() - 1; counter >= 0;
					counter--) {
					ElementSpec spec = (ElementSpec)parseBuffer.
					                    elementAt(counter);
					if(spec.getType() == ElementSpec.StartTagType) {
					    lastStartSpec = spec;
					    break;
					}
				    }
				}
			    }
			    // If not inserting after a new line, pull the attributes for
			    // new paragraphs from the paragraph under the insertion point.
			    if(!insertingAfterNewline)
				pattr = pParagraph.getAttributes();
			
			    getText(offset, length, s);
			    char[] txt = s.array;
			    int n = s.offset + s.count;
			    int lastOffset = s.offset;
			
			    for (int i = s.offset; i < n; i++) {
				if (txt[i] == '\n') {
				    int breakOffset = i + 1;
				    parseBuffer.addElement(
			                    new ElementSpec(attr, ElementSpec.ContentType,
							       breakOffset - lastOffset));
				    parseBuffer.addElement(
			                    new ElementSpec(null, ElementSpec.EndTagType));
				    lastStartSpec = new ElementSpec(pattr, ElementSpec.
								   StartTagType);
				    parseBuffer.addElement(lastStartSpec);
				    lastOffset = breakOffset;
				}
			    }
			    if (lastOffset < n) {
				parseBuffer.addElement(
			                new ElementSpec(attr, ElementSpec.ContentType,
							   n - lastOffset));
			    }
			
			    ElementSpec first = (ElementSpec) parseBuffer.firstElement();
			
			    int docLength = getLength();
			
			    // Check for join previous of first content.
			    if(first.getType() == ElementSpec.ContentType &&
			       cattr.isEqual(attr)) {
				first.setDirection(ElementSpec.JoinPreviousDirection);
			    }
			
			    // Do a join fracture/next for last start spec if necessary.
			    if(lastStartSpec != null) {
				if(insertingAfterNewline) {
				    lastStartSpec.setDirection(lastStartDirection);
				}
				// Join to the fracture if NOT inserting at the end
				// (fracture only happens when not inserting at end of
				// paragraph).
				else if(pParagraph.getEndOffset() != endOffset) {
				    lastStartSpec.setDirection(ElementSpec.
							       JoinFractureDirection);
				}
				// Join to next if parent of pParagraph has another
				// element after pParagraph, and it isn't a leaf.
				else {
				    Element parent = pParagraph.getParentElement();
				    int pParagraphIndex = parent.getElementIndex(offset);
				    if((pParagraphIndex + 1) < parent.getElementCount() &&
				       !parent.getElement(pParagraphIndex + 1).isLeaf()) {
					lastStartSpec.setDirection(ElementSpec.
								   JoinNextDirection);
				    }
				}
			    }
			
			    // Do a JoinNext for last spec if it is content, it doesn't
			    // already have a direction set, no new paragraphs have been
			    // inserted or a new paragraph has been inserted and its join
			    // direction isn't originate, and the element at endOffset 
			    // is a leaf.
			    if(insertingAtBoundry && endOffset < docLength) {
				ElementSpec last = (ElementSpec) parseBuffer.lastElement();
				if(last.getType() == ElementSpec.ContentType &&
				   last.getDirection() != ElementSpec.JoinPreviousDirection &&
				   ((lastStartSpec == null && (paragraph == pParagraph ||
							       insertingAfterNewline)) ||
				    (lastStartSpec != null && lastStartSpec.getDirection() !=
				     ElementSpec.OriginateDirection))) {
				    Element nextRun = paragraph.getElement(paragraph.
							   getElementIndex(endOffset));
				    // Don't try joining to a branch!
				    if(nextRun.isLeaf() &&
				       attr.isEqual(nextRun.getAttributes())) {
					last.setDirection(ElementSpec.JoinNextDirection);
				    }
				}
			    }
			    // If not inserting at boundary and there is going to be a
			    // fracture, then can join next on last content if cattr
			    // matches the new attributes.
			    else if(!insertingAtBoundry && lastStartSpec != null &&
				    lastStartSpec.getDirection() ==
				    ElementSpec.JoinFractureDirection) {
				ElementSpec last = (ElementSpec) parseBuffer.lastElement();
				if(last.getType() == ElementSpec.ContentType &&
				   last.getDirection() != ElementSpec.JoinPreviousDirection &&
				   attr.isEqual(cattr)) {
				    last.setDirection(ElementSpec.JoinNextDirection);
				}
			    }
			
			    // Check for the composed text element. If it is, merge the character attributes
			    // into this element as well.
			    if (Utilities.isComposedTextAttributeDefined(attr)) {
			        ((MutableAttributeSet)attr).addAttributes(cattr);
			        ((MutableAttributeSet)attr).addAttribute(AbstractDocument.ElementNameAttribute, 
				                                         AbstractDocument.ContentElementName);
			    }
			
			    ElementSpec[] spec = new ElementSpec[parseBuffer.size()];
			    parseBuffer.copyInto(spec);
			    buffer.insert(offset, length, spec, chng);
			} catch (BadLocationException bl) {
			}
			*/
			//super.super.insertUpdate( chng, attr );
		}

	}

	protected class NodeListener implements IDocumentListener {

		/**
		 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(IDocumentEvent)
		 */
		public void handleDocumentEvent(IDocumentEvent evt) {
			setNodeStyle(evt.getChangedNode(), false);
		}

	}

	protected class ShowNodeAction extends javax.swing.AbstractAction {
		public void actionPerformed(java.awt.event.ActionEvent ae) {
			int dot = getCaret().getDot();
			ISourceNode node = ((XmlDocument) getXmlModel()).nodeAt(dot);
			String msg = "";
			if (node != null) {
				msg =
					"node start:"
						+ node.getStart()
						+ " length:"
						+ node.getLength();
				if (node instanceof ISourceElement) {
					ISourceElement sel = (ISourceElement) node;
					msg += " node endtag: start:"
						+ sel.getEndTagStart()
						+ " length:"
						+ sel.getEndTagLength();
					setSelectionStart(sel.getEndTagStart());
					setSelectionEnd(
						sel.getEndTagStart() + sel.getEndTagLength());
				} else {
					focusOnNode(node);
				}
			} else {
				msg = "no node is present at that index";
			}

			javax.swing.JOptionPane.showMessageDialog(
				XmlSourceEditor.this,
				msg,
				"",
				0,
				null);
		}

	}
	protected class RefreshAction extends AbstractAction{
		
		
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent arg0) {
			logger_.debug("refresh...");
			logger_.debug(getXmlModel().toString());
			loadXmlModel(getXmlModel());
		}

	}
	protected class EditorMouseListener extends java.awt.event.MouseAdapter implements MouseMotionListener{
		private Point helpLocation_;
		private boolean continue_ = false;
		private Thread helpThread_ = null;
		
		public void mousePressed(MouseEvent me ){
			mouseReleased(me);
		}
		
		public void mouseReleased(java.awt.event.MouseEvent me) {
			//get info
			//re-parse
			//re-validate
			//append sibling
			//append child
			//add attribute
			//generate dtd
			//lock tags
			//cut
			//paste
			//copy
			//format
			//undo
			//redo
			
			if (me.isPopupTrigger()) {
				JPopupMenu m = new JPopupMenu();
				int where = XmlSourceEditor.this.viewToModel(me.getPoint());
				INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(where);
				buildEditingMenuForNode(m,node);
				m.show(XmlSourceEditor.this, me.getX(), me.getY());
				//m.setVisible(true);
			}
		}
		/**
		 * @see java.awt.event.MouseMotionListener#mouseDragged(MouseEvent)
		 */
		public void mouseDragged(MouseEvent arg0) {
		}

		/**
		 * @see java.awt.event.MouseMotionListener#mouseMoved(MouseEvent)
		 */
		
	
		
		/**
		 * @see java.awt.event.MouseMotionListener#mouseMoved(MouseEvent)
		 */
		public void mouseMoved(MouseEvent arg0) {
			//helpTimer_.updateMouseLocation(arg0.getPoint());
		}

	}
	
	//private HelpTimer helpTimer_ = new HelpTimer();
	
	protected class ParseNodeAction extends javax.swing.AbstractAction {
		public void actionPerformed(java.awt.event.ActionEvent ae) {

		}

	}

	protected class InsertNodeAction extends AbstractAction {
		public String NAME = "";
		public INode parent;
		public INode child;
		public int index;

		public InsertNodeAction(INode p, INode c, int i) {
			parent = p;
			child = c;
			index = i;
			NAME = child.toString();
		}
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			boolean start = false;
			if (model_ instanceof AbstractValidatedDocument) {
				start =
					((AbstractValidatedDocument) model_)
						.autoGenerateRequiredContentIsOn();
				(
					(
						AbstractValidatedDocument) model_)
							.setAutoGenerateRequiredContent(
					true);
			}
			model_.addChild(parent, child, index, true);
			if (model_ instanceof AbstractValidatedDocument) {
				(
					(
						AbstractValidatedDocument) model_)
							.setAutoGenerateRequiredContent(
					start);
			}
		}

	}
	
	class GenerateDTDAction extends AbstractAction{
		public void actionPerformed(ActionEvent ae){
			DTDGenerator gen = new DTDGenerator();
			//String dtd = (gen.generateDTD(getXmlModel()));
			IElement first = ((DocumentRoot)getXmlModel().getRoot()).firstElement();
			//String container = "<!DOCTYPE "+first.getName()+"[\n]>";
			DTDDeclaration dtd = new DTDDeclaration(first.getName(),null,null);
			//dtd.setName(first.getName());
			gen.generateDTD((XmlDocument)getXmlModel(),dtd);
			int where = first.getParent().indexOfChild(first);
			getXmlModel().addChild(first.getParent(),dtd,where,true);
			prettyPrint();
			//int where = first.getStart();
			//getXmlModel().insertString(where,container);
			//getXmlModel().insertString(where+12+first.getName().length(),dtd);
		}
	};

	protected class SuggestionAction extends javax.swing.AbstractAction {
		private String suggestion_;
		private int start_;
		private int end_;
		private int cursorAdjustment_=0;
		public Object validContext_;

		public void actionPerformed(ActionEvent ae) {
			if(validContext_!=null &&
			 !isValidContext(validContext_)){
				return;
			}
			autoCompleteOn_=false;
			try {
				logger_.debug("SuggestionAction.actionPerformed() #########");
				if (suggestionMenu_ != null) {
					boolean start = false;
					//if (suggestionMenu_.isVisible()) {
						if (model_ instanceof AbstractValidatedDocument) {
							start = ((AbstractValidatedDocument) model_).autoGenerateRequiredContentIsOn();
							((AbstractValidatedDocument) model_).setAutoGenerateRequiredContent(true);
						}
						logger_.debug(suggestion_);
						end_ = getCaret().getDot();
						getDocument().remove(start_, (end_ - start_));
						getDocument().insertString(start_, suggestion_, null);
						if (model_ instanceof AbstractValidatedDocument) {
							(
								(
									AbstractValidatedDocument) model_)
										.setAutoGenerateRequiredContent(
								start);
						}
						if(cursorAdjustment_!=0){
							//logger_.debug("set cursor to:"+cursorAdjustment_);
							Runnable r = new Runnable(){
								public void run(){
							
							int where = start_+suggestion_.length();//getCaret().getDot();
							getCaret().setDot(where+cursorAdjustment_);	
								}};
							SwingUtilities.invokeLater(r);
						}
					//}
				}
				logger_.debug("End SuggestionAction.actionPerformed() #########");
			} catch (Exception e) {
				e.printStackTrace();
				logger_.debug(
					"unable to insert suggestion: "
						+ suggestion_
						+ " start:"
						+ start_
						+ " end:"
						+ end_,
					e);
			}
			autoCompleteOn_=true;
		}
		public void setStart(int start) {
			start_ = start;
		}
		public void setSuggestion(String suggestion) {
			suggestion_ = suggestion;
		}

		/**
		 * Returns the cursorAdjustment.
		 * @return int
		 */
		public int getCursorAdjustment() {
			return cursorAdjustment_;
		}

		/**
		 * Sets the cursorAdjustment.
		 * @param cursorAdjustment The cursorAdjustment to set
		 */
		public void setCursorAdjustment(int cursorAdjustment) {
			cursorAdjustment_ = cursorAdjustment;
		}

	}

	protected class EnterAction extends AbstractAction {

		public void actionPerformed(java.awt.event.ActionEvent ae) {
			logger_.debug("down pressed");
			if (suggestionMenu_ != null) {
				if (suggestionMenu_.isVisible()) {

					SingleSelectionModel model =
						suggestionMenu_.getSelectionModel();
					int max = suggestionMenu_.getComponentCount();
					int curr = model.getSelectedIndex();
					if (curr < 0
						|| curr >= suggestionMenu_.getComponentCount()) {
						curr = 0;
					}
					JMenuItem m =
						(JMenuItem) suggestionMenu_.getComponent(curr);
					m.doClick();
					suggestionMenu_.setVisible(false);
					suggestionMenu_ = null;
				} else {
					getActionByName(
						DefaultEditorKit.insertBreakAction).actionPerformed(
						ae);
					indentAction_.setIndex(getCaretPosition());
					indentAction_.actionPerformed(ae);
				}
			} else {
				getActionByName(
					DefaultEditorKit.insertBreakAction).actionPerformed(
					ae);
				indentAction_.setIndex(getCaretPosition());
				indentAction_.actionPerformed(ae);
			}
		}
	}

	protected class UpAction extends AbstractAction {

		public void actionPerformed(java.awt.event.ActionEvent ae) {
			logger_.debug("down pressed");
			if (suggestionMenu_ != null) {
				if (suggestionMenu_.isVisible()) {
					//	suggestionMenu_.grabFocus();
					//	suggestionMenu_.show();
					//	suggestionMenu_.setVisible(false);
					//	suggestionMenu_.setVisible(true);

					SingleSelectionModel model =
						suggestionMenu_.getSelectionModel();
					//int max = suggestionMenu_.getComponentCount();
					int curr = model.getSelectedIndex();
					//suggestionMenu_.setVisible(false);
					if (curr > 0) {
						java.awt.Component comp =
							suggestionMenu_.getComponent(curr - 1);
						//suggestionMenu_.setSelected(comp);
						model.setSelectedIndex(curr - 1);
						if (comp instanceof JMenuItem) {
							((JMenuItem) comp).setSelected(true);
						}
						MenuElement me[] = new MenuElement[2];
						me[0] = (MenuElement) suggestionMenu_;
						me[1] = suggestionMenu_.getSubElements()[curr - 1];
						MenuSelectionManager.defaultManager().setSelectedPath(
							me);
						//suggestionMenu_.repaint();
						//logger_.debug("selection set to :"+(curr + 1));
					}
					logger_.debug("focus grabbed");
				} else {
					getActionByName(DefaultEditorKit.upAction).actionPerformed(
						ae);
				}
			} else {
				getActionByName(DefaultEditorKit.upAction).actionPerformed(ae);
			}
		}
	}

	protected class DownAction extends AbstractAction {

		public void actionPerformed(java.awt.event.ActionEvent ae) {
			//Exception e = new Exception();
			//e.printStackTrace();
			logger_.debug("down pressed");
			if (suggestionMenu_ != null) {
				if (suggestionMenu_.isVisible()) {
					//	suggestionMenu_.grabFocus();
					//	suggestionMenu_.show();
					//	suggestionMenu_.setVisible(false);
					//	suggestionMenu_.setVisible(true);

					SingleSelectionModel model =
						suggestionMenu_.getSelectionModel();
					int max = suggestionMenu_.getComponentCount();
					int curr = model.getSelectedIndex();
					//suggestionMenu_.setVisible(false);
					if (curr < (max - 1)) {
						java.awt.Component comp =
							suggestionMenu_.getComponent(curr + 1);
						//suggestionMenu_.setSelected(comp);
						model.setSelectedIndex(curr + 1);
						if (comp instanceof JMenuItem) {
							((JMenuItem) comp).setSelected(true);
						}
						MenuElement me[] = new MenuElement[2];
						me[0] = (MenuElement) suggestionMenu_;
						me[1] = suggestionMenu_.getSubElements()[curr + 1];
						MenuSelectionManager.defaultManager().setSelectedPath(
							me);
						//suggestionMenu_.repaint();
						logger_.debug("selection set to :" + (curr + 1));
					}
					logger_.debug("focus grabbed");
				} else {
					getActionByName(
						DefaultEditorKit.downAction).actionPerformed(
						ae);
				}
			} else {
				getActionByName(DefaultEditorKit.downAction).actionPerformed(
					ae);
			}
		}
	}

	protected class XmlCaretListener
		implements javax.swing.event.CaretListener , Runnable{
		private Thread runner_;
		private boolean running_ = false;
		private int pos = -1;
		private INode last = null;
		
		public XmlCaretListener(){
		
				runner_ = new Thread(this);
				runner_.start();
			
		}
		
		public void run(){
			while(true){
				if(getCaret().getDot() != pos && !loading_ && getXmlModel() != null){
					pos = getCaret().getDot();
					INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(pos);
					logger_.debug("selection changed:"+node);
					if (node != null && node != last) {
						last = node;
						INode[] nodes = {node};
						for(int i = 0; i < nodeSelectionListeners_.size(); i++){
							((INodeSelectionListener)nodeSelectionListeners_.elementAt(i)).selectedNodesChanged(nodes);	
						}
						DocumentEditorStateEvent se =
						new DocumentEditorStateEvent(XmlSourceEditor.this);
						
						Hashtable data = new Hashtable(1);
						data.put(DocumentEditorStateEvent.CHANGED_NODES_KEY, nodes);
						se.setEventData(data);
						listenerManager_.fireEvent(se);
					
				}
				}
				try{
					Thread.sleep(250);
				}catch(Exception e){}
			}
		}
		
		public void caretUpdate(javax.swing.event.CaretEvent ce) {
			if (loading_) {
				return;
			}
			if(true){
				return;
			}
			IModelToSourceMapping mapping = null;
			if (getXmlModel() instanceof IModelToSourceMapping) {
				mapping = (IModelToSourceMapping) getXmlModel();
			} else {
				logger_.debug("document instanceof "+getXmlModel().getClass());
				return;
			}
			INode node = mapping.nodeAt(ce.getDot());
			logger_.debug("selection changed:"+node);
			if (node != null) {
				INode[] nodes = {node};
				for(int i = 0; i < nodeSelectionListeners_.size(); i++){
					((INodeSelectionListener)nodeSelectionListeners_.elementAt(i)).selectedNodesChanged(nodes);	
				}
				DocumentEditorStateEvent se =
					new DocumentEditorStateEvent(XmlSourceEditor.this);
				
				Hashtable data = new Hashtable(1);
				data.put(DocumentEditorStateEvent.CHANGED_NODES_KEY, nodes);
				se.setEventData(data);
				listenerManager_.fireEvent(se);
			}
			//INode node = getd
			//logger_.debug("Caret at:"+ce.get
			//int index = ce.getDot();
			//String xml = model_.toXml();
			//String el = XmlDocument.getContainingTag(xml,index);

			//String elname = XmlDocument.getTagName(el);

			//if(elname == null){return;}
			//if(currentTag_ != null){
			//String celname = XmlDocument.getTagName(currentTag_);
			//if(elname.equals(celname)){
			//return;
			//}
			//}
			//String elnamespace = XmlDocument.getTagNamespace(el);
			//logger_.debug("Current element: "+el);

			//currentTag_ = el;
			//parentTag_ = XmlDocument.getParentTag(xml,index);
			//if(el != null){
			/*
				DocumentEditorStateEvent evt=new DocumentEditorStateEvent(null);
				INode[] nodes = getSelectedNodes();
				if(nodes != null){
					if(nodes.length > 0){
						if(currentNode_ != nodes[0]){
							evt.setChangedNodes(nodes);
							evt.setType(evt.NODE_SELECTION_CHANGED);
							listenerManager_.fireEvent(evt);
						}
					}
				}
				*/

			//SourceElementSelectionEvent event = new SourceElementSelectionEvent("element-selection",this);
			//event.setElementName(elname);
			//event.setElementNamespace(elnamespace);
			//event.setXmlModel(model_);
			//listenerManager_.fireEvent(event);
			//}
		}

	};

	protected class UndoAction extends AbstractAction {
		public UndoAction() {
			super("Undo");
			setEnabled(false);
		}

		public void actionPerformed(java.awt.event.ActionEvent e) {
			logger_.debug("udo...");
			try {
				undo_.undo();
			} catch (CannotUndoException ex) {
				System.out.println("Unable to undo: " + ex);
				ex.printStackTrace();
			}
			updateUndoState();
			redoAction_.updateRedoState();
		}

		protected void updateUndoState() {
			logger_.debug("undo updated");
			if (undo_.canUndo()) {
				setEnabled(true);
				putValue(Action.NAME, undo_.getUndoPresentationName());
			} else {
				setEnabled(false);
				putValue(Action.NAME, "Undo");
			}
		}
	}

	protected class RedoAction extends AbstractAction {
		public RedoAction() {
			super("Redo");
			setEnabled(false);
		}

		public void actionPerformed(ActionEvent e) {
			try {
				undo_.redo();
			} catch (CannotRedoException ex) {
				System.out.println("Unable to redo: " + ex);
				ex.printStackTrace();
			}
			updateRedoState();
			undoAction_.updateUndoState();
		}

		protected void updateRedoState() {
			if (undo_.canRedo()) {
				setEnabled(true);
				putValue(Action.NAME, undo_.getRedoPresentationName());
			} else {
				setEnabled(false);
				putValue(Action.NAME, "Redo");
			}
		}
	}

	
	protected class XmlDocumentListener implements DocumentListener , Runnable{
		private Thread updateThread_ = new Thread(this);
		
		private Vector updateQueue_ =new Vector();
		private boolean updateRunning_ =false;
		
		public void run(){
				
			
			updateRunning_=true;
				while(updateQueue_.size()>0){
					DocumentEvent e = (DocumentEvent)updateQueue_.elementAt(0);
					updateQueue_.removeElementAt(0);
					try {
						//String key = Profiler.startw("XmlDocument.insertUpdate");
						if(e.getType() == e.getType().INSERT){
						Document doc = (Document) e.getDocument();
						int changeLength = e.getLength();
						String text = doc.getText(e.getOffset(), changeLength);
						model_.insertString(e.getOffset(), text);
						}
						else if(e.getType() == e.getType().REMOVE){
								Document doc = (Document) e.getDocument();
								int changeLength = e.getLength();

								model_.removeString(e.getOffset(), changeLength);
								//setNodeStyle(((IModelToSourceMapping)model_).nodeAfter(e.getOffset()),true);
			
						}
						else{
							Document doc = (Document) e.getDocument();
							int changeLength = e.getLength();
							String text = doc.getText(e.getOffset(), changeLength);
							model_.updateString(e.getOffset(), text);
						}
						//Profiler.endw(key);
					} catch (Exception e2) {
						logger_.debug("unable to update model", e2);
					}
				}
			updateRunning_=false;
		}
		public synchronized void queue(DocumentEvent e){
			updateQueue_.add(e);
			if(!updateRunning_){
				updateThread_.start();
			}	
		}
		
		
		public void insertUpdate(final DocumentEvent e) {
			if(suggestionMenu_ != null){
				suggestionMenu_.setVisible(false);	
			}
			if (loading_) {
				return;
			} else {
				//            	try{
				//            	String startswith = getDocument().getText(e.getOffset(),1);
				//            	if(e.getLength() > 1 ||  startswith.equals("<") || startswith.equals(">") || startswith.equals("\"")){
				//            		repaint();
				//            	}
				//            	}catch(Exception e2){}
				dirty_ = true;
			}
//			if(true){
//				queue(e);
//				SwingUtilities.invokeLater(this);
//				return;	
//			}
			Runnable r = new Runnable() {
				public void run() {
					//String k =Profiler.startw("XmlDocumentListener.insertUpdate() - autocomplete");
						//setNodeStyle(((IModelToSourceMapping)model_).nodeAt(e.getOffset()),false);
					autoComplete(e);
					//Profiler.endw(k);
					//Profiler.end("XmlDocumentListener.insertUpdate() - autocomplete");
				}
			};

			try {
				//String key = Profiler.startw("XmlDocument.insertUpdate");
				
				Document doc = (Document) e.getDocument();
				int changeLength = e.getLength();
				String text = doc.getText(e.getOffset(), changeLength);
				//String key =Profiler.startw("Update Model");
				model_.insertString(e.getOffset(), text);
				//Profiler.endw(key);
				//Profiler.endw(key);
			} catch (Exception e2) {
				logger_.debug("unable to update model", e2);
			}
			
			javax.swing.SwingUtilities.invokeLater(r);
			
			//displayEditInfo(e);
		}
		public void removeUpdate(DocumentEvent e) {
			//String key = Profiler.startw("XmlSourceEditor.removeUpdate()");
			if(suggestionMenu_ != null){
				suggestionMenu_.setVisible(false);	
			}
			if (loading_) {
				//Profiler.endw(key);
				return;
			}
			//	         try{
			//            	String startswith = ((XmlDocument)model_).getText(e.getOffset(),1);
			//            	//System.out.println("startswith:"+startswith);
			//            	if(e.getLength() > 1 ||  startswith.equals("<") || startswith.equals(">") || startswith.equals("\"")){
			//            		repaint();
			//            	}
			//            	}catch(Exception e2){}
			dirty_ = true;
			//  displayEditInfo(e);
//			if(true){
//				queue(e);	
//				return;
//			}
			try {
				Document doc = (Document) e.getDocument();
				int changeLength = e.getLength();

				model_.removeString(e.getOffset(), changeLength);
				//setNodeStyle(((IModelToSourceMapping)model_).nodeAfter(e.getOffset()),true);
			} catch (Exception e2) {
				logger_.debug("unable to update model", e2);
			}
			//Profiler.endw(key);
		}
		public void changedUpdate(DocumentEvent e) {
			if (loading_) {
				return;
			}
			dirty_ = true;
//			if(true){
//				queue(e);	
//				return;
//			}
			
			//   displayEditInfo(e);
			//	Runnable autoComplete(e);
			try {
				Document doc = (Document) e.getDocument();
				int changeLength = e.getLength();
				String text = doc.getText(e.getOffset(), changeLength);
				model_.updateString(e.getOffset(), text);
			} catch (Exception e2) {
				logger_.debug("unable to update model", e2);
			}
		}
		private void displayEditInfo(DocumentEvent e) {
			//Document doc = (Document)e.getDocument();
			//int changeLength = e.getLength();
			//changeLog.append(e.getType().toString() + ": "
			//+ changeLength + " character"
			//+ ((changeLength == 1) ? ". " : "s. ")
			//+ " Text length = " + doc.getLength()
			//+ "." + newline);
		}
		
		private void autoComplete(DocumentEvent e) {
			if (!autoCompleteOn_) {
				return;
			}
			try{
			if(true){
				if(suggestionMenu_!=null && suggestionMenu_.getComponentCount()>0){
					suggestionMenu_.removeAll();
					validContext_=null;	
				}
				//this whole context object crap is a bad hack
				//to get around this bizarre bug where old suggestion actions
				//get triggered by the spacebar
				String contextobj = ""+System.currentTimeMillis();
				validContext_=contextobj;
				
				//Profiler.start("XmlDocumentListner.autocomplete - new");	
				INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(e.getOffset());
				
				String ntext = getDocument().getText(e.getOffset(),e.getLength());
				if(node instanceof IScratchTag){
					
					IScratchTag stag = (IScratchTag)node;
					String text = stag.getText();
					int rindex = e.getOffset()-stag.getStart();
					int aindex = text.indexOf(" ");	
					if((stag.getCurrentState() == ScratchTag.OPEN_STATE || stag.getCurrentState()==ScratchTag.CLOSED_STATE) && ntext.indexOf(">")<0 
					    && rindex> aindex && aindex > -1 && !ntext.startsWith(" ")){
					
					
					
					//if( rindex> aindex && aindex > -1 && !ntext.startsWith(" ")){
						String tname = text.substring(1,aindex);
						int nsindex = tname.indexOf(":");
						String ns = null;
						if(nsindex > -1){
							ns =tname.substring(0,nsindex);
							ns = model_.getNamespaceURI(ns);
							tname = tname.substring(nsindex+1);
						}
						logger_.debug("getting structure for "+tname+" "+ns);
						IElementStructure str= model_.getElementStructure(tname,ns);
						if(str != null){
							int start = text.lastIndexOf(" ",rindex);
							int end = text.indexOf(" ",rindex+1);
							if(end < 0){
								end = text.length();
								if(stag.getCurrentState()==ScratchTag.CLOSED_STATE){
									end--;
								}
							}
							String attr=text.substring(start+1,end).trim();
							logger_.debug("looking for attributes that start with "+attr);
							Vector suggestions = new Vector();
						
							for(int i = 0; i<str.attributeCount(); i++){
								if(str.attributeAt(i).startsWith(attr)){
									SuggestionAction suggest = new SuggestionAction();
									suggest.validContext_=contextobj;
									suggest.suggestion_=str.attributeAt(i)+"=\"\"";//.substring(attr.length())+"=\"\"";
									suggest.cursorAdjustment_=-1;
									suggest.start_=start+1+stag.getStart();//end+stag.getStart();
									suggest.end_=end+stag.getStart();
									suggest.putValue(AbstractAction.NAME, str.attributeAt(i));
									suggestions.add(suggest);
								}
							}
							logger_.debug("found "+suggestions.size()+" matches");
							if(suggestions.size()>0){
								SuggestionAction[] acts = (SuggestionAction[])suggestions.toArray(new SuggestionAction[0]);
								showSuggestionMenu(
										((DefaultCaret) getCaret()).x,
										((DefaultCaret) getCaret()).y,
										acts);
							}
						}
					}			
					//}
					else if(stag.getCurrentState() == ScratchTag.OPEN_STATE && stag.getParent() instanceof IElement){
						String name = stag.getText().substring(1).trim();
						String ns = null;
						int nsindex = name.indexOf(":");
						String prefix = null;
						if(nsindex>0){
							prefix = name.substring(0,nsindex);
							ns = getXmlModel().getNamespaceURI(prefix);
							name = name.substring(nsindex+1);
						}
						//if(!(stag.getParent() instanceof IElement)){return;}
						IElement parent = (IElement)stag.getParent();
						IElementStructure[] struct = listPossibleElements((IElement)stag.getParent(),name,ns);
						if(struct != null){
							String[] elnames = new String[struct.length];
							String[] disp = new String[struct.length];
							SuggestionAction[] acts = new SuggestionAction[struct.length];
							for(int i = 0; i < elnames.length; i++){
								String sugstart = null;
								String sugend = null;
								String display = null;
								if(struct[i]==null){
									continue;
								}
								if(struct[i].getNamespace() != null && prefix == null){
									String pre = ((XmlDocument)getXmlModel()).getPrefixForNamespace(struct[i].getNamespace());
									
									
									if(pre != null && pre.trim().length()>0){
//										elnames[i] = pre+":"+struct[i].getName()+"></"+pre+":"+struct[i].getName()+">";
//										disp[i] = pre+":"+struct[i].getName();
										
										display  = pre+":"+struct[i].getName();
										sugstart = pre+":"+struct[i].getName()+">";
										sugend = "</"+pre+":"+struct[i].getName()+">";
										
									}
									else{
										if(struct[i].getNamespace().equals(ns) || struct[i].getNamespace().equals(parent.getDefaultNamespace())){
											sugstart = struct[i].getName()+">";
										}else{
										sugstart = struct[i].getName()+" xmlns=\""+struct[i].getNamespace()+"\">";
										}
										sugend = "</"+struct[i].getName()+">";
										display = struct[i].getName()+" xmlns=\""+struct[i].getNamespace();
										//elnames[i] = struct[i].getName()+" xmlns=\""+struct[i].getNameSpace()+"\"></"+struct[i].getName()+">";
										//disp[i] = struct[i].getName()+" xmlns=\""+struct[i].getNameSpace();
									}
				
								}
								else if(prefix != null){

									display  = prefix+":"+struct[i].getName();
									sugstart = prefix+":"+struct[i].getName()+">";
									sugend = "</"+prefix+":"+struct[i].getName()+">";
								}								
								else{
									sugstart = struct[i].getName()+">";
									sugend = "</"+struct[i].getName()+">";
									display = struct[i].getName();
									//elnames[i] = struct[i].getName()+"></"+struct[i].getName()+">";
									//disp[i] = struct[i].getName();
								}	
								acts[i] = new SuggestionAction();
								acts[i].validContext_=contextobj;
								acts[i].setStart(stag.getStart()+1);
								acts[i].setSuggestion(sugstart+sugend);
								acts[i].setCursorAdjustment(-1*(sugend.length()));
								acts[i].putValue(AbstractAction.NAME,display);
							}
							showSuggestionMenu(
											((DefaultCaret) getCaret()).x,
											((DefaultCaret) getCaret()).y,
											acts);	
						}
					}
					else if(stag.getCurrentState() == ScratchTag.CLOSED_STATE){
						if(stag.getTagInfo() != null  && ntext.equals(">") ){
							ITagInfo info = stag.getTagInfo();
							if(info.getType() == info.START_TAG && info.isValid()){
								final int where = stag.getStart()+stag.getLength();
								String endtag="</"+info.getName()+">";
								model_.insertString(where,endtag);	
								Runnable r = new Runnable(){
									public void run(){
										
										getCaret().setDot(where);
									}
								};
								SwingUtilities.invokeLater(r);
							}							
						}
					}
					
				}
				
			//	Profiler.end("XmlDocumentListner.autocomplete - new");
				return;
			}
			
			}catch(Exception e2){
				e2.printStackTrace();	
			}
			/*
			try {
				String wkey = Profiler.startw("XmlDocumentListener.autocomplete()");
				// logger_.debug("text at autocomplete:\n"+getText());
				Profiler.start("XmlDocumentListener.autocomplete() - setup");
				Document doc = (Document) e.getDocument();
				int changeLength = e.getLength();
				String text = doc.getText(e.getOffset(), changeLength);
				logger_.debug("Update:" + text);
				if (text.trim().length() < 1) {
					if (suggestionMenu_ != null) {
						suggestionMenu_.setVisible(false);
						suggestionMenu_ = null;
					}
					return;
				}
				String textbefore = doc.getText(0, e.getOffset());
				String textAfter =
					doc.getText(
						e.getOffset() + 1,
						(doc.getLength() - e.getOffset()));
				boolean insidetag = false;
				int lastopentag = textbefore.lastIndexOf("<");
				int lastclosetag = textbefore.lastIndexOf(">");
				insidetag = (lastopentag > lastclosetag);
				if (text.startsWith("\"")
					|| text.startsWith("<")
					|| text.startsWith("!")
					|| text.startsWith("&")
					|| text.startsWith(">")
					|| text.startsWith("?")) {
					repaint();
				}
				Profiler.end("XmlDocumentListener.autocomplete() - setup");
				if (changeLength < 2) {
					if (text.startsWith("<") || text.startsWith(">")) {
						// revalidate();
						//repaint();
						if (text.startsWith(">")) {
							if (suggestionMenu_ != null) {
								if (suggestionMenu_.isVisible()) {
									suggestionMenu_.setVisible(false);
								}
							}

							if (insidetag) {
								//do an autocomplete
								if (textbefore.charAt(lastopentag + 1) == '/'
									|| textbefore.charAt(lastopentag + 1) == '?'
									|| textbefore.charAt(lastopentag + 1) == '!'
									|| textbefore.trim().endsWith("/")) {
									if (textbefore.charAt(lastopentag + 1)
										== '?') {
										//complete a pi
										//doc.setCharacterAttributes(
										//lastopentag,
										//(e.getOffset() - lastopentag + 1),
										//processingInstructionStyle_,
										//true);
									}
									if (textbefore.charAt(lastopentag + 1)
										== '!') {
										//complete either a comment or a DTDElementDecl
										if (textbefore.charAt(lastopentag + 2)
											== '-') {
											//doc.setCharacterAttributes(
											//lastopentag,
											//(e.getOffset() - lastopentag + 1),
											//commentStyle_,
											//true);
										} else {
											//doc.setCharacterAttributes(
											//lastopentag,
											//(e.getOffset() - lastopentag + 1),
											//dtdElementStyle_,
											//true);
										}
									}
									if (textbefore.charAt(lastopentag + 1)
										== '/') {
										//complete an element
										//                                        ((StyledDocument)doc).setCharacterAttributes(
										//                                            lastopentag,
										//                                            (e.getOffset() - lastopentag + 1),
										//                                            elementStyle_,
										//                                            true);
									}
								} else {
									//do an autocomplete
									String element =
										doc
											.getText(
												lastopentag + 1,
												(e.getOffset()
													- lastopentag
													- 1))
											.trim();
									int start = element.indexOf(" ");
									if (start < 0) {
										start = element.length();
									}
									element = element.substring(0, start);

									int nextOpenTag = textAfter.indexOf("<");
									int nextEndTag = textAfter.indexOf(">");
									//don't autocomplete if this tag is ended
									int startcount = 0;
									int currindex = 0;

									/*
									String searchstr = "<" + element;
									//   logger_.debug("Searching:"+textAfter);
									// logger_.debug("StartTag:"+searchstr);
									while ((currindex = textAfter.indexOf(searchstr, currindex)) > -1) {
									    startcount++;
									    currindex += searchstr.length();
									}
									int endcount = 0;
									currindex = 0;
									searchstr = "</" + element + ">";
									//       logger_.debug("EndTag:"+searchstr);
									
									while ((currindex = textAfter.indexOf(searchstr, currindex)) > -1) {
									
									    endcount++;
									    currindex += searchstr.length();
									}
									*/
								/*	//            logger_.debug("Endcount:"+endcount+" Startcount:"+startcount);
									if (!butterfly
										.xmlview
										.model
										.XmlUtilities
										.tagIsMatched(
											getText(),
											e.getOffset())) {
										String tag = "</" + element + ">";
										//doc.setCharacterAttributes(
										//lastopentag,
										//(e.getOffset() - lastopentag + 1),
										//elementStyle_,
										//true);
										doc.insertString(
											e.getOffset() + 1,
											tag,
											null);

										setCaretPosition(e.getOffset() + 1);

									} else {
										//  doc.setCharacterAttributes(
										//      lastopentag,
										//      (e.getOffset() - lastopentag + 1),
										//      elementStyle_,
										//       true);
									}
								}
								loading_ = true;
								// getXmlModel().removeDocumentListener(innerParent_);
								//getXmlModel().updateModel();
								// getXmlModel().addDocumentListener(innerParent_);
								loading_ = false;
							} else {
								//error can't have > without <
								//  doc.setCharacterAttributes(e.getOffset(),1,errorStyle_,true);
							}
						} else {
							Profiler.start("XmlDocumentListener.autocomplete() - lastlt lastgt");
							int nextlt = textAfter.indexOf("<");
							int nextgt = textAfter.indexOf(">");
							Profiler.end("XmlDocumentListener.autocomplete() - lastlt lastgt");
							if (insidetag || (nextlt > nextgt)) {
								//error can't have < inside a tag
								// doc.setCharacterAttributes(e.getOffset(),1,errorStyle_,true);
							} else {
								Profiler.start("XmlDocumentListener.autocomplete() - <....");
								//open a tag...show possible values
								//  doc.setCharacterAttributes(e.getOffset(),1,elementStyle_,true);
								int lt = textbefore.lastIndexOf("<");
								INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(e.getOffset());
								if(!(node.getParent() instanceof IElement)){
									return;
								}
								String parent = node.getParent().toString();
//									butterfly
//										.xmlview
//										.model
//										.XmlUtilities
//										.getParentTag(
//										getText(),
//										e.getOffset());
								logger_.debug("parent:" + parent);
								String srch = null;
								IElementStructure[] struct = null;
								INode pnode = ((IModelToSourceMapping)getXmlModel()).nodeAt(e.getOffset());
								if(pnode != null){
									if(pnode.getParent() instanceof IElement){
										
										struct = listPossibleElements((IElement)pnode.getParent(),"",null);
									}	
								}
								else if (parent != null) {
//									parent =
//										butterfly
//											.xmlview
//											.model
//											.XmlUtilities
//											.getRawTagName(
//											parent);
//									//srch = textbefore.substring(lt + 1)+text;
//									struct = listPossibleElements(parent, "");
								} else {
									//srch = textbefore.substring(lt + 1)+text;
									struct = listPossibleElements("");
								}
								//logger_.debug("Possible Elements ##############");
								if (struct != null) {
									String[] elnames =
										new String[struct.length];
									for (int i = 0; i < struct.length; i++) {
										logger_.debug(
											"Possible Element: "
												+ struct[i].getName());
										elnames[i] = struct[i].getName();
									}
									if (elnames.length > 0) {
										//										INode curr = ((IModelToSourceMapping)model_).nodeAt(e.getOffset());
										//										if(curr != null){
										//											INode p = curr.getParent();
										//											int cindex = p.indexOfChild(curr);
										//											showElementSuggestionMenu(((DefaultCaret)getCaret()).x,((DefaultCaret)getCaret()).y,p,cindex,elnames);
										//										}
										//										else{
										//Point p = getCaret().getMagicCaretPosition();
										//logger_.debug("Caret mark: "+getCaret().getDot());
										logger_.debug(
											"Caret at: "
												+ ((DefaultCaret) getCaret()).x
												+ ","
												+ ((DefaultCaret) getCaret()).y);
										//	logger_.debug("caret position: "+p);
										showSuggestionMenu(
											((DefaultCaret) getCaret()).x,
											((DefaultCaret) getCaret()).y,
											e.getOffset(),
											elnames,true);
										//										}
									}
								}
								Profiler.end("XmlDocumentListener.autocomplete() - <....");

							}
						}
					} else {
						logger_.debug("INSIDETAG:" + insidetag);
						if (insidetag) {
							boolean normaltag = true;
							if (textbefore.lastIndexOf("!--") > lastopentag) {
								normaltag = false;
								//inside a comment tag
								///  doc.setCharacterAttributes(e.getOffset(),1,commentStyle_,true);
							}
							if (textbefore
								.substring(lastopentag + 1)
								.trim()
								.startsWith("?")) {
								normaltag = false;
								//inside processing instruction
								//  doc.setCharacterAttributes(e.getOffset(),1,processingInstructionStyle_,true);
							}
							if (normaltag) {
								Profiler.start("XmlDocumentListener.autocomplete - end check");
								int space = textbefore.lastIndexOf(" ");
								int lt = textbefore.lastIndexOf("<");
								if (lt >= 0
									&& textbefore
										.substring(lt + 1)
										.trim()
										.startsWith(
										"/")) {
									lt += 1;
								}
								Profiler.end("XmlDocumentListener.autocomplete() - lastlt lastgt");
								logger_.debug("text=" + text);
								logger_.debug("event_at" + e.getOffset());
								logger_.debug("lt:" + lt);
								logger_.debug("space:" + space);
								if (!text.equals(" ")) {
									if (space < lt) {
									Profiler.start("XmlDocumentListener.autocomplete() - find parent");
										String parent =
											butterfly
												.xmlview
												.model
												.XmlUtilities
												.getParentTag(
												getText(),
												e.getOffset());
										logger_.debug("parent:" + parent);
										String srch = null;
									Profiler.end("XmlDocumentListener.autocomplete() - find parent");
										IElementStructure[] struct = null;
									Profiler.start("XmlDocumentListener.autocomplete() - create search");	
										if (parent != null) {
											parent =
												butterfly
													.xmlview
													.model
													.XmlUtilities
													.getRawTagName(
													parent);
											srch =
												textbefore.substring(lt + 1)
													+ text;
											struct =
												listPossibleElements(
													parent,
													srch);
										} else {
											srch =
												textbefore.substring(lt + 1)
													+ text;
											struct = listPossibleElements(srch);
										}
										Profiler.end("XmlDocumentListener.autocomplete() - create search");
										//logger_.debug("Possible Elements ##############");
										Profiler.start("XmlDocumentListener.autocomplete() - list ");
										if (struct != null) {
											String[] elnames =
												new String[struct.length];
											for (int i = 0;
												i < struct.length;
												i++) {
												logger_.debug(
													"Possible Element: "
														+ struct[i].getName());
												elnames[i] =
													struct[i].getName();
											}
											if (elnames.length > 0) {
												//										INode curr = ((IModelToSourceMapping)model_).nodeAt(e.getOffset());
												//										if(curr != null){
												//											INode p = curr.getParent();
												//											int cindex = p.indexOfChild(curr);
												//											showElementSuggestionMenu(((DefaultCaret)getCaret()).x,((DefaultCaret)getCaret()).y,p,cindex,elnames);
												//										}
												//										else{
												logger_.debug("curr was null");
												//Point p = getCaret().getMagicCaretPosition();
												//logger_.debug("Caret mark: "+getCaret().getDot());
												//	logger_.debug("Caret at: "+((DefaultCaret)getCaret()).x+","+((DefaultCaret)getCaret()).y);
												//	logger_.debug("caret position: "+p);
												showSuggestionMenu(
													(
														(DefaultCaret) getCaret())
															.x,
													(
														(DefaultCaret) getCaret())
															.y,
													lt,
													elnames,true);
												//										}
											}
											
										}
										Profiler.end("XmlDocumentListener.autocomplete() - list ");
									} else {
										if (text.equals("=")
											|| text.equals("\"")
											|| text.equals("'")
											|| text.equals("?")
											|| text.equals(":")
											|| text.equals("|")
											|| text.equals("/")) {

										} else {
											int firstspace =
												textbefore.indexOf(" ", lt);
											String elname =
												textbefore.substring(
													lt + 1,
													firstspace);
											IElementStructure struct =
												model_.getElementStructure(
													elname,
													"");
											if (struct != null) {
												String srch =
													textbefore.substring(
														space + 1)
														+ text;
												//logger_.debug("textbefore->"+textbefore+"<--");
												logger_.debug("space:" + space);
												String[] attrs =
													listPossibleAttributes(
														struct,
														srch);
												logger_.debug(
													"Possible Attributes #############");
												if (attrs != null) {
													for (int i = 0;
														i < attrs.length;
														i++) {
														logger_.debug(
															"Possible Attribute: "
																+ attrs[i]);
													}
													showSuggestionMenu(
														(
															(DefaultCaret) getCaret())
																.x,
														(
															(DefaultCaret) getCaret())
																.y,
														space,
														attrs);
												}
											}
										}
									}
								}
								//editing a normal tag
								//  doc.setCharacterAttributes(e.getOffset(),1,elementStyle_,true);
							}
						} else {
							if (textbefore.indexOf("<") < 0) {
								//error can't put text outside of an element
								// doc.setCharacterAttributes(e.getOffset(),1,errorStyle_,true);
							} else {
								//editing text values between tags
								//  doc.setCharacterAttributes(e.getOffset(),1,valueStyle_,true);
							}

						}

					}

				} else {
					if (!(text.indexOf(">") > -1)
						&& !(text.indexOf(">") > -1)) {
						if (insidetag) {
							boolean normaltag = true;
							if (textbefore.lastIndexOf("!--") > lastopentag) {
								normaltag = false;
								//inside a comment tag
								// doc.setCharacterAttributes(e.getOffset(),e.getLength(),commentStyle_,true);
							}
							if (textbefore
								.substring(lastopentag + 1)
								.trim()
								.startsWith("?")) {
								normaltag = false;
								//inside processing instruction
								//  doc.setCharacterAttributes(e.getOffset(),e.getLength(),processingInstructionStyle_,true);
							}
							if (normaltag) {
								//editing a normal tag
								//  doc.setCharacterAttributes(e.getOffset(),e.getLength(),elementStyle_,true);
							}
						} else {
							if (textbefore.indexOf("<") < 0) {
								//error can't put text outside of an element
								//  doc.setCharacterAttributes(e.getOffset(),e.getLength(),errorStyle_,true);
							} else {
								//editing text values between tags
								//   doc.setCharacterAttributes(e.getOffset(),e.getLength(),valueStyle_,true);
							}

						}
					}
				}

				/*Old version
				INode node = (INode)doc.getCharacterElement(e.getOffset()).getAttributes().getAttribute(XmlTextLoader.NODE_ATTRIBUTE_KEY);
				if(node != null){
					logger_.debug("characters belong to:"+node.toString());
				}
				else{
					if(changeLength < 2 && !text.startsWith("<")){
						if(e.getOffset() > 0){
							String btext = doc.getText(e.getOffset() - 1,1);
							if(!btext.startsWith(">")){
				
								doc.setCharacterAttributes(e.getOffset(),changeLength,doc.getCharacterElement(e.getOffset()).getAttributes(),true);
							   	node = (INode)doc.getCharacterElement(e.getOffset()).getAttributes().getAttribute(XmlTextLoader.NODE_ATTRIBUTE_KEY);
							   	logger_.debug("characters now belong to:"+node);
							}
							
						}
					}
					else{
						logger_.debug("no node found");
					}
				}
				
				
				
				String before = "";
				if(e.getOffset() > 1){
				    int length = 5;
				    if(e.getOffset() < 6){
						length = 1;
				    }
					before = doc.getText(e.getOffset() - length,length);
				}
				int begin = e.getOffset();
				if (text.startsWith("<")) {
				    //at some point...probably want to show options of possible values
				    if (structureAnalyzer_ != null) {
				
				    }
				}
				if (text.startsWith(">") && !before.trim().endsWith("-")) {
				    int coffset = e.getOffset();
				    int offset = coffset - 300;
				    if (offset < 0) {
				        offset = 0;
				    }
				    String last = doc.getText(offset, coffset - offset);
				    int start = last.lastIndexOf("<");
				    int lastlt = start + offset;
				
				    if (start > last.lastIndexOf(">")
				        && start > (last.lastIndexOf("</") + 1)
				        && start > (last.lastIndexOf("< /") + 2)) {
				        //System.out.println("start:"+start+" coffset:"+coffset+" length:"+(coffset - (start + 1)));
				        String element = last.substring(start + 1).trim();
				        start = element.indexOf(" ");
				        if (start < 0) {
				            start = element.length();
				        }
				        element = element.substring(0, start);
				        String tag = "</" + element + ">";
				        logger_.debug(
				            "last < at " + lastlt + " event at " + begin + " since " + (begin - lastlt));
				        doc.setCharacterAttributes(lastlt, (begin - lastlt), tagStyle_, true);
				        doc.insertString(coffset + 1, tag, tagStyle_);
				        setCaretPosition(coffset + 1);
				    }
				
				} else {
				    if (!text.startsWith("<")) {
				        int coffset = e.getOffset();
				        int offset = coffset - 300;
				        if (offset < 0) {
				            offset = 0;
				        }
				        String last = doc.getText(offset, coffset - offset);
				        int start = last.lastIndexOf("<!--");
				        int endc = last.lastIndexOf("-->");
				        int lastc = start + offset;
				        if(endc >= start){
				        	doc.setCharacterAttributes(begin, changeLength, textStyle_, true);
				        }
				        else{
							doc.setCharacterAttributes(lastc, (begin + changeLength - lastc), commentStyle_, true);
				        }
				    } else {
				
				    }
				}
				
				Profiler.endw(wkey);
			} catch (Exception e2) {
				logger_.warn("problem with autocomplete");
				e2.printStackTrace();
			}*/
		}
	}

	protected class XmlUndoableEditListener implements UndoableEditListener {
		public void undoableEditHappened(UndoableEditEvent e) {
			logger_.debug("edit happened");
			//Remember the edit and update the menus
			undo_.addEdit(e.getEdit());
			undoAction_.updateUndoState();
			redoAction_.updateRedoState();
		}
	}
	private Vector nodeSelectionListeners_ = new Vector(1);
	private boolean autoCompleteOn_ = true;
	private XmlCaretListener caretListener_;
	private IXmlDocument model_;
	private XmlDocumentListener docListener_;
	private static Logger logger_ = Logger.getLogger(XmlSourceEditor.class);
	private Hashtable actions_ = new Hashtable(5);
	private IndentNodeAction indentAction_=new IndentNodeAction();
	private UndoManager undo_ = new UndoManager();
	private UndoAction undoAction_ = new UndoAction();
	private RedoAction redoAction_ = new RedoAction();
	
	private XmlDocumentSourceListener sourceListener_ =
		new XmlDocumentSourceListener();
	private boolean dirty_;
	private boolean loading_ = true;
	private boolean rebuildElementStructures_ = true;
	private JPopupMenu suggestionMenu_;
	private String currentTag_;
	private String parentTag_;
	private XmlSourceEditor innerParent_;
	private SimpleAttributeSet elementStyle_;
	private XmlCorrectionListener correctionListener_=new XmlCorrectionListener();
	//private Corrector corrector_ = new Corrector();
	private INode currentNode_;
	private Style errorStyle_;
	private Style warningStyle_;
	private Style incompleteElementStyle_;
	private Style unmatchedElementStyle_;
	private Style dtdElementStyle_;
	private Style commentStyle_;
	private Style whiteSpaceStyle_;
	private Style documentDeclarationStyle_;
	private Style valueStyle_;
	
	private DeclarePrefixAction[] commonPrefixes_=new DeclarePrefixAction[]{
		new DeclarePrefixAction("docbook","?"),
		new DeclarePrefixAction("math","http://www.w3.org/1998/Math/MathML"),
		new DeclarePrefixAction("svg","http://www.w3.org/2000/svg"),
		new DeclarePrefixAction("xhtml","http://www.w3.org/1999/xhtml"),
		new DeclarePrefixAction("xlink","http://www.w3.org/1999/xlink"),
		new DeclarePrefixAction("xsl","http://www.w3.org/1999/XSL/Transform"),
		};
	
	private Object validContext_;
	private XmlTidyAction tidy_;
	private DeclarePrefixAction declarePrefixAction_;
	private Style processingInstructionStyle_;
	private MarkerListener markerListener_;
	private StateListenerManager listenerManager_ = new StateListenerManager();
	/**
	 * XmlSourceEditor constructor comment.
	 */
	public XmlSourceEditor() {
		super();
		//setDocument(new XmlStyleDocument());
		//elementStyle_ = new SimpleAttributeSet();
		//StyleConstants.setForeground(elementStyle_,new Color(100,100,255));
		XmlEditorKit kit = new XmlEditorKit();
		setEditorKitForContentType("text/xml", kit);
		
		docListener_ = new XmlDocumentListener();
		caretListener_ = new XmlCaretListener();
		markerListener_ = new MarkerListener();
		getDocument().addDocumentListener(docListener_);
		setToolTipText("XML Editor");
		addCaretListener(caretListener_);
		
		createActionTable();
		innerParent_ = this;
		EditorMouseListener eml = new EditorMouseListener();
		addMouseListener(eml);
		addMouseMotionListener(eml);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/13/2002 11:27:58 PM)
	 * @param l butterfly.statemachine.interfaces.IStateEventListener
	 */
	public void addStateEventListener(
		butterfly.statemachine.interfaces.IStateEventListener l) {
		listenerManager_.addListener(l);
	}
	private void createActionTable() {
		actions_ = new Hashtable();

		Action[] actionsArray = getActions();
		for (int i = 0; i < actionsArray.length; i++) {
			Action a = actionsArray[i];
			actions_.put(a.getValue(Action.NAME), a);
		}

		//getKeymap().removeBindings();
		Keymap keymap = addKeymap("XmlKeyBindings", getKeymap());

		undoAction_ = new UndoAction();
		KeyStroke ykey = KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK);
		keymap.addActionForKeyStroke(ykey, undoAction_);

		KeyStroke prettyprint =
			KeyStroke.getKeyStroke(KeyEvent.VK_J, Event.CTRL_MASK);
		tidy_ = new XmlTidyAction();
		keymap.addActionForKeyStroke(prettyprint, tidy_);

		KeyStroke test = KeyStroke.getKeyStroke(KeyEvent.VK_I, Event.CTRL_MASK);
		keymap.addActionForKeyStroke(test, new ShowNodeAction());

		redoAction_ = new RedoAction();
		KeyStroke zkey =
			KeyStroke.getKeyStroke(KeyEvent.VK_Y, KeyEvent.CTRL_MASK);
		keymap.addActionForKeyStroke(zkey, redoAction_);

		getDocument().addUndoableEditListener(new XmlUndoableEditListener());

		KeyStroke dkey = KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0);
		keymap.addActionForKeyStroke(dkey, new DownAction());

		KeyStroke ukey = KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0);
		keymap.addActionForKeyStroke(ukey, new UpAction());

		KeyStroke ekey = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
		keymap.addActionForKeyStroke(ekey, new EnterAction());
		
		KeyStroke autoc = KeyStroke.getKeyStroke(KeyEvent.VK_SPACE,KeyEvent.CTRL_MASK);
		keymap.addActionForKeyStroke(autoc,new CorrectAction());
		
		KeyStroke gl = KeyStroke.getKeyStroke(KeyEvent.VK_L,KeyEvent.CTRL_MASK);
		keymap.addActionForKeyStroke(gl,new GoToLineAction());
//		KeyStroke rkey = KeyStroke.getKeyStroke(KeyEvent.VK_R, 0);
//		keymap.addActionForKeyStroke(rkey, new RefreshAction());
		
		KeyStroke tabkey = KeyStroke.getKeyStroke(KeyEvent.VK_TAB,0);
		keymap.addActionForKeyStroke(tabkey,
				new AbstractAction(){
					public void actionPerformed(ActionEvent ae){
						indentAction_.setIndex(getCaretPosition());
						indentAction_.actionPerformed(ae);
					}
				}
		
		);
		
		setKeymap(keymap);
		
		
		declarePrefixAction_=(DeclarePrefixAction)ButterflyApplication.getInstance().getAction("butterfly.actions.DeclarePrefixAction");
	}
	
	public void prettyPrint(){
		tidy_.actionPerformed(null);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/1/2002 1:56:49 PM)
	 * @param node butterfly.xmlview.model.interfaces.INode
	 */
	public void focusOnNode(INode node) {
		requestFocus();
		if (node instanceof ISourceNode) {

			int start = ((ISourceNode) node).getStart();
			int length = ((ISourceNode) node).getLength();
			if(start > -1 && length > -1){
				getCaret().setDot(start);
				getCaret().moveDot(start + length);
			}
		} 
	}
	private Action getActionByName(String name) {
		return (Action) (actions_.get(name));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/14/2002 7:07:22 PM)
	 * @return butterfly.statemachine.StateListenerManager
	 */
	public butterfly.statemachine.StateListenerManager getListenerManager() {
		return listenerManager_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/17/2002 6:48:56 PM)
	 * @return java.lang.String
	 */
	public java.lang.String getParentTag() {
		return parentTag_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/1/2002 1:58:17 PM)
	 * @return butterfly.xmlview.model.interfaces.INode[]
	 */
	public INode[] getSelectedNodes() {
		//String xpath = getSelectedTagXPath();
		//logger_.debug("currently selected node: " + xpath);
		INode[] nodes = {((IModelToSourceMapping)getXmlModel()).nodeAt(getCaret().getDot()) };//getXmlModel().getNodeWithXPath(xpath)};
		return nodes;
	}
	private Style getStyle(INode node) {
		return null;
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/15/2002 11:36:33 PM)
	 * @return XmlDocument
	 */
	public IXmlDocument getXmlModel() {
		//try{
		//IXmlDocument oldm = model_;
		//model_ = new XmlDocument(getText());
		//model_.setSourceFileName(oldm.getSourceFileName());
		//}catch(Exception e){
		//logger_.debug("The xml from the source pane was not valid.",e);
		//return (new XmlSourceDocument(getText()));
		//}
		//model_.setDirty(true);
		return model_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/23/2002 5:30:59 PM)
	 * @param evt butterfly.xmlview.model.interfaces.IDocumentEvent
	 */
	public void handleDocumentEvent(
		final butterfly.xmlview.model.interfaces.IDocumentEvent evt) {
		//if(loading_){return;}
		//logger_.debug("updating document source");
		//loading_ =true;
		//int pos = getCaret().getDot();
		//if(pos < 0){
		//pos = 0;
		//}
		//setText(model_.toXml());
		//if(getText().length() < pos){
		//pos = getText().length();
		//}
		//getCaret().setDot(pos);
		//loading_ = false;		
		if(evt.getType()==evt.NODES_REMOVED){
			markerView_.handleDocumentEvent(evt);
		}
		if (evt.getType() == evt.NODES_ADDED
			|| evt.getType() == evt.NODES_REMOVED) {
			repaint();
		}
		//	Runnable r = new Runnable(){
		//		public void run(){
		//			setNodeStyle(evt.getChangedNode(),false);
		//		}
		//	};
		//	SwingUtilities.invokeLater(r);
		//	}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/4/2002 9:43:01 PM)
	 * @param pos int
	 * @param str java.lang.String
	 */
	public void insertString(int pos, String str) throws Exception {

		//model_.insertString(pos, str);
		getDocument().insertString(pos, str, null);
	}
	/**
	 * Invoked when a key has been pressed.
	 */
	public void keyPressed(java.awt.event.KeyEvent e) {
		logger_.debug("" + e.getKeyChar() + " pressed");
		if (e.getKeyCode() != KeyEvent.VK_DOWN
			&& e.getKeyCode() != KeyEvent.VK_UP
			&& e.getKeyCode() != KeyEvent.VK_ENTER) {
			this.processComponentKeyEvent(e);
			return;
		}
		if (e.getKeyCode() == KeyEvent.VK_SPACE) {
			logger_.debug("hiding menu");
			suggestionMenu_.setVisible(false);
		}
		//	if(e.getKeyCode() == KeyEvent.VK_ && (e.getModifiersEx() & KeyEvent.CTRL_DOWN_MASK) == KeyEvent.CTRL_DOWN_MASK){
		//		logger_.debug("undo");
		//	}
		//	else{
		logger_.debug("key " + e.getKeyCode() + " mods" + e.getModifiersEx());
		//	}
	}
	/**
	 * Invoked when a key has been released.
	 */
	public void keyReleased(java.awt.event.KeyEvent e) {
	}
	/**
	 * Invoked when a key has been typed.
	 * This event occurs when a key press is followed by a key release.
	 */
	public void keyTyped(java.awt.event.KeyEvent e) {
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/6/2002 8:47:47 PM)
	 * @return butterfly.xmlview.model.interfaces.IElementStructure[]
	 * @param srch java.lang.String
	 */
	private String[] listPossibleAttributes(
		IElementStructure struct,
		String srch) {
		Vector results = new Vector();
		logger_.debug("Searchstr: " + srch);
		for (int i = 0; i < struct.attributeCount(); i++) {
			logger_.debug("checking " + struct.attributeAt(i));
			if (struct
				.attributeAt(i)
				.toLowerCase()
				.startsWith(srch.toLowerCase())) {
				results.add(struct.attributeAt(i));
			}
		}
		if (results.size() > 0) {
			String[] matches = (String[]) results.toArray(new String[0]);
			return matches;
		}

		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/6/2002 8:47:47 PM)
	 * @return butterfly.xmlview.model.interfaces.IElementStructure[]
	 * @param srch java.lang.String
	 */
	private IElementStructure[] listPossibleElements(String srch) {
		Vector results = new Vector();
		IElementStructure[] els = model_.getElementStructures();
		if (els != null) {
			for (int i = 0; i < els.length; i++) {
				if (els[i]
					.getName()
					.toLowerCase()
					.startsWith(srch.toLowerCase())) {
					results.add(els[i]);
				}
			}
			if (results.size() > 0) {
				IElementStructure[] matches =
					(IElementStructure[]) results.toArray(
						new IElementStructure[0]);
				return matches;
			}
		}
		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/6/2002 8:47:47 PM)
	 * @return butterfly.xmlview.model.interfaces.IElementStructure[]
	 * @param srch java.lang.String
	 */
	private IElementStructure[] listPossibleElements(
		IElement parent,
		String srch, String ns) {
		Vector results = new Vector();
		logger_.debug("listing sub-elements of " + parent+ " search:"+srch);
		
		
		//we shouldn't be passing null for the namespace...need to figure it out
		IElementStructure el = model_.getElementStructure(parent.getLocalName(),parent.getNameSpace());
		//IElementStructure[] els = model_.getElementStructures();
		logger_.debug("structure declared = "+(el != null));
		if (el != null) {
			if (srch.equals("")) {
				for (int i = 0; i < el.subElementCount(); i++) {
					if(ns == null){
						results.add(el.subElementAt(i));
					}
					else{
						if(el.subElementAt(i).getNamespace().equals(ns)){
							results.add(el.subElementAt(i));
						}
					}
				}
			} else {
				for (int i = 0; i < el.subElementCount(); i++) {
					//System.out.println(el.subElementAt(i).getName());
					if (el
						.subElementAt(i)
						.getName()
						.toLowerCase()
						.startsWith(srch.toLowerCase())) {
						if(ns == null){
							results.add(el.subElementAt(i));
						}
						else{
							if(el.subElementAt(i).getNamespace().equals(ns)){
								results.add(el.subElementAt(i));
							}
						}
						//results.add(el.subElementAt(i));
					}
				}
			}
			if (results.size() > 0) {
				IElementStructure[] matches =
					(IElementStructure[]) results.toArray(
						new IElementStructure[0]);
				return matches;
			}
		}
		return null;
	}
	
	private IElementStructure[] listPossibleElements(
		String parent,
		String srch) {
		Vector results = new Vector();
		logger_.debug("listing sub-elements of " + parent);
		
		
		//we shouldn't be passing null for the namespace...need to figure it out
		IElementStructure el = model_.getElementStructure(parent, null);
		//IElementStructure[] els = model_.getElementStructures();
		logger_.debug("structure declared = "+(el != null));
		if (el != null) {
			if (srch.equals("")) {
				for (int i = 0; i < el.subElementCount(); i++) {
					results.add(el.subElementAt(i));
				}
			} else {
				for (int i = 0; i < el.subElementCount(); i++) {
					if (el
						.subElementAt(i)
						.getName()
						.toLowerCase()
						.startsWith(srch.toLowerCase())) {
						results.add(el.subElementAt(i));
					}
				}
			}
			if (results.size() > 0) {
				IElementStructure[] matches =
					(IElementStructure[]) results.toArray(
						new IElementStructure[0]);
				return matches;
			}
		}
		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/15/2002 6:11:34 PM)
	 * @param root butterfly.xmlview.model.Node
	 */
	public void loadXmlModel(IXmlDocument doc) {
		setContentType("text/xml");
		logger_.debug("loading doc...dirty=" + doc.isDirty());
		if (model_ != null) {
			model_.removeDocumentListener(this);
			model_.removeDocumentSourceListener(sourceListener_);
			model_.removeMarkerListener(markerListener_);
			
			//model_.removeDocumentSourceListener(correctionListener_);
		}
		//if(doc.equals(model_) && !doc.isDirty()){
		//return;
		//}
		//if(doc.toXml().equals(getText())){
		//return;
		//}
		logger_.debug("loading new document...");
		getDocument().removeDocumentListener(docListener_);
		setDocument(new ProtectedDocument());
		Document ddoc = getDocument();
		
		//removeCaretListener(caretListener_);
		model_ = doc;
		//mapping_ = new XmlModelToTextMapping();
		//mapping_.setTextComponent(this);
		//mapping_.loadXmlModel(doc);
		//String src = doc.toXml();
		//logger_.debug(src);
		//getDocument().
		// setText("");
		loading_ = true;
		// setText(src);
		//Runnable r = new Runnable() {
		//    public void run() {
		//XmlTextLoader loader = new XmlTextLoader();
		//loader.loadXmlModelInto(model_, (StyledDocument) getDocument());
		//setText(doc.toXml());
		XmlEditorKit.setXmlDocument(ddoc, model_);
		setText(doc.toXml());
		
		/*
		
		    		
		    IXmlDocumentTokenizer tokens = model_.getDocumentTokenizer();
		    String curr = null;
		   
		    while(tokens.hasMoreTokens()){
			    try{
				    curr = tokens.nextToken();
				//    System.out.println("inserting \""+curr+"\"");
				if(XmlDocument.isTag(curr)){
					//logger_.debug("adding tag: "+curr);
					if(XmlDocument.isProcessingInstruction(curr)){
						ddoc.insertString(ddoc.getLength(),curr, processingInstructionStyle_);
					}
					else{
						if(XmlDocument.isComment(curr)){
							ddoc.insertString(ddoc.getLength(),curr, commentStyle_);
						}
						else{
							ddoc.insertString(ddoc.getLength(),curr, elementStyle_);
						}
					}
					
				}
				else{
					ddoc.insertString(ddoc.getLength(),curr,valueStyle_);
				}
			    }catch(Exception e){e.printStackTrace();}
		    }
		
		*/

		//doc.setXml()
		//  doc.removeString(0,doc)
		getDocument().addDocumentListener(docListener_);
		getDocument().addUndoableEditListener(new XmlUndoableEditListener());
		model_.addDocumentSourceListener(sourceListener_);
		//model_.addDocumentSourceListener(correctionListener_);
		model_.addDocumentListener(this);
		model_.addMarkerListener(markerListener_);
		tidy_.setDocument(model_);
		indentAction_.setDocument(model_);
		// addCaretListener(caretListener_);
		setCaretPosition(0);
		//setNodeStyle(doc.getRoot(),true);
		loading_ = false;
		//  }
		//};

		//SwingUtilities.invokeLater(r);
		dirty_ = false;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/13/2002 11:27:58 PM)
	 * @param l butterfly.statemachine.interfaces.IStateEventListener
	 */
	public void removeStateEventListener(
		butterfly.statemachine.interfaces.IStateEventListener l) {
		listenerManager_.removeListener(l);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/1/2002 1:45:12 PM)
	 * @param index int
	 * @param length int
	 * @param str java.lang.String
	 */
	public void replace(int index, int length, String str) {
		String text =
			getText().substring(0, index)
				+ str
				+ getText().substring(index + length);
		getCaret().setDot(index + length);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/17/2002 6:48:56 PM)
	 * @param newCurrentTag java.lang.String
	 */
	public void setCurrentTag(java.lang.String newCurrentTag) {
		currentTag_ = newCurrentTag;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/14/2002 7:07:22 PM)
	 * @param newListenerManager butterfly.statemachine.StateListenerManager
	 */
	void setListenerManager(
		butterfly.statemachine.StateListenerManager newListenerManager) {
		listenerManager_ = newListenerManager;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/17/2002 6:48:56 PM)
	 * @param newParentTag java.lang.String
	 */
	public void setParentTag(java.lang.String newParentTag) {
		parentTag_ = newParentTag;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/7/2002 12:10:18 PM)
	 * @param x int
	 * @param y int
	 */
	private void showSuggestionMenu(int x, int y, int lt, String[] items) {
		//logger_.debug("downact:"+getActionByName(DefaultEditorKit.downAction));
		if (items.length < 1) {
			return;
		}

		Font f = getFont();
		FontMetrics fm = getToolkit().getFontMetrics(f);
		if (suggestionMenu_ == null) {
			suggestionMenu_ = new SuggestionMenu();
			//suggestionMenu_.addKeyListener(this);
		} else {
			suggestionMenu_.removeAll();
		}
		boolean showmenu = false;
		for (int i = 0; i < items.length; i++) {
			if (!(items[i].trim().length() < 1)) {
				SuggestionAction act = new SuggestionAction();
				act.setSuggestion(items[i]);
				act.setStart(lt + 1);

				suggestionMenu_.add(act).setText(items[i]);
				showmenu = true;
			}
		}
		suggestionMenu_.getSelectionModel().setSelectedIndex(0);
		if (showmenu) {
			suggestionMenu_.show(
				this,
				x,
				y + fm.getMaxAscent() + fm.getMaxDescent());
			this.requestFocus();
		}
	}
	
	private void showSuggestionMenu(int x, int y, int lt, String[] items,boolean dc) {
		//logger_.debug("downact:"+getActionByName(DefaultEditorKit.downAction));
		if (items.length < 1) {
			return;
		}

		Font f = getFont();
		FontMetrics fm = getToolkit().getFontMetrics(f);
		if (suggestionMenu_ == null) {
			suggestionMenu_ = new SuggestionMenu();
			//suggestionMenu_.addKeyListener(this);
		} else {
			suggestionMenu_.removeAll();
		}
		boolean showmenu = false;
		for (int i = 0; i < items.length; i++) {
			if (!(items[i].trim().length() < 1)) {
				SuggestionAction act = new SuggestionAction();
				act.setSuggestion(items[i]+"></"+items[i]+">");
				act.setStart(lt + 1);
				//act.setCursorAdjustment(lt);//+2+items[i].length());
				suggestionMenu_.add(act).setText(items[i]);
				showmenu = true;
			}
		}
		suggestionMenu_.getSelectionModel().setSelectedIndex(0);
		if (showmenu) {
			suggestionMenu_.show(
				this,
				x,
				y + fm.getMaxAscent() + fm.getMaxDescent());
			this.requestFocus();
		}
	}
	
	private void showSuggestionMenu(int x, int y, int lt,String[] disp, String[] items) {
		//logger_.debug("downact:"+getActionByName(DefaultEditorKit.downAction));
		if (items.length < 1) {
			return;
		}

		Font f = getFont();
		FontMetrics fm = getToolkit().getFontMetrics(f);
		if (suggestionMenu_ == null) {
			suggestionMenu_ = new SuggestionMenu();
			//suggestionMenu_.addKeyListener(this);
		} else {
			suggestionMenu_.removeAll();
		}
		boolean showmenu = false;
		for (int i = 0; i < items.length; i++) {
			if (!(items[i].trim().length() < 1)) {
				SuggestionAction act = new SuggestionAction();
				logger_.debug("suggestion:"+items[i]);
				act.setSuggestion(items[i]);
				act.setStart(lt + 1);
				//act.setCursorAdjustment(lt);//+2+items[i].length());
				suggestionMenu_.add(act).setText(disp[i]);
				showmenu = true;
			}
		}
		suggestionMenu_.getSelectionModel().setSelectedIndex(0);
		if (showmenu) {
			suggestionMenu_.show(
				this,
				x,
				y + fm.getMaxAscent() + fm.getMaxDescent());
			this.requestFocus();
		}
	}

	
	private Comparator alphabeticalComparator_ = new Comparator(){
		String name = "";
		String compto = "";
		public int compare(Object obj1, Object obj2){
			if(obj1 instanceof AbstractAction){
				AbstractAction a = (AbstractAction)obj1;
				AbstractAction b = (AbstractAction)obj2;
				name = (String)a.getValue(AbstractAction.NAME);
				compto = (String)b.getValue(AbstractAction.NAME);
				return name.compareTo(compto);
			}
			else if(obj1 instanceof IElementStructure){
				name = ((IElementStructure)obj1).getName();
				compto = ((IElementStructure)obj2).getName();
			}
			return String.CASE_INSENSITIVE_ORDER.compare(name,compto);
		}
	};
	
	
	private boolean isValidContext(Object context){
		return (context==validContext_);	
	}
	
	private void showSuggestionMenu(int x, int y, AbstractAction[] items) {
		//logger_.debug("downact:"+getActionByName(DefaultEditorKit.downAction));
		if (items.length < 1) {
			return;
		}
		
		List list = Arrays.asList(items);
		Collections.sort(list,alphabeticalComparator_);
		items =(AbstractAction[]) list.toArray(new AbstractAction[0]);

		Font f = getFont();
		FontMetrics fm = getToolkit().getFontMetrics(f);
		if (suggestionMenu_ == null) {
			suggestionMenu_ = new SuggestionMenu();
			//suggestionMenu_.addKeyListener(this);
		} else {
			suggestionMenu_.removeAll();
		}
		boolean showmenu = false;
		int total = items.length < 15 ? items.length : 15;
		//int submenus = 
		for (int i = 0; i < total; i++) {
			//if(!(items[i].trim().length() < 1)){
			//			SuggestionAction act = new SuggestionAction();
			//			act.setSuggestion(items[i]);
			//			act.setStart(lt + 1);

			suggestionMenu_.add(items[i]).setOpaque(false);
			showmenu = true;
			//}
		}
		if(total != items.length){
			JMenu sub =new JMenu("More >");
			for(int i=total; i < items.length; i++){
				sub.add(items[i]);
			}
			suggestionMenu_.add(sub);
		}
		suggestionMenu_.getSelectionModel().setSelectedIndex(0);
		if (showmenu) {
			suggestionMenu_.show(
				this,
				x,
				y + fm.getMaxAscent() + fm.getMaxDescent());
			this.requestFocus();
		}
	}

	private void addErrorMarker() {
		/*
				JEditorPane editor = this;
		    if (editor != null) {
			StyledEditorKit kit = (StyledEditorKit)getEditorKit();
			MutableAttributeSet attr = kit.getInputAttributes();
			boolean italic = (StyleConstants.isItalic(attr)) ? false : true;
			SimpleAttributeSet sas = new SimpleAttributeSet();
			StyleConstants.setItalic(sas, italic);
			StyledEditorKit.setCharacterAttributes(editor, sas, false);
			StyledDocument doc = getStyledDocument(editor);
			doc.setCharacterAttributes(p0, p1 - p0, attr, replace);
		    }
		    StyledEditorKit k = getStyledEditorKit(editor);
		    MutableAttributeSet inputAttributes = k.getInputAttributes();
		    if (replace) {
			inputAttributes.removeAttributes(inputAttributes);
		    }
		    inputAttributes.addAttributes(attr);	*/
	}

	SimpleAttributeSet textStyle_ = new SimpleAttributeSet();
	SimpleAttributeSet scratchStyle_ = null;

	protected SimpleAttributeSet getNodeStyle(INode node) {
		if (node instanceof IElement) {
			return elementStyle_;
		} else if (node instanceof IScratchTag) {
			if (scratchStyle_ == null) {
				scratchStyle_ = new SimpleAttributeSet();
				StyleConstants.setForeground(
					scratchStyle_,
					new Color(255, 50, 50));
				StyleConstants.setUnderline(scratchStyle_, true);
			}
			return scratchStyle_;
		} else {
			return textStyle_;
		}
	}

	private void setNodeStyle(INode node, boolean setChildrenStyles) {
		//logger_.debug("setting node style for:"+node);
		SimpleAttributeSet style = getNodeStyle(node);
		if (node instanceof ISourceNode) {
			int start = ((ISourceNode) node).getStart();
			int length = ((ISourceNode) node).getLength();
			if (node instanceof ISourceElement) {
				ISourceElement sel = (ISourceElement) node;

				((StyledDocument) getDocument()).setCharacterAttributes(
					start,
					length,
					style,
					true);
				if (sel.getEndTagStart() > -1) {
					start = sel.getEndTagStart();
					length = sel.getEndTagLength();
					((StyledDocument) getDocument()).setCharacterAttributes(
						start,
						length,
						style,
						true);
				}
			} else if (node instanceof IScratchTag) {
				IScratchTag tag = (IScratchTag) node;
				length = tag.getText().trim().length();
				((StyledDocument) getDocument()).setCharacterAttributes(
					start,
					length,
					style,
					true);
			} else {
				((StyledDocument) getDocument()).setCharacterAttributes(
					start,
					length,
					style,
					true);
			}
		}
		if (setChildrenStyles) {
			for (int i = 0; i < node.childCount(); i++) {
				setNodeStyle(node.childAt(i), true);
			}
		}
	}
	
	public void addNodeSelectionListener(INodeSelectionListener l){
		nodeSelectionListeners_.add(l);	
	}
	public void removeNodeSelectionListener(INodeSelectionListener l){
		nodeSelectionListeners_.remove(l);	
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getIDocument()
	 */
	public IDocument getIDocument() {
		return getXmlModel();
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#loadDocument(IDocument)
	 */
	public void loadDocument(IDocument doc) {
		loadXmlModel((IXmlDocument)doc);
	}

	/**
	 * @see javax.swing.JComponent#getToolTipText()
	 */
	
	
	public String getToolTipText(MouseEvent me) {
		int index = viewToModel(me.getPoint());
			//System.out.println("index:"+index);
			INode node = ((IModelToSourceMapping)getXmlModel()).nodeAt(index);
			if(node != null && !(node instanceof IScratchTag)){
				String msg = "";
				IMarker[] markers = node.getMarkers();
				
				if(markers != null){
				for(int i = 0; i < markers.length; i++){
					msg += markers[i].getMessage()+"\n";	
				}
				//System.out.println("showing markers...:"+msg);
				return msg;
			}
			}
			else if(node instanceof IScratchTag){
				String msg = "";
				//IMarker[] markers = node.getMarkers();
				
				return ((IScratchTag)node).getErrorMessage();
			}
		return null;
	}

	/**
	 * @see javax.swing.JComponent#getToolTipLocation(MouseEvent)
	 */
	public Point getToolTipLocation(MouseEvent event) {
		return super.getToolTipLocation(event);
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		getCaret().setDot(start);
		getCaret().moveDot(start + length);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IMarkerView#renderMarker(int, int, butterfly.xmlview.model.interfaces.IMarker)
	 */
	private MarkerView markerView_=new MarkerView(){
	
	};
	public void renderMarker(int x, int y, IMarker marker) {
		// TODO Auto-generated method stub
		//System.out.println("render:"+marker+" at:"+x+","+y);
		markerView_.renderMarker(x,y,marker);
	}
	
	
	
	class MarkerView extends JPanel implements IDocumentListener{
		private Hashtable markers_=new Hashtable();
		
		public MarkerView(){
			setLayout(null);
		}
		
		public void removeMarker(IMarker m){
			logger_.debug("remove marker"+m);
			JLabel l = (JLabel)markers_.get(m);
			if(l != null){
				remove(l);
				logger_.debug("got rid of a marker");
			}
			markers_.remove(m);
			repaint();
		}
		
		public void renderMarker(int x, int y, IMarker marker){
			if(marker != null){
			JLabel label = (JLabel)markers_.get(marker);
			if(label == null){
				IMarkerRenderer rend = MarkerRendererFactory.getRenderer(marker);
				//label = new JLabel("m");
				label = new MarkerRendererComponent(marker,rend);
				label.setSize(20,20);
				markers_.put(marker,label);
				//
				
				add(label);
				//setBackground(Color.CYAN);
			}
			label.setLocation(1,y);
			}else{
				Component comp = getComponentAt(1,y);
				if(comp != null){
				//	remove(comp);
				}
			}
		}
		public java.awt.Dimension getPreferredSize(){
			return new java.awt.Dimension(20,XmlSourceEditor.this.getHeight());
		}
		
		/* (non-Javadoc)
		 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
		 */
		protected void paintComponent(Graphics g) {
			// TODO Auto-generated method stub
			g.setColor(Color.white);
			g.fillRect(0,0,getWidth(),getHeight());
			g.setColor(new Color(230,230,240));
		//	g.fillRect(0,0,getWidth(),getHeight());
			int h = getHeight()-4;
			int w = getWidth()-1;
			for(int i = 0; i < h; i+=8){
				g.drawLine(w,i,w,i+4);
			}
//			g.setColor(Color.lightGray);
//			for(int i = 0; i < getHeight()-2; i+=2){
//				g.drawLine(0,i+8,getWidth(),i);
//				g.drawLine(0,i,getWidth(),i+8);
//			}
//			g.setColor(Color.darkGray);
//			g.fillRect(getWidth()-2,0,2,getHeight());
			
		//	for(int i = h; i < )
			//super.paintComponent(g);
			paintChildren(g);
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(butterfly.xmlview.model.interfaces.IDocumentEvent)
		 */
		public void handleDocumentEvent(IDocumentEvent evt) {
			// TODO Auto-generated method stub
			logger_.debug("checking for old markers to remove from "+evt.getChangedNode());
			INode changed = evt.getChangedNode();
			if(changed.getMarkers()!=null){
				IMarker[] markers = changed.getMarkers();
				for(int i = 0; i < markers.length; i++){
					removeMarker(markers[i]);
				}
			}
		}

	}
	class MarkerRendererComponent extends JLabel{
		IMarkerRenderer renderer_;
		IMarker marker_;
		public MarkerRendererComponent(IMarker m, IMarkerRenderer r){
			renderer_=r;
			marker_=m;
			setToolTipText(m.getMessage());
		}
		public void paintComponent(Graphics g){
			super.paintComponent(g);
			if(renderer_!=null){
				renderer_.render(marker_,g,0,2);
			}
		}
	}
	
	public JComponent getMarkerView(){
		return markerView_;
	}
	
	public void buildEditingMenuForNode(JPopupMenu m, INode node){
			IElement context = null;
			if(declarePrefixAction_!=null){
		 	if(node instanceof IElement){
		 		context = (IElement)node;
		 		declarePrefixAction_.setElement((IElement)node);	
		 	}
		 	else{
		 		IElement root = ((DocumentRoot)node.getDocument().getRoot()).firstElement();
		 		context = root;
		 		declarePrefixAction_.setElement(root);
		 	}
		 	JMenu dp = new JMenu("Declare Prefix Mapping");
		 	dp.add(declarePrefixAction_).setText("New Prefix Mapping");
		 	JMenu common = new JMenu("Common Prefixes");
		 	for(int i = 0; i < commonPrefixes_.length; i++){
		 		if(((XmlDocument)model_).getNamespaceURI(commonPrefixes_[i].getPrefix())==null){
		 			commonPrefixes_[i].setElement(context);
		 			common.add(commonPrefixes_[i]).setText(commonPrefixes_[i].getPrefix()+" = "+commonPrefixes_[i].getUri());	
		 		}
		 	}
		 	dp.add(common);
		 	GetPrefixesInUseAction getpre = (GetPrefixesInUseAction)ButterflyApplication.getInstance().getAction("butterfly.actions.GetPrefixesInUseAction");
		 	getpre.actionPerformed(null);
		 	Hashtable pres = getpre.getPrefixesInUse();
		 	Vector keyset = new Vector(pres.keySet());
		 	Collections.sort(keyset);
		 	for(int i = 0; i < keyset.size(); i++){
		 		String pre = (String)keyset.elementAt(i);
		 		String uri = (String)pres.get(pre);
		 		if(((XmlDocument)model_).getNamespaceURI(pre)==null){
		 			DeclarePrefixAction dpa = new DeclarePrefixAction();
		 			dpa.setPrefix(pre);
		 			dpa.setUri(uri);
		 			dpa.setElement(context);
		 			dp.add(dpa).setText(pre+" = "+uri);	
		 		}
		 	}
		 	m.add(dp);
		 	m.addSeparator();
			}
		//if (me.isPopupTrigger()) {
		//	JPopupMenu m = new JPopupMenu();
			
			//m.add(new ParseNodeAction()).setText("Parse node");
			//m.add(new ShowMarkersAction()).setText("Show Markers");
			//m.add(new ShowPrefixMappingsAction()).setText(
			//	"Show prefix mappings");
			//m.add(new ShowNamespaceAction()).setText("Show Namespace");
			//m.add(new InfoAction()).setText("test");
			//m.add(new ShowAttributesAction()).setText("Show Attributes");
			//m.add(new ConvertAction()).setText("Make Child Capable");
			//m.add(new RefreshAction()).setText("Refresh");
			//m.add(new RefreshAction()).setText("Open DTD View ...show defined elements / content models");
			//m.add(new RefreshAction()).setText("Add all undefined elements to DTD");
			m.add(new GenerateDTDAction()).setText("Generate DTD");
			GenerateSchemaAction gsa = new GenerateSchemaAction();
			gsa.setType(GenerateSchemaAction.XSD_TYPE);
			gsa.setDocument((AbstractValidatedDocument)getXmlModel());
			m.add(gsa).setText("Generate Schema");
			JMenu appendsm = new JMenu("Add Schema");
			IElement rootel = ((DocumentRoot)getXmlModel().getRoot()).firstElement();
			
			
			if(rootel != null){
				AppendSchemaAction appendschema = new AppendSchemaAction();
				appendschema.setNode(rootel);
				appendsm.add(appendschema).setText("Add No Namespace Schema");
				JMenu appendnsschema = new JMenu("Add Schema for Namespace");
				
				XmlDocument.NamespaceMapping[] nspaces = ((XmlDocument)getXmlModel()).getNamespaceMappings();
				
				for(int i = 0; i < nspaces.length; i++){
					AppendSchemaAction ads = new AppendSchemaAction();
					ads.setNode(rootel);
					ads.setNamespaceToBind(nspaces[i].uri);
					appendnsschema.add(ads).setText(nspaces[i].uri);
				}
				
				AppendSchemaAction appendnewns = new AppendSchemaAction();
				appendnewns.setPromptForNamespace(true);
				appendnewns.setNode(rootel);
				appendnsschema.add(appendnewns).setText("Append Schema for New Namespace");
				appendsm.add(appendnsschema);
			}
			else{
				appendsm.setEnabled(false);
			}
			m.add(appendsm);
			m.addSeparator();
//				m.add(new AbstractAction() {
//					public void actionPerformed(ActionEvent e) {
//						// TODO Auto-generated method stub
//						//XmlDocument doc = new XmlDocument(getText());
//						//loadDocument()
//					}
//				}).setText("Re-parse (Override incremental parsing)");
//				m.add(new JLabel("Re-validate (Override incremental validation)"));
			m.add(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					prettyPrint();
				}
			}).setText("Tidy XML");
			m.addSeparator();
			
			
			if(node != null){
				if(node instanceof IElement){
					JMenu appendc = new JMenu("Append Child");
					JMenu appendsib = new JMenu("Append Sibling");
					
					
					IValidationDocument vdoc = getXmlModel().getValidationDocument();
					IElementStructure structe = (IElementStructure)vdoc.getNodeStructure(node);
					if(structe != null){
						Vector result = new Vector();
						for(int i = 0; i <structe.subElementCount(); i++){
							if(structe.subElementAt(i) != null){
								AddElementAction add = new AddElementAction(structe.subElementAt(i).getNamespace(),structe.subElementAt(i).getName());
								add.setNode(node);
								add.putValue(AbstractAction.NAME,structe.subElementAt(i).getName());
								result.add(add);
							}
						}
						Collections.sort(result,alphabeticalComparator_);
						for(int i = 0; i <result.size(); i++){
							//if(structe.subElementAt(i) != null){
							
							appendc.add((AbstractAction)result.elementAt(i));
							//}
						}
					}
					AddElementAction add = new AddElementAction(null,null);
					add.setNode(node);
					appendc.add(add).setText("New Element");
					AddNodeAction addn = new AddNodeAction(true);
					addn.setNode(node);
					addn.setNodeToAdd(new ValueNode("Insert your text here."));
					appendc.add(addn).setText("Text Node");
					addn = new AddNodeAction(true);
					addn.setNode(node);
					addn.setNodeToAdd(new Comment("Insert your comment here."));
					appendc.add(addn).setText("Comment");
					addn = new AddNodeAction(true);
					addn.setNode(node);
					addn.setNodeToAdd(new CDataNode());
					appendc.add(addn).setText("CDATA");
					addn = new AddNodeAction(true);
					addn.setNode(node);
					addn.setNodeToAdd(new ProcessingInstruction());
					appendc.add(addn).setText("Processing Instruction");
					
					if(node.getParent() instanceof IElement){
						IElementStructure structp = (IElementStructure)vdoc.getNodeStructure(node.getParent());
						if(structp != null){
							Vector result = new Vector();
							for(int i = 0; i <structp.subElementCount(); i++){
								if(structp.subElementAt(i) != null){
									add = new AddElementAction(structp.subElementAt(i).getNamespace(),structp.subElementAt(i).getName());
									add.setNode(node.getParent());
									add.putValue(AbstractAction.NAME,structp.subElementAt(i).getName());
									result.add(add);
								}
							}
							Collections.sort(result,alphabeticalComparator_);
							for(int i = 0; i <result.size(); i++){
								
								appendsib.add((AbstractAction)result.elementAt(i));
								
							}
						}
						add = new AddElementAction(null,null);
						add.setNode(node.getParent());
						appendsib.add(add).setText("New Element");
						
						
						addn = new AddNodeAction(true);
						addn.setNode(node.getParent());
						addn.setNodeToAdd(new ValueNode("Insert your text here."));
						appendsib.add(addn).setText("Text Node");
						addn = new AddNodeAction(true);
						addn.setNode(node.getParent());
						addn.setNodeToAdd(new Comment("Insert your comment here."));
						appendsib.add(addn).setText("Comment");
						addn = new AddNodeAction(true);
						addn.setNode(node.getParent());
						addn.setNodeToAdd(new CDataNode());
						appendsib.add(addn).setText("CDATA");
						addn = new AddNodeAction(true);
						addn.setNode(node.getParent());
						addn.setNodeToAdd(new ProcessingInstruction());
						appendsib.add(addn).setText("Processing Instruction");
					}
					else{
						appendsib.setEnabled(false);
					}
					
					m.add(appendc);
					m.add(appendsib);
					
					m.addSeparator();
					//m.add(new ShowNodeAction()).setText("Node Info");
					FindEndTagAction fend = new FindEndTagAction();
					fend.setNode(node);
					m.add(fend).setEnabled(((IElement)node).getEndTagStart()>-1);
					m.addSeparator();
				}
			}
			m.add(undoAction_).setText("Undo");
			m.add(redoAction_).setText("Redo");
			NodeMenuFactory.buildEditingMenuForNode(m,node);
	}

}
