/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.log4j.Logger;

import butterfly.components.interfaces.IComponent;
import butterfly.statemachine.StateListenerManager;
import butterfly.statemachine.interfaces.IStateEventListener;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.gui.interfaces.INodeSelectionListener;
import butterfly.xmlview.gui.interfaces.IXmlRenderer;
import butterfly.xmlview.gui.interfaces.IXmlSourceRenderer;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/16/2002 11:37:34 AM)
 * @author: 
 */
public class XmlSourceEditorRenderer implements IXmlRenderer,IComponent,IXmlSourceRenderer,Composable,IStateEventListener,IStateEventSource,INodeSelectionListener{
	private XmlSourceEditor editor_;
	private JScrollPane editorPane_;
	private static Logger logger_ = Logger.getLogger(XmlSourceEditorRenderer.class);
	private ComponentManager componentManager_;
	private StateListenerManager listenerManager_ = new StateListenerManager();
	private Vector nodeSelectionListeners_=new Vector();
/**	
 * XmlSourceEditorRenderer constructor comment.
 */
public XmlSourceEditorRenderer() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 9:32:40 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void addStateEventListener(butterfly.statemachine.interfaces.IStateEventListener l) {
	listenerManager_.addListener(l);	
}
/**
 * compose method comment.
 */
public void compose(org.apache.avalon.framework.component.ComponentManager arg1) throws org.apache.avalon.framework.component.ComponentException {
	componentManager_ = arg1;
	try{
		//styleMap_ = (IXmlStyleMap)componentManager_.lookup(IXmlStyleMap.ROLE);
	}catch(Exception e){
		//logger_.warn(e);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int find(java.lang.String srch, int index) {
	return editor_.getText().indexOf(srch,index);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {
	editor_.focusOnNode(node);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getDocument() {
	return getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getIDocument() {
	return getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public INode[] getSelectedNodes() {
	return editor_.getSelectedNodes();
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 5:55:29 PM)
 * @return butterfly.xmlview.model.XmlDocument
 */
public IXmlDocument getXmlModel() {
	return editor_.getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 9:31:58 AM)
 * @param event butterfly.statemachine.interfaces.IStateEvent
 */
public void handleEvent(butterfly.statemachine.interfaces.IStateEvent event) {
	//logger_.debug("listener manager is forwarding an event...");
	listenerManager_.fireEvent(event);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void loadDocument(butterfly.xmlview.model.interfaces.IDocument doc) {
	renderXmlDocument((IXmlDocument)doc);	
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2002 9:32:40 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void removeStateEventListener(IStateEventListener l) {
	listenerManager_.removeListener(l);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 11:37:34 AM)
 * @return java.awt.Component
 * @param doc butterfly.xmlview.model.XmlDocument
 */
public JComponent renderXmlDocument(IXmlDocument doc) {
    if (editor_ == null) {
        XmlSourceEditor editor = new XmlSourceEditor();
        JComponent mv = editor.getMarkerView();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add(editor,BorderLayout.CENTER);
        p.add(mv,BorderLayout.WEST);
        //logger_.debug("XmlStyleMap: " + styleMap_);
        JScrollPane pane = new JScrollPane(p);
        editor.setMinimumSize(new Dimension(250, 500));
        pane.setMinimumSize(new Dimension(2000, 2000));
        pane.setPreferredSize(new Dimension(2000, 2000));
        pane.setDoubleBuffered(true);
        editor.setDoubleBuffered(true);
       // editor.setStyleMap(styleMap_);
        editor_ = editor;
        
       
        editorPane_ = pane;
        editor_.addStateEventListener(this);
        editor_.addNodeSelectionListener(this);
//        IXmlTidyAction tidy = (IXmlTidyAction)componentManager_.lookup(IXmlTidyAction.ROLE);
//        if(tidy != null){
//        	KeyStroke st = 
//        		
//        }
    }
    editor_.loadXmlModel(doc);
	//logger_.debug("xml loaded");
    return editorPane_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 1:11:27 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int replace(java.lang.String srch, java.lang.String rep, int index) {
	int start = find(srch,index);
	if(start > -1){
		editor_.replace(start,srch.length(),rep);
	}
	return start;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:39 AM)
 * @param start int
 */
public void setSelectionEnd(int end) {
	editor_.requestFocus();
	//logger_.debug("setting the end of the selection");
	editor_.getCaret().moveDot(end);
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:39 AM)
 * @param start int
 */
public void setSelectionStart(int start) {
	editor_.requestFocus();
	editor_.getCaret().setDot(start);	
}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#addNodeSelectionListener(INodeSelectionListener)
	 */
	public void addNodeSelectionListener(INodeSelectionListener l) {
		nodeSelectionListeners_.add(l);
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#removeNodeSelectionListener(INodeSelectionListener)
	 */
	public void removeNodeSelectionListener(INodeSelectionListener l) {
		nodeSelectionListeners_.remove(l);
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.INodeSelectionListener#selectedNodesChanged(INode[])
	 */
	public void selectedNodesChanged(INode[] sel) {
		//logger_.debug("selected nodes changed (renderer)");
		for(int i = 0; i < nodeSelectionListeners_.size(); i++){
					((INodeSelectionListener)nodeSelectionListeners_.elementAt(i)).selectedNodesChanged(sel);	
		}
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		editor_.requestFocus();
		editor_.setSelection(start,length);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getSelectedTag()
	 */
	public String getSelectedTag() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getSelectedTagXPath()
	 */
	public String getSelectedTagXPath() {
		// TODO Auto-generated method stub
		return null;
	}

}
