/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.tree.DocumentCellEditor;
import butterfly.xmlview.gui.tree.DocumentTree;
import butterfly.xmlview.gui.tree.DocumentTreeModel;
import butterfly.xmlview.gui.tree.TreeEditorLookup;
import butterfly.xmlview.gui.tree.XmlTreeEditor;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.interfaces.IComment;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IProcessingInstruction;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (12/1/2002 1:59:58 PM)
 * @author: 
 */
public class XmlTree extends DocumentTree implements IDocumentEditor{
	private IDocument document_;
/**
 * XmlTree constructor comment.
 * @param t javax.swing.tree.DefaultTreeModel
 */
public XmlTree() {
	super(new DocumentTreeModel(new javax.swing.tree.DefaultMutableTreeNode("Project Files")));
	((DocumentTreeModel)getTreeModel()).setTree(this);
	TreeEditorLookup lookup = new TreeEditorLookup();
	//setCellEditor(new DocumentTreeCellEditor(this));
	setRowHeight(0);
	XmlTreeEditor ed = new XmlTreeEditor();
	ed.setDropDownMenusEnabled(true);
	ed.setShowAttributes(true);
	lookup.registerTreeEditor(IElement.class, ed);
	lookup.registerTreeEditor(IValueNode.class,ed );
	lookup.registerTreeEditor(IDocumentDeclaration.class, ed);
	lookup.registerTreeEditor(IProcessingInstruction.class,ed);
	lookup.registerTreeEditor(IComment.class, ed);
	lookup.registerTreeEditor(IDTDNode.class, ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
	lookup.registerTreeEditor(DocumentRoot.class,ed);
	setTreeEditorLookup(lookup);
	makeTableTree();
	setEditable(true);
	setCellEditor(new DocumentCellEditor(new JTextArea(),this));
//	setCellEditor(
//		new DefaultTreeCellEditor(this,(DefaultTreeCellRenderer)getCellRenderer()){
//			public boolean isCellEditable(EventObject event) {
//				return true;	
//			}	
//		}
//	);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int find(java.lang.String srch, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {
	DefaultMutableTreeNode tnode = getTreeNode(node);
	if(tnode != null){
		TreePath toroot = new TreePath(tnode.getPath());
		setSelectionPath(toroot);
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:36:45 PM)
 * @return IDocument
 */
public IDocument getDocument() {
	
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:36:45 PM)
 * @return IDocument
 */
public IDocument getIDocument() {
	
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public butterfly.xmlview.model.interfaces.INode[] getSelectedNodes() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:41:13 PM)
 * @return butterfly.xmlview.model.interfaces.IXmlDocument
 */
public butterfly.xmlview.model.interfaces.IXmlDocument getXmlModel() {
	return (IXmlDocument)document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:36:45 PM)
 * @param newDocument IDocument
 */
public void loadDocument(IDocument newDocument) {
	document_ = newDocument;
	super.loadDocument(newDocument);
	//expandAll(this,true);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:05:26 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int replace(java.lang.String srch, java.lang.String rep, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:23 AM)
 * @param start int
 */
public void setSelectionEnd(int end) {}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:23 AM)
 * @param start int
 */
public void setSelectionStart(int start) {}
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getSelectedTreeNodes()
	 */
	public DefaultMutableTreeNode[] getSelectedTreeNodes() {
		return super.getSelectedTreeNodes();
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		if(getDocument() instanceof IModelToSourceMapping){
			INode node = ((IModelToSourceMapping)getDocument()).nodeAt(start);
			if(node != null){
				focusOnNode(node);	
			}
		}
	}

}
