/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.util.Hashtable;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.statemachine.StateListenerManager;
import butterfly.statemachine.interfaces.IStateEventListener;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.gui.interfaces.INodeSelectionListener;
import butterfly.xmlview.gui.interfaces.IXmlRenderer;
import butterfly.xmlview.gui.interfaces.IXmlTreeRenderer;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMultiNode;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IProcessingInstruction;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/15/2002 10:37:34 AM)
 * @author: 
 */
public class XmlTreeVisitorRenderer  implements IStateEventListener, IStateEventSource,IXmlRenderer,IComponent,IActionRequester,IComponentRequester,IXmlTreeRenderer{
	private XmlTree canvas_;
	private int leftOffset_ = 10;
	private int rightOffset_ = 10;
	private int topOffset_ = 10;
	private int bottomOffset_ = 10;
	private int xPadding_ = 2;
	private int yPadding_ = 2;
	private int row_ = 1;
	private int column_ = 1;
	private int columnWidth_ = 50;
	private int rowHeight_ = 15;
	private DefaultMutableTreeNode currentNode_;
	private IActionLookup actionLookup_;
	private IComponentLookup componentLookup_;
	private JScrollPane pane_;
	private Hashtable lookup_;
	private StateListenerManager listeners_;
/**
 * XmlVisitorRenderer constructor comment.
 */
public XmlTreeVisitorRenderer() {
	super();
	listeners_ = new StateListenerManager();
}
/**
 * Insert the method's description here.
 * Creation date: (12/5/2002 9:46:11 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void addStateEventListener(butterfly.statemachine.interfaces.IStateEventListener l) {
		listeners_.addListener(l);
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int find(java.lang.String srch, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:33:30 AM)
 * @return butterfly.actions.interfaces.IActionLookup
 */
public butterfly.actions.interfaces.IActionLookup getActionLookup() {
	return actionLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 12:48:04 PM)
 * @return javax.swing.JTree
 */
public javax.swing.JTree getCanvas() {
	return canvas_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:33:30 AM)
 * @return butterfly.components.interfaces.IComponentLookup
 */
public butterfly.components.interfaces.IComponentLookup getComponentLookup() {
	return componentLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getDocument() {
	return getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public butterfly.xmlview.model.interfaces.IDocument getIDocument() {
	return getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 4:08:54 PM)
 * @return java.util.Hashtable
 */
private Hashtable getLookup() {
	if(lookup_ == null){
		lookup_ = new Hashtable(17);
	}
	return lookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public butterfly.xmlview.model.interfaces.INode[] getSelectedNodes() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (10/17/2002 7:12:40 PM)
 * @return java.lang.String
 */
public java.lang.String getSelectedTag() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (10/17/2002 7:12:40 PM)
 * @return java.lang.String
 */
public java.lang.String getSelectedTagXPath() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (8/16/2002 5:56:11 PM)
 * @return butterfly.xmlview.model.XmlDocument
 */
public IXmlDocument getXmlModel() {
	return canvas_.getXmlModel();
}
/**
 * Insert the method's description here.
 * Creation date: (12/5/2002 9:46:11 AM)
 * @param event butterfly.statemachine.interfaces.IStateEvent
 */
public void handleEvent(butterfly.statemachine.interfaces.IStateEvent event) {
	listeners_.fireEvent(event);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void loadDocument(butterfly.xmlview.model.interfaces.IDocument doc) {}
/**
 * Insert the method's description here.
 * Creation date: (12/5/2002 9:46:11 AM)
 * @param l butterfly.statemachine.interfaces.IStateEventListener
 */
public void removeStateEventListener(butterfly.statemachine.interfaces.IStateEventListener l) {
	listeners_.removeListener(l);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 10:54:51 AM)
 * @param root butterfly.xmlview.model.Node
 * @param canvas javax.swing.JPanel
 */
public void renderElement(IElement el, Container canvas) {
	//System.out.println("rendering an element named:"+el.getName()+" at x:"+(column_ * columnWidth_ + xPadding_)+" y:"+(row_ * rowHeight_ + yPadding_));
	DefaultMutableTreeNode node = new DefaultMutableTreeNode(el);
	getLookup().put(node,el);
	if(currentNode_ != null){
		currentNode_.add(node);
	}
	currentNode_ = node;
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 12:46:04 PM)
 * @param root butterfly.xmlview.model.Node
 * @param canvas javax.swing.Container
 */
public void renderMultiNode(IMultiNode value, java.awt.Container canvas) {}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 11:00:31 AM)
 * @param root butterfly.xmlview.model.Node
 * @param canvas javax.swing.JPanel
 */
public void renderNode(INode node, Container canvas) {
	if(	node instanceof IElement){
		renderElement((IElement)node,canvas);
	}
	if(node instanceof IValueNode){
		renderValueNode((IValueNode)node,canvas);
	}
	if(node instanceof IProcessingInstruction){
		renderProcessingInstruction((IProcessingInstruction)node);
	}
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 8:29:48 PM)
 * @return java.lang.Object
 * @param instr butterfly.xmlview.model.ProcessingInstruction
 */
public void renderProcessingInstruction(IProcessingInstruction instr) {
	DefaultMutableTreeNode node = new DefaultMutableTreeNode(instr);
	getLookup().put(node,instr);
	if(currentNode_ != null){
		currentNode_.add(node);
	}
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 11:00:31 AM)
 * @param root butterfly.xmlview.model.Node
 * @param canvas javax.swing.JPanel
 */
public void renderValueNode(IValueNode value, Container canvas) {
	//System.out.println("rendering a value node with data: "+value.getData().toString());
	if(value.getData().toString().trim().length() < 1){
		return;
	}
	DefaultMutableTreeNode node = new DefaultMutableTreeNode(value);
	getLookup().put(node,value);
	if(currentNode_ != null){
		currentNode_.add(node);
	}
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/15/2002 11:25:00 PM)
 * @return java.awt.Component
 * @param doc butterfly.xmlview.model.XmlDocument
 */
public JComponent renderXmlDocument(IXmlDocument doc) {
    lookup_ = new Hashtable();

    if (doc == null) {
        return null;
    }
    boolean savepaths = false;
    

    DefaultMutableTreeNode root = new DefaultMutableTreeNode("");//doc.getDescription());
    if (canvas_ != null) {
	    if(doc == canvas_.getDocument()){
        	canvas_.saveExpandedPaths();
        	savepaths = true;
	    }
        canvas_.loadDocument(doc);
        if(savepaths){
       	 canvas_.expandSavedPaths();
        }
    } else {
        currentNode_ = root;
        canvas_ = new XmlTree();
        canvas_.loadDocument(doc);
        canvas_.addStateEventListener(this);
        canvas_.setActionLookup(getActionLookup());
        canvas_.setComponentLookup(getComponentLookup());
        // canvas_.setXmlModel(doc);
        // canvas_.addTreeSelectionListener(canvas_);
        // visitNode(doc.getRoot());
        // canvas_.setNodeLookup(lookup_);

        //if(root.getChildCount() > 0){
        //DefaultMutableTreeNode docroot = (DefaultMutableTreeNode)root.getChildAt(0);
        //TreePath path = new TreePath(docroot.getUserObjectPath());
        //canvas_.expandPath(path);
        //}
        //else{
        //canvas_.expandRow(0);
        //}

        //DefaultTreeCellRenderer cellr = new DefaultTreeCellRenderer();
        //cellr.setLeafIcon(null);
        //cellr.setClosedIcon(null);
        //cellr.setOpenIcon(null);
        //canvas_.setCellRenderer(cellr);
        //canvas_.setEditable(true);
        //canvas_.putClientProperty("JTree.lineStyle", "Angled");

        pane_ = new JScrollPane(canvas_);
        canvas_.setMinimumSize(new Dimension(250, 500));
        pane_.setMinimumSize(new Dimension(2000, 2000));
        pane_.setPreferredSize(new Dimension(2000, 2000));
        pane_.setDoubleBuffered(true);
        canvas_.setDoubleBuffered(true);
        canvas_.expandRow(0);
    }
    //canvas_.expandAll(true);
    return pane_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 2:39:57 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int replace(java.lang.String srch, java.lang.String rep, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:33:40 AM)
 */
public void requestActions() {}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:33:40 AM)
 */
public void requestComponents() {}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:33:30 AM)
 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup newActionLookup) {
	actionLookup_ = newActionLookup;
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:33:30 AM)
 * @param newComponentLookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(butterfly.components.interfaces.IComponentLookup newComponentLookup) {
	componentLookup_ = newComponentLookup;
}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:29 AM)
 * @param start int
 */
public void setSelectionEnd(int end) {}
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:34:29 AM)
 * @param start int
 */
public void setSelectionStart(int start) {}
/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#addNodeSelectionListener(INodeSelectionListener)
	 */
	public void addNodeSelectionListener(INodeSelectionListener l) {
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#removeNodeSelectionListener(INodeSelectionListener)
	 */
	public void removeNodeSelectionListener(INodeSelectionListener l) {
	}

	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		canvas_.requestFocus();
		canvas_.setSelection(start,length);
	}

}
