/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

import javax.swing.text.WrappedPlainView;

import butterfly.xmlview.gui.interfaces.IMarkerView;
import butterfly.xmlview.model.Marker;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
/**
 * Insert the type's description here.
 * Creation date: (11/3/2002 7:49:40 PM)
 * @author: 
 */
public class XmlView extends WrappedPlainView {
	private Color defaultcolor = Color.black;
	private Color ltColor_ = Color.blue;
	private Color gtColor_ = Color.blue;
	private Color elementNameColor_ = Color.blue;
	private Color attributeNameColor_ = Color.gray;
	private Color attributeValueColor_ = Color.green;
	private Color bodyColor_ = Color.black;
	private Color leftBracketColor_ = Color.magenta;
	private Color rightBracketColor_ = Color.magenta;
	private Color colonColor_ = Color.magenta;
	private Color apostropheColor_ = Color.green;
	private Color errorColor_ = Color.red;
	//private Marker errorMarker_ = new Marker("",IMarker.ERROR_MARKER,-1);
	private int stateStartPosition_ = -1;
	boolean intag = false;
	boolean intagname = false;
	boolean inattribute = false;
	boolean incomment = false;
	boolean indtd = false;
	boolean inpi = false;
	boolean inattr = false;
	/**
	 * XmlView constructor comment.
	 * @param elem javax.swing.text.Element
	 */
	public XmlView(javax.swing.text.Element elem) {
		super(elem);
	}
	
	protected int getRunLength(int tagstart, int taglength, int index, int p1){
		int leftadjust = 0;
		int rightadjust = 0;
		int tagend = (taglength + tagstart);
		
		if(index > tagstart){
			leftadjust = (index - tagstart);
		}
		
		if(tagend > p1){
			rightadjust = tagend - p1;	
		}
		
		return (taglength - leftadjust - rightadjust);
	}
	
	
	
	
	protected int getRunLength(ISourceNode node, int index, int p1){
		int length = 1;
		if(index >= (node.getStart() + node.getLength())){
			if(node instanceof ISourceElement){
				ISourceElement sel = (ISourceElement)node;
				length = getRunLength(sel.getEndTagStart(),sel.getEndTagLength(),index,p1);
			}
		}
		else{
			length = getRunLength(node.getStart(),node.getLength(),index,p1);
		}
		return length;
	}
	
	protected void drawWavyLine(Graphics g, int x, int y, int x2, int y2,Color c){
		int starty = y;
		int ymax = y+2;
		int dx = 1;
		int dy = 1;
		boolean increase = true;
		Color old = g.getColor();
		g.setColor(c);
		while(x <= x2){
			g.drawLine(x,y,x+dx,y+dy);
			
			x += dx;
			if(increase){
				y += dy;
			}
			else{
				y -= dy;	
			}
			if(y == starty){
				increase = true;	
			}
			if(y == ymax){
				increase = false;	
			}
		}
		g.setColor(old);
	}
	
	protected int drawUnselectedText(
		java.awt.Graphics g,
		int x,
		int y,
		int p0,
		int p1)
		throws javax.swing.text.BadLocationException {

		if (XmlEditorKit.getXmlDocument(getDocument()) != null) {
			int index = p0;
			int length = 0;
			javax.swing.text.Segment text = getLineBuffer();

			getDocument().getText(p0, p1 - p0, text);

			javax.swing.text.Segment edited = new javax.swing.text.Segment();

			//look in the current line for key items
			char[] charbuffer = text.toString().toCharArray();

			java.awt.Color current = defaultcolor;
			IModelToSourceMapping mapping = (IModelToSourceMapping)XmlEditorKit.getXmlDocument(getDocument());

			while ((index - p0) < charbuffer.length) {
				ISourceNode node = mapping.nodeAt(index);
				//System.out.println("node at:"+index+" is "+node+mapping.toString());
				
				//System.out.println("index:"+index+" length:"+length);
				
				
				if(node != null){
					length = getRunLength(node,index,p1);
				}
				else{
						length = 1;
				}
				
				
				if(length <= 0){length = 1;}
				//System.out.println("index:"+index+" length:"+length);
				getDocument().getText(index,length, edited);
				if(node instanceof IElement){
					current = elementNameColor_;
				}
				else if(node instanceof IScratchTag){
					current = Color.red;	
					g.setColor(current);
					FontMetrics metrics = g.getFontMetrics();
					int width = metrics.stringWidth(edited.toString());
					int descent = metrics.getDescent();
					//g.drawLine(x,y,x+width,y);
					drawWavyLine(g,x,y-1,x+width,y-1,Color.red);
					//System.out.println("underline");
				}
				else{
					current = defaultcolor;	
				}
				if(node != null){
				if(node.hasWarningMarkers()){
						//current = Color.ORANGE;
						FontMetrics metrics = g.getFontMetrics();
						int width = metrics.stringWidth(edited.toString());
						int descent = metrics.getDescent();
						//g.drawLine(x,y,x+width,y);
						drawWavyLine(g,x,y-1,x+width,y-1,Color.MAGENTA);
					
				}
			
				if(getContainer() instanceof IMarkerView && node.getStart()<=index && index <= node.getStart()+node.getLength()){
				IMarker[] markers = node.getMarkers();
				if(node instanceof IScratchTag){
					//markers = new Marker[]{errorMarker_};
				}
				if(markers != null){
					for(int i = 0; i < markers.length; i++){
						((IMarkerView)getContainer()).renderMarker(x,y-g.getFontMetrics().getAscent(),markers[i]);
					}
				}
				
				}
				}
				g.setColor(current);
				x =
					javax.swing.text.Utilities.drawTabbedText(
						edited,
						x,
						y,
						g,
						this,
						index);

				edited = new javax.swing.text.Segment();
				index += length;
			}
		} else {
			/*g.setColor(defaultcolor);
				Document doc = getDocument();
				doc.getText(p0, p1 - p0, getLineBuffer());
				return javax.swing.text.Utilities.drawTabbedText(getLineBuffer(), x, y, g, this, p0);      
			*/
			javax.swing.text.Segment text = getLineBuffer();

			getDocument().getText(p0, p1 - p0, text);

			javax.swing.text.Segment edited = new javax.swing.text.Segment();

			//look in the current line for key items
			char[] charbuffer = text.toString().toCharArray();

			java.awt.Color current = defaultcolor;
			java.awt.Color next = defaultcolor;

			if (p0 < stateStartPosition_ || stateStartPosition_ < 0) {
				intag = false;
				intagname = false;
				inattribute = false;
				incomment = false;
				indtd = false;
				inpi = false;
				inattr = false;
				stateStartPosition_ = p0;
			}

			for (int u = 0; u < charbuffer.length; u++) {

				if (intag || inattribute) {

					if (charbuffer[u] == '>' && !inattribute) {
						stateStartPosition_ = p0 + u;
						intag = false;
						intagname = false;
						current = gtColor_;
					} else if (charbuffer[u] == '<' && !inattribute) {
						intagname = false;
						intag = false;
						stateStartPosition_ = p0 + u;
						current = errorColor_;
					} else if (intagname && !inattribute) {
						current = elementNameColor_;
						if (charbuffer[u] == ' ') {
							intagname = false;
							stateStartPosition_ = p0 + u;
						}
						if (charbuffer[u] == '"') {
							current = errorColor_;
						}
					} else {
						if (charbuffer[u] == '"') {
							if (inattribute) {
								inattribute = false;
								stateStartPosition_ = p0 + u;
							} else {
								inattribute = true;
								stateStartPosition_ = p0 + u;
							}
							current = apostropheColor_;
						} else {
							if (inattribute) {
								current = attributeValueColor_;
							} else {
								current = attributeNameColor_;
							}
						}
					}

				} else {

					if (charbuffer[u] == '<') {

						stateStartPosition_ = p0 + u;
						intag = true;
						intagname = true;
						current = ltColor_;
					} else if (charbuffer[u] == '>') {
						current = errorColor_;
					} else {

						current = bodyColor_;
					}

				}
				getDocument().getText(p0 + u, 1, edited);

				g.setColor(current);
				x =
					javax.swing.text.Utilities.drawTabbedText(
						edited,
						x,
						y,
						g,
						this,
						p0);

				edited = new javax.swing.text.Segment();

			}
		}

		return x;
	}
	
	
	
	
}
