/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.Event;
import java.awt.event.KeyEvent;

import javax.swing.JTextPane;
import javax.swing.KeyStroke;

import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IXmlViewBrowserPane;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 6:05:36 PM)
 * @author: 
 */
public class XmlViewBrowserPane extends MultiViewComponent implements IXmlViewBrowserPane,IDocumentEditor{
	private IDocument document_;
	private JTextPane source_ = new JTextPane();
	private JTextPane html_ = new JTextPane();
	
	/*class ToggleSourceAction extends AbstractAction{
		private boolean viewSource_ = true;
		public void actionPerformed(ActionEvent ae){
			System.out.println("toggling view...");
			if(viewSource_){
				setContentType("text/styled");
				setText(document_.toString());	
				viewSource_ = false;
			}
			else{
				setContentType(document_.getContentType());
				setText(document_.toString());
				viewSource_ = true;
			}
		}	
	}*/
/**
 * XmlViewBrowserPane constructor comment.
 */
public XmlViewBrowserPane() {
	super();
	buildActions();
	addView("HTML",html_);
	addView("Source",source_);
}
/**
 * XmlViewBrowserPane constructor comment.
 * @param doc javax.swing.text.StyledDocument
 */
//public XmlViewBrowserPane(javax.swing.text.StyledDocument doc) {
//	super(doc);
//	buildActions();
//}

public String getText(){return html_.getText();}

protected void buildActions(){
	KeyStroke stroke = KeyStroke.getKeyStroke(KeyEvent.VK_V,Event.CTRL_MASK);
	//getKeymap().addActionForKeyStroke(stroke,new ToggleSourceAction());	
}


/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:34:19 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int find(java.lang.String srch, int index) {
	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:34:19 PM)
 * @param node butterfly.xmlview.model.interfaces.INode
 */
public void focusOnNode(butterfly.xmlview.model.interfaces.INode node) {}
/**
 * Insert the method's description here.
 * Creation date: (8/31/2002 1:27:55 AM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 */
public IDocument getIDocument() {
	return document_;
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:34:19 PM)
 * @return butterfly.xmlview.model.interfaces.INode[]
 */
public butterfly.xmlview.model.interfaces.INode[] getSelectedNodes() {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 10:18:51 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void loadDocument(butterfly.xmlview.model.interfaces.IDocument doc) {
	document_ = doc;
	html_.setContentType(doc.getContentType());
	html_.setText(doc.toString());
	source_.setContentType("text/styled");
	source_.setText(doc.toString());
}
/**
 * Insert the method's description here.
 * Creation date: (12/1/2002 3:34:19 PM)
 * @return int
 * @param srch java.lang.String
 * @param index int
 */
public int replace(java.lang.String srch, java.lang.String rep, int index) {
	return 0;
}
	/**
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
	}

}
