/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Hashtable;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

import butterfly.components.interfaces.IComponent;
/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @author: 
 */
public class XmlViewInformer extends javax.swing.JDialog implements butterfly.xmlview.gui.interfaces.IXmlViewInformer,IComponent{
private JFileChooser chooser_ = new JFileChooser();

private static int currentID_ = 0;
private static Hashtable openWindows_ = new Hashtable(3);
/**
 * XmlViewInformer constructor comment.
 */
public XmlViewInformer() {
	super();
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Dialog
 */
public XmlViewInformer(java.awt.Dialog owner) {
	super(owner);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Dialog
 * @param title java.lang.String
 */
public XmlViewInformer(java.awt.Dialog owner, String title) {
	super(owner, title);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Dialog
 * @param title java.lang.String
 * @param modal boolean
 */
public XmlViewInformer(java.awt.Dialog owner, String title, boolean modal) {
	super(owner, title, modal);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Dialog
 * @param modal boolean
 */
public XmlViewInformer(java.awt.Dialog owner, boolean modal) {
	super(owner, modal);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Frame
 */
public XmlViewInformer(java.awt.Frame owner) {
	super(owner);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Frame
 * @param title java.lang.String
 */
public XmlViewInformer(java.awt.Frame owner, String title) {
	super(owner, title);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Frame
 * @param title java.lang.String
 * @param modal boolean
 */
public XmlViewInformer(java.awt.Frame owner, String title, boolean modal) {
	super(owner, title, modal);
}
/**
 * XmlViewInformer constructor comment.
 * @param owner java.awt.Frame
 * @param modal boolean
 */
public XmlViewInformer(java.awt.Frame owner, boolean modal) {
	super(owner, modal);
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public int displayConfirmation(String msg) {
	int accept = JOptionPane.showConfirmDialog(this,msg);
	return accept;
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public void displayError(String msg) {
	JOptionPane.showMessageDialog(this,msg,"Butterfly Error",JOptionPane.ERROR_MESSAGE);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public String displayFileQuery(String msg) {
	
    // Note: source for ExampleFileFilter can be found in FileChooserDemo,
    // under the demo/jfc directory in the Java 2 SDK, Standard Edition.
//    ExampleFileFilter filter = new ExampleFileFilter();
//    filter.addExtension("jpg");
//    filter.addExtension("gif");
//    filter.setDescription("JPG & GIF Images");
    //chooser_.setFileFilter(filter);
    int returnVal = chooser_.showOpenDialog(null);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
      // System.out.println("You chose to open this file: " +
            return chooser_.getSelectedFile().getAbsolutePath();
    }
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public void displayMessage(String msg) {
	JOptionPane.showMessageDialog(this,msg);	
}

public  Object displayTransientMessage(String msg) {
	final JDialog d = new JDialog();
	d.getContentPane().setLayout(new BorderLayout());
	d.getContentPane().add(new JLabel(msg),BorderLayout.CENTER);
	Object key = createWindowID();
	openWindows_.put(key,d);
	d.pack();
	d.setSize(300,80);
	Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
	int x = size.width/2 - d.getWidth()/2;
	int y = size.height/2 - d.getHeight()/2;
	d.setLocation(x,y);
	
	Runnable r = new Runnable(){
		public void run(){
			d.show();
		}
	};
	try{
		SwingUtilities.invokeLater(r);
	}catch(Exception e){}
	
	return key;	
}

public  void closeWindow(Object id){
	Window w = (Window)openWindows_.get(id);
	if(w != null){
		w.setVisible(false);	
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public Hashtable displayQuery(String msg, java.lang.String[] fields) {
	JOptionPane pane = new JOptionPane(msg);
	Hashtable vmap = new Hashtable();
	int where = 1;
	for(int i = 0; i < fields.length; i++){
		pane.add(new JLabel(fields[i]),where);
		JTextField val = new JTextField();
		vmap.put(fields[i],val);
		pane.add(val,where+1);
		where +=2;
	}
	JDialog dialog = pane.createDialog(new JFrame(), msg);
	dialog.show();
	for(int i = 0; i < fields.length; i++){
		JTextField val = (JTextField)vmap.get(fields[i]);
		vmap.put(fields[i],val.getText());
	}
	return vmap;
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public void displayWarning(String msg) {
	JOptionPane.showMessageDialog(this,msg,"Butterfly Warning",JOptionPane.WARNING_MESSAGE);	
}

/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:46:26 PM)
 * @param msg java.lang.String
 */
public String displayQuery(String msg) {
	return JOptionPane.showInputDialog(this,msg);
}

private static Object createWindowID(){
	currentID_++;
	return new Integer(currentID_);
}

}
